#ifdef VHDL
/*
 * $Id: Decod_vhdl_body.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {

#define instruction_illegale(tab,num_inst) vhdl->set_comment(tab," ILLEGAL INSTRUCTION  --");\
  vhdl->set_body(tab,"internal_DECOD_INSTRUCTION_"+toString(num_inst)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_ILLEGAL_INSTRUCTION)+"; ");	\
  vhdl->set_body(tab,"internal_DECOD_INSTRUCTION_"+toString(num_inst)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_ILLEGAL_INSTRUCTION)+"; "); \
  vhdl->set_body(tab,"if internal_DECOD_INSTRUCTION_"+toString(num_inst)+"_IS_DELAY_SLOT = '1' then ");	\
  vhdl->set_body(tab + 1,"internal_DECOD_INSTRUCTION_"+toString(num_inst)+"_ADDRESS_NEXT <= internal_CONTEXT_0_ADDRESS_PREVIOUS; "); \
  vhdl->set_body(tab,"else ");						\
  vhdl->set_body(tab + 1,"internal_DECOD_INSTRUCTION_"+toString(num_inst)+"_ADDRESS_NEXT <= internal_DECOD_INSTRUCTION_"+toString(num_inst)+"_ADDRESS; "); \
  vhdl->set_body(tab,"end if;");					\
  vhdl->set_body(tab,"internal_DECOD_INSTRUCTION_"+toString(num_inst)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_EXCEPTION)+"; ");    

#undef  FUNCTION
#define FUNCTION "Decod::vhdl_body"
  void Decod::vhdl_body (Vhdl * & vhdl)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    std::string extend_signal;

    for(uint32_t i = 0;i < _param->_nb_inst_decod;i++){
      vhdl->set_body(0,"internal_DECOD_INSTRUCTION_"+toString(i)+" <= in_IFETCH_0_"+toString(i)+"_INSTRUCTION WHEN in_IFETCH_0_EXCEPTION = "+std_logic_cst(_param->_size_exception_ifetch,EXCEPTION_IFETCH_NONE)+" ELSE "+std_logic_cst(6,OPCOD_10)+" & "+std_logic_cst(2,OPCOD_L_NOP)+" & X\"000000\" ;");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_VAL <= internal_DECOD_"+toString(i)+"_VAL; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_TYPE <= internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_OPERATION <= internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_HAS_IMMEDIAT <= internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_IMMEDIAT <= internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_READ_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_READ_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_READ_RC <= internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_NUM_REG_RC <= internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_WRITE_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_WRITE_RE <= internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_NUM_REG_RE <= internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_EXCEPTION_USE <= internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_EXCEPTION <= internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION WHEN in_IFETCH_0_EXCEPTION = "+std_logic_cst(_param->_size_exception_ifetch,EXCEPTION_IFETCH_NONE)+" ELSE "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_NO_EXECUTE <= internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE; ");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_IS_DELAY_SLOT <= internal_DECOD_INSTRUCTION_"+toString(i)+"_IS_DELAY_SLOT; ");
#ifdef DEBUG
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_ADDRESS <= internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS; ");
#endif
      vhdl->set_body(0,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS <= in_IFETCH_0_ADDRESS + "+std_logic_cst(_param->_size_instruction_address,i)+" ;");
      vhdl->set_body(0,"out_DECOD_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(0,"internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= in_IFETCH_"+toString(i)+"_ADDRESS + '1'; ");
      vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_BRANCH_CONDITION <= internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION; ");
      vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_BRANCH_DIRECTION <= internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION; ");
      vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_ADDRESS_SRC <= internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS; ");
      vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_ADDRESS_DEST <= internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_BRANCH_STATE <= in_IFETCH_0_BRANCH_STATE; ");
      vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_VAL <= internal_PREDICT_"+toString(i)+"_VAL; ");

      if(_param->_have_port_depth) vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_BRANCH_UPDATE_PREDICTION_ID <= in_IFETCH_0_BRANCH_UPDATE_PREDICTION_ID; ");
      if(_param->_have_port_inst_ifetch_ptr) vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_MATCH_INST_IFETCH_PTR <= '1' WHEN in_IFETCH_0_INST_IFETCH_PTR = "+std_logic_cst(_param->_size_inst_ifetch_ptr,i)+" ELSE '0'; ");
      else vhdl->set_body(0,"out_PREDICT_"+toString(i)+"_MATCH_INST_IFETCH_PTR <= '1' WHEN internal_DECOD_INSTRUCTION_0_TYPE = "+std_logic_cst(_param->_size_type,TYPE_BRANCH)+" ELSE '0' ; ");
    }

    vhdl->set_body ("");

    if(_param->_have_port_context_id){

    }
    else{
    
      vhdl->set_body(0,"internal_DECOD_INSTRUCTION_0_IS_DELAY_SLOT <= reg_CONTEXT_0_IS_DELAY_SLOT; ");
      for(uint32_t i = 1;i < _param->_nb_inst_decod;i++){
	
	vhdl->set_body(0,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IS_DELAY_SLOT <= internal_HAVE_DECOD_BRANCH"+toString(i-1)+"; ");
      }
      
      vhdl->set_body(0,"out_CONTEXT_EVENT_VAL <= internal_CONTEXT_EVENT_VAL; ");
      vhdl->set_body(0,"out_CONTEXT_EVENT_TYPE <= internal_DECOD_INSTRUCTION_0_EVENT_TYPE WHEN in_IFETCH_0_EXCEPTION = "+std_logic_cst(_param->_size_exception_ifetch,EXCEPTION_IFETCH_NONE)+" ELSE "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_EXCEPTION)+"; ");
      vhdl->set_body(0,"out_CONTEXT_EVENT_ADDRESS <= internal_DECOD_INSTRUCTION_0_ADDRESS; ");
      vhdl->set_body(0,"out_CONTEXT_EVENT_ADDRESS_EPCR <= internal_DECOD_INSTRUCTION_0_ADDRESS_NEXT; ");
      vhdl->set_body(0,"out_CONTEXT_EVENT_IS_DELAY_SLOT <= reg_CONTEXT_0_IS_DELAY_SLOT; ");
      for(uint32_t i = 0;i < _param->_nb_inst_decod;i++) vhdl->set_body(0,"out_IFETCH_0_"+toString(i)+"_ACK <= internal_IFETCH_0_"+toString(i)+"_ACK; ");
    }
    
    vhdl->set_body(0,"");

    vhdl->set_body(0,"internal_CONTEXT_EVENT_VAL <= internal_DECOD_0_VAL AND internal_IFETCH_0_0_ACK WHEN internal_DECOD_INSTRUCTION_0_EVENT_TYPE /= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+" ELSE '0'; ");

    for(uint32_t x = 0;x < _param->_nb_context;x++){
      if(_param->_nb_inst_decod <= 1){
	vhdl->set_body(0,"internal_HAVE_DECOD_BRANCH_0 <= '0'; ");
	vhdl->set_body(0,"internal_CAN_CONTINUE_"+toString(x)+" <= in_CONTEXT_"+toString(x)+"_DECOD_ENABLE; ");
      }
      else{
	vhdl->set_body(0,"internal_CAN_CONTINUE_"+toString(x)+" <= in_CONTEXT_"+toString(x)+"_DECOD_ENABLE WHEN internal_DECOD_INSTRUCTION_0_TYPE /= "+std_logic_cst(_param->_size_type,TYPE_BRANCH)+" ELSE ( in_CONTEXT_"+toString(x)+"_DECOD_ENABLE AND in_PREDICT_0_CAN_CONTINUE ); ");
	for(uint32_t i = 1;i < _param->_nb_inst_decod;i++) vhdl->set_body(0,"internal_HAVE_DECOD_BRANCH_"+toString(i)+" <= internal_DECOD_BRANCH_"+toString(i-1)+"_VAL; ");
      }
      vhdl->set_body(0,"internal_CONTEXT_"+toString(x)+"_HAVE_TRANSACTION <= internal_IFETCH_"+toString(x)+"_0_ACK ");
      for (uint32_t y = 1; y < _param->_nb_inst_fetch[x]; y++) vhdl->set_body(1,"OR internal_IFETCH_"+toString(x)+"_"+toString(y)+"_ACK ");
      vhdl->set_body(0,";");
    }

    if(_param->_nb_inst_decod <= 1){
	
	vhdl->set_body(0,"internal_DECOD_BRANCH_0_VAL <= in_PREDICT_0_ACK WHEN internal_DECOD_INSTRUCTION_0_TYPE = "+std_logic_cst(_param->_size_type,TYPE_BRANCH)+" ELSE '1'; ");
	vhdl->set_body(0,"internal_DECOD_CONTEXT_EVENT_0_VAL <= in_CONTEXT_EVENT_ACK WHEN internal_DECOD_INSTRUCTION_0_EVENT_TYPE /= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+" ELSE '1'; ");
	vhdl->set_body(0,"internal_DECOD_0_VAL <= (( in_IFETCH_0_0_VAL AND internal_CAN_CONTINUE_0 ) AND in_CONTEXT_0_DEPTH_VAL ) AND internal_DECOD_BRANCH_0_VAL AND internal_DECOD_CONTEXT_EVENT_0_VAL; ");
	vhdl->set_body(0,"internal_IFETCH_0_0_ACK <= ((( in_IFETCH_0_0_VAL AND internal_CAN_CONTINUE_0 ) AND in_DECOD_0_ACK ) AND in_CONTEXT_0_DEPTH_VAL ) AND internal_DECOD_BRANCH_0_VAL AND internal_DECOD_CONTEXT_EVENT_0_VAL; ");

	vhdl->set_body(0,"internal_PREDICT_0_VAL <= NOT( internal_HAVE_DECOD_BRANCH_0 ) AND in_IFETCH_0_0_VAL AND internal_CAN_CONTINUE_0 AND in_CONTEXT_0_DEPTH_VAL AND in_DECOD_0_ACK WHEN internal_DECOD_INSTRUCTION_0_TYPE = "+std_logic_cst(_param->_size_type,TYPE_BRANCH)+" ELSE '0'; ");
    }
    else{ // TO DO
      for(uint32_t i = 0;i < _param->_nb_inst_decod;i++){
	vhdl->set_body(0,"internal_PREDICT_"+toString(i)+"_VAL <= NOT( internal_HAVE_DECOD_BRANCH_0 ) AND in_DECOD_"+toString(i)+"_ACK AND in_CONTEXT_0_DEPTH_VAL WHEN ( in_IFETCH_0_0_VAL AND internal_CAN_CONTINUE_0 ) = '1' ELSE '0'; ");
	
	vhdl->set_body(0,"internal_DECOD_BRANCH_"+toString(i)+"_VAL <= ( in_PREDICT_"+toString(i)+"_ACK AND NOT internal_HAVE_DECOD_BRANCH_0 ) OR NOT( internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE = "+std_logic_cst(_param->_size_type,TYPE_BRANCH)+" ); ");
	vhdl->set_body(0,"internal_DECOD_CONTEXT_EVENT_"+toString(i)+"_VAL <= in_CONTEXT_EVENT_ACK OR NOT( internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE = "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+" ); ");
	vhdl->set_body(0,"internal_DECOD_"+toString(i)+"_VAL <= (( in_IFETCH_0_0_VAL AND internal_CAN_CONTINUE_0 ) AND in_CONTEXT_0_DEPTH_VAL ) AND internal_DECOD_BRANCH_"+toString(i)+"_VAL AND internal_DECOD_CONTEXT_EVENT_"+toString(i)+"_VAL; ");
      }
    }

    vhdl->set_body(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Case process                    ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_body(0,"");
    
    for(uint32_t i = 0;i < _param->_nb_inst_decod;i++){
      vhdl->set_body(0,"case_DECOD_INST_"+toString(i)+": process (internal_DECOD_INSTRUCTION_"+toString(i)+")");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_0  : "+std_logic(6)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_1  : "+std_logic(8)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_2  : "+std_logic(8)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_3  : "+std_logic(6)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_4  : "+std_logic(5)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_5  : "+std_logic(5)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_6  : "+std_logic(2)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_7  : "+std_logic(4)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_8  : "+std_logic(1)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_9  : "+std_logic(3)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_10 : "+std_logic(2)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_11 : "+std_logic(2)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_12 : "+std_logic(4)+";");
      vhdl->set_body(1,"variable internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_13 : "+std_logic(4)+";");
      
      vhdl->set_body(0,"begin");

      //vhdl->set_body(1,"if in_IFETCH_0_EXCEPTION = "+std_logic_cst(_param->_size_exception_ifetch,EXCEPTION_IFETCH_NONE)+" then");
      //vhdl->set_body(2,"internal_DECOD_INSTRUCTION_"+toString(i)+" <= in_IFETCH_0_"+toString(i)+"_INSTRUCTION ;");
      //vhdl->set_body(1,"else");
      //vhdl->set_body(2,"internal_DECOD_INSTRUCTION_"+toString(i)+" <= "+std_logic_cst(6,OPCOD_10)+" & "+std_logic_cst(2,OPCOD_L_NOP)+" & X\"000000\" ;");
      //vhdl->set_body(1,"end if;");


#ifdef SYSTEMC_VHDL_COMPATIBILITY
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE    <= "+std_logic_cst(1,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE          <= "+std_logic_cst(_param->_size_type,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION     <= "+std_logic_cst(_param->_size_operation,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT  <= "+std_logic_cst(1,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT      <= "+std_logic_cst(_param->_size_general_data,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA       <= "+std_logic_cst(1,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA    <= "+std_logic_cst(_param->_size_general_register_logic,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB       <= "+std_logic_cst(1,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB    <= "+std_logic_cst(_param->_size_general_register_logic,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC       <= "+std_logic_cst(1,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC    <= "+std_logic_cst(_param->_size_special_register_logic,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD      <= "+std_logic_cst(1,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD    <= "+std_logic_cst(_param->_size_general_register_logic,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE      <= "+std_logic_cst(1,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE    <= "+std_logic_cst(_param->_size_special_register_logic,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION     <= "+std_logic_cst(_param->_size_exception_decod,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,0)+";");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION <= "+std_logic_cst(1,0)+";");
#endif		

      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_0  := internal_DECOD_INSTRUCTION_"+toString(i)+"(31 downto 26); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_1  := internal_DECOD_INSTRUCTION_"+toString(i)+"(7 downto 0); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_2  := internal_DECOD_INSTRUCTION_"+toString(i)+"(7 downto 0); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_3  := internal_DECOD_INSTRUCTION_"+toString(i)+"(9 downto 8) & internal_DECOD_INSTRUCTION_"+toString(i)+"(3 downto 0); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_4  := internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_5  := internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_6  := internal_DECOD_INSTRUCTION_"+toString(i)+"(7 downto 6); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_7  := internal_DECOD_INSTRUCTION_"+toString(i)+"(3 downto 0); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_8  := internal_DECOD_INSTRUCTION_"+toString(i)+"(16); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_9  := internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 23); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_10 := internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 24); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_11 := internal_DECOD_INSTRUCTION_"+toString(i)+"(7 downto 6); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_12 := internal_DECOD_INSTRUCTION_"+toString(i)+"(9 downto 6); ");
      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_13 := internal_DECOD_INSTRUCTION_"+toString(i)+"(9 downto 6); ");

      vhdl->set_body(1,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT  <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT;");

      vhdl->set_body(1,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_0 is");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_J)+" => ");
      vhdl->set_comment(2," OPCOD_L_J  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_J
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_J)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_J)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_instruction_address - 26;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= in_IFETCH_"+toString(i)+"_ADDRESS + ( "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 0) ); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_JAL)+" => ");
      vhdl->set_comment(2," OPCOD_L_JAL  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_JAL
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_JAL)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_JAL)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \"00\" & internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT + '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= "+std_logic_cst(_param->_size_general_register_logic,9)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,BRANCH_CONDITION_NONE_WITH_WRITE_STACK)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_instruction_address - 26;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= in_IFETCH_"+toString(i)+"_ADDRESS + ( "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 0) ); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_BNF)+" => ");
      vhdl->set_comment(2," OPCOD_L_BNF  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_BNF
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_BNF)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_BNF)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 26;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \"00\" & in_IFETCH_"+toString(i)+"_ADDRESS + ( "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 0) ); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,BRANCH_CONDITION_FLAG_UNSET)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_instruction_address - 26;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= in_IFETCH_"+toString(i)+"_ADDRESS + ( "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 0) ); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_BF)+" => ");
      vhdl->set_comment(2," OPCOD_L_BF  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_BF
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_BF)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_BF)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 26;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \"00\" & in_IFETCH_"+toString(i)+"_ADDRESS + ( "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 0) ); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,BRANCH_CONDITION_FLAG_SET)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_instruction_address - 26;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= in_IFETCH_"+toString(i)+"_ADDRESS + ( "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 0) ); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_RFE)+" => ");
      vhdl->set_comment(2," OPCOD_L_RFE  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_RFE
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_RFE)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_RFE)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '1'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_JR)+" => ");
      vhdl->set_comment(2," OPCOD_L_JR  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_JR
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_JR)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_JR)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11) = "+std_logic_cst(_param->_size_general_register_logic,9)+" then ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,BRANCH_CONDITION_READ_STACK)+"; ");
      vhdl->set_body(3,"else ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,BRANCH_CONDITION_READ_REGISTER_WITHOUT_WRITE_STACK)+"; ");
      vhdl->set_body(3,"end if; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_JALR)+" => ");
      vhdl->set_comment(2," OPCOD_L_JALR  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_JALR
      
      vhdl->set_body(3,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11) = "+std_logic_cst(_param->_size_general_register_logic,9)+" then ");
      instruction_illegale(3,i)
      // illegal instruction
      vhdl->set_body(3,"else ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_JALR)._type)+"; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_JALR)._operation)+"; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \"00\" & internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT + '1'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= "+std_logic_cst(_param->_size_general_register_logic,9)+"; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION <= "+std_logic_cst(_param->_size_branch_condition,BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK)+"; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION <= '1'; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(4,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      vhdl->set_body(3,"end if; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_MACI)+" => ");
      vhdl->set_comment(2," OPCOD_L_MACI  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_MACI
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MACI)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MACI)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 21) & internal_DECOD_INSTRUCTION_"+toString(i)+" (10 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_SPR_ACCESS)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST1)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST1  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST1

      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST2)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST2  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST2
      
      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST3)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST3  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST3
      
      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST4)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST4  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST4
      
      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST5)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST5  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST5
      
      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST6)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST6  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST6
      
      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST7)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST7  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST7
      
      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_CUST8)+" => ");
      vhdl->set_comment(2," OPCOD_L_CUST8  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_CUST8
      
      instruction_illegale(2,i)
      // illegal instruction
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_LD)+" => ");
      vhdl->set_comment(2," OPCOD_L_LD  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_LD
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_LD)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_LD)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_LWS)+" => ");
      vhdl->set_comment(2," OPCOD_L_LWS  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_LWS
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_LWS)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_LWS)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_LWZ)+" => ");
      vhdl->set_comment(2," OPCOD_L_LWZ  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_LWZ
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_LWZ)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_LWZ)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_LBS)+" => ");
      vhdl->set_comment(2," OPCOD_L_LBS  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_LBS
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_LBS)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_LBS)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_LBZ)+" => ");
      vhdl->set_comment(2," OPCOD_L_LBZ  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_LBZ
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_LBZ)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_LBZ)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_LHS)+" => ");
      vhdl->set_comment(2," OPCOD_L_LHS  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_LHS
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_LHS)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_LHS)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_LHZ)+" => ");
      vhdl->set_comment(2," OPCOD_L_LHZ  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_LHZ
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_LHZ)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_LHZ)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_ADDI)+" => ");
      vhdl->set_comment(2," OPCOD_L_ADDI  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_ADDI
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_ADDI)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_ADDI)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_ADDIC)+" => ");
      vhdl->set_comment(2," OPCOD_L_ADDIC  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_ADDIC
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_ADDIC)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_ADDIC)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_ANDI)+" => ");
      vhdl->set_comment(2," OPCOD_L_ANDI  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_ANDI
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_ANDI)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_ANDI)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "0";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_ORI)+" => ");
      vhdl->set_comment(2," OPCOD_L_ORI  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_ORI
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_ORI)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_ORI)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "0";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_XORI)+" => ");
      vhdl->set_comment(2," OPCOD_L_XORI  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_XORI
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_XORI)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_XORI)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_MULI)+" => ");
      vhdl->set_comment(2," OPCOD_L_MULI  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_MULI
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MULI)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MULI)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_MFSPR)+" => ");
      vhdl->set_comment(2," OPCOD_L_MFSPR  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_MFSPR
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MFSPR)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MFSPR)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "0";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_SPR_ACCESS)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_MTSPR)+" => ");
      vhdl->set_comment(2," OPCOD_L_MTSPR  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_MTSPR
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MTSPR)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MTSPR)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "0";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 21) & internal_DECOD_INSTRUCTION_"+toString(i)+" (10 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_SPR_ACCESS)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_SD)+" => ");
      vhdl->set_comment(2," OPCOD_L_SD  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_SD
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SD)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SD)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 21) & internal_DECOD_INSTRUCTION_"+toString(i)+" (10 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_SW)+" => ");
      vhdl->set_comment(2," OPCOD_L_SW  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_SW
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SW)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SW)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 21) & internal_DECOD_INSTRUCTION_"+toString(i)+" (10 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_SB)+" => ");
      vhdl->set_comment(2," OPCOD_L_SB  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_SB
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SB)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SB)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 21) & internal_DECOD_INSTRUCTION_"+toString(i)+" (10 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_L_SH)+" => ");
      vhdl->set_comment(2," OPCOD_L_SH  --");
      
      // TYPE_0  IMMEDIAT
      // OPCOD_L_SH
      
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SH)._type)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SH)._operation)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(25) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (25 downto 21) & internal_DECOD_INSTRUCTION_"+toString(i)+" (10 downto 0); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_MEMORY_WITH_ALIGNMENT)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_1)+" => ");
      vhdl->set_comment(2," OPCOD_1  ORFPX32/64  --");
      
      // TYPE_1  ORFPX32/64
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_1 is");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_2)+" => ");
      vhdl->set_comment(2," OPCOD_2  ORVDX64  --");
      
      // TYPE_2  ORVDX64
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_2 is");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_3)+" => ");
      vhdl->set_comment(2," OPCOD_3  Register-Register  --");
      
      // TYPE_3  Register-Register
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_3 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_ADD)+" => ");
      vhdl->set_comment(4," OPCOD_L_ADD  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_ADD
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_ADD)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_ADD)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_ADDC)+" => ");
      vhdl->set_comment(4," OPCOD_L_ADDC  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_ADDC
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_ADDC)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_ADDC)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_SUB)+" => ");
      vhdl->set_comment(4," OPCOD_L_SUB  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_SUB
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SUB)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SUB)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_AND)+" => ");
      vhdl->set_comment(4," OPCOD_L_AND  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_AND
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_AND)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_AND)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_OR)+" => ");
      vhdl->set_comment(4," OPCOD_L_OR  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_OR
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_OR)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_OR)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_XOR)+" => ");
      vhdl->set_comment(4," OPCOD_L_XOR  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_XOR
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_XOR)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_XOR)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_CMOV)+" => ");
      vhdl->set_comment(4," OPCOD_L_CMOV  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_CMOV
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_CMOV)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_CMOV)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_FF1)+" => ");
      vhdl->set_comment(4," OPCOD_L_FF1  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_FF1
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_FF1)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_FF1)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_FL1)+" => ");
      vhdl->set_comment(4," OPCOD_L_FL1  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_FL1
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_FL1)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_FL1)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_MUL)+" => ");
      vhdl->set_comment(4," OPCOD_L_MUL  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_MUL
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MUL)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MUL)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_DIV)+" => ");
      vhdl->set_comment(4," OPCOD_L_DIV  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_DIV
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_DIV)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_DIV)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_DIVU)+" => ");
      vhdl->set_comment(4," OPCOD_L_DIVU  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_DIVU
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_DIVU)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_DIVU)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_L_MULU)+" => ");
      vhdl->set_comment(4," OPCOD_L_MULU  --");
      
      // TYPE_3  Register-Register
      // OPCOD_L_MULU
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MULU)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MULU)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_CY_OV)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_RANGE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_11)+" => ");
      vhdl->set_comment(4," OPCOD_11  Shift/Rotate with register  --");
      
      // TYPE_11  Shift/Rotate with register
      
      vhdl->set_body(5,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_11 is");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(2,OPCOD_L_SLL)+" => ");
      vhdl->set_comment(6," OPCOD_L_SLL  --");
      
      // TYPE_11  Shift/Rotate with register
      // OPCOD_L_SLL
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SLL)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SLL)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(2,OPCOD_L_SRL)+" => ");
      vhdl->set_comment(6," OPCOD_L_SRL  --");
      
      // TYPE_11  Shift/Rotate with register
      // OPCOD_L_SRL
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SRL)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SRL)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(2,OPCOD_L_SRA)+" => ");
      vhdl->set_comment(6," OPCOD_L_SRA  --");
      
      // TYPE_11  Shift/Rotate with register
      // OPCOD_L_SRA
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SRA)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SRA)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(2,OPCOD_L_ROR)+" => ");
      vhdl->set_comment(6," OPCOD_L_ROR  --");
      
      // TYPE_11  Shift/Rotate with register
      // OPCOD_L_ROR
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_ROR)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_ROR)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN others => ");
      instruction_illegale(6,i)
      
      // TYPE_11  Shift/Rotate with register
      // illegal instruction
      
      vhdl->set_body(5,"end case;");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_12)+" => ");
      vhdl->set_comment(4," OPCOD_12  extend  --");
      
      // TYPE_12  extend
      
      vhdl->set_body(5,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_12 is");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(4,OPCOD_L_EXTHS)+" => ");
      vhdl->set_comment(6," OPCOD_L_EXTHS  --");
      
      // TYPE_12  extend
      // OPCOD_L_EXTHS
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_EXTHS)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_EXTHS)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+std_logic_cst(_param->_size_general_data,16)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(4,OPCOD_L_EXTHZ)+" => ");
      vhdl->set_comment(6," OPCOD_L_EXTHZ  --");
      
      // TYPE_12  extend
      // OPCOD_L_EXTHZ
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_EXTHZ)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_EXTHZ)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+std_logic_cst(_param->_size_general_data,16)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(4,OPCOD_L_EXTBS)+" => ");
      vhdl->set_comment(6," OPCOD_L_EXTBS  --");
      
      // TYPE_12  extend
      // OPCOD_L_EXTBS
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_EXTBS)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_EXTBS)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+std_logic_cst(_param->_size_general_data,8)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(4,OPCOD_L_EXTBZ)+" => ");
      vhdl->set_comment(6," OPCOD_L_EXTBZ  --");
      
      // TYPE_12  extend
      // OPCOD_L_EXTBZ
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_EXTBZ)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_EXTBZ)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+std_logic_cst(_param->_size_general_data,8)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN others => ");
      instruction_illegale(6,i)
      
      // TYPE_12  extend
      // illegal instruction
      
      vhdl->set_body(5,"end case;");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(6,OPCOD_13)+" => ");
      vhdl->set_comment(4," OPCOD_13  extend (64b)  --");
      
      // TYPE_13  extend (64b)
      
      vhdl->set_body(5,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_13 is");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(4,OPCOD_L_EXTWS)+" => ");
      vhdl->set_comment(6," OPCOD_L_EXTWS  --");
      
      // TYPE_13  extend (64b)
      // OPCOD_L_EXTWS
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_EXTWS)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_EXTWS)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+std_logic_cst(_param->_size_general_data,32)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN "+std_logic_cst(4,OPCOD_L_EXTWZ)+" => ");
      vhdl->set_comment(6," OPCOD_L_EXTWZ  --");
      
      // TYPE_13  extend (64b)
      // OPCOD_L_EXTWZ
      
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_EXTWZ)._type)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_EXTWZ)._operation)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+std_logic_cst(_param->_size_general_data,32)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(7,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(6,"WHEN others => ");
      instruction_illegale(6,i)
      
      // TYPE_13  extend (64b)
      // illegal instruction
      
      vhdl->set_body(5,"end case;");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_3  Register-Register
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_4)+" => ");
      vhdl->set_comment(2," OPCOD_4  Set flag with register  --");
      
      // TYPE_4  Set flag with register
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_4 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFEQ)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFEQ  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFEQ
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFEQ)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFEQ)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFNE)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFNE  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFNE
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFNE)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFNE)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGTU)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGTU  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFGTU
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGTU)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGTU)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGEU)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGEU  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFGEU
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGEU)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGEU)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLTU)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLTU  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFLTU
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLTU)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLTU)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLEU)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLEU  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFLEU
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLEU)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLEU)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGTS)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGTS  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFGTS
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGTS)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGTS)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGES)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGES  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFGES
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGES)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGES)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLTS)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLTS  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFLTS
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLTS)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLTS)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLES)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLES  --");
      
      // TYPE_4  Set flag with register
      // OPCOD_L_SFLES
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLES)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLES)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_4  Set flag with register
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_5)+" => ");
      vhdl->set_comment(2," OPCOD_5  Set flag with immediat  --");
      
      // TYPE_5  Set flag with immediat
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_5 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFEQI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFEQI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFEQI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFEQI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFEQI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFNEI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFNEI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFNEI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFNEI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFNEI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGTUI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGTUI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFGTUI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGTUI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGTUI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGEUI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGEUI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFGEUI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGEUI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGEUI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLTUI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLTUI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFLTUI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLTUI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLTUI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLEUI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLEUI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFLEUI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLEUI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLEUI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGTSI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGTSI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFGTSI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGTSI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGTSI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFGESI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFGESI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFGESI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFGESI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFGESI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLTSI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLTSI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFLTSI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLTSI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLTSI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(5,OPCOD_L_SFLESI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SFLESI  --");
      
      // TYPE_5  Set flag with immediat
      // OPCOD_L_SFLESI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SFLESI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SFLESI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "internal_DECOD_INSTRUCTION_"+toString(i)+"(15) & ";
      vhdl->set_body(3,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= "+extend_signal+"internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE <= "+std_logic_cst(_param->_size_special_register_logic,SPR_LOGIC_SR_F)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_5  Set flag with immediat
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_6)+" => ");
      vhdl->set_comment(2," OPCOD_6  Shift/Rotate with immediat  --");
      
      // TYPE_6  Shift/Rotate with immediat
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_6 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(2,OPCOD_L_SLLI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SLLI  --");
      
      // TYPE_6  Shift/Rotate with immediat
      // OPCOD_L_SLLI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SLLI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SLLI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 6;cp++) extend_signal += "0";
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (5 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(2,OPCOD_L_SRLI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SRLI  --");
      
      // TYPE_6  Shift/Rotate with immediat
      // OPCOD_L_SRLI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SRLI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SRLI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 6;cp++) extend_signal += "0";
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (5 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(2,OPCOD_L_SRAI)+" => ");
      vhdl->set_comment(4," OPCOD_L_SRAI  --");
      
      // TYPE_6  Shift/Rotate with immediat
      // OPCOD_L_SRAI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SRAI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SRAI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 6;cp++) extend_signal += "0";
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (5 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(2,OPCOD_L_RORI)+" => ");
      vhdl->set_comment(4," OPCOD_L_RORI  --");
      
      // TYPE_6  Shift/Rotate with immediat
      // OPCOD_L_RORI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_RORI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_RORI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 6;cp++) extend_signal += "0";
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (5 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_6  Shift/Rotate with immediat
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_7)+" => ");
      vhdl->set_comment(2," OPCOD_7  multiply with HI-LO  --");
      
      // TYPE_7  multiply with HI-LO
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_7 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(4,OPCOD_L_MAC)+" => ");
      vhdl->set_comment(4," OPCOD_L_MAC  --");
      
      // TYPE_7  multiply with HI-LO
      // OPCOD_L_MAC
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MAC)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MAC)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_SPR_ACCESS)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(4,OPCOD_L_MSB)+" => ");
      vhdl->set_comment(4," OPCOD_L_MSB  --");
      
      // TYPE_7  multiply with HI-LO
      // OPCOD_L_MSB
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MSB)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MSB)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_INSTRUCTION_"+toString(i)+"(20 downto 16); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 11); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_SPR_ACCESS)+"; ");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_7  multiply with HI-LO
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_8)+" => ");
      vhdl->set_comment(2," OPCOD_8  acces at HI-LO  --");
      
      // TYPE_8  acces at HI-LO
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_8 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(1,OPCOD_L_MOVHI)+" => ");
      vhdl->set_comment(4," OPCOD_L_MOVHI  --");
      
      // TYPE_8  acces at HI-LO
      // OPCOD_L_MOVHI
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MOVHI)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MOVHI)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "0";
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(1,OPCOD_L_MACRC)+" => ");
      vhdl->set_comment(4," OPCOD_L_MACRC  --");
      
      // TYPE_8  acces at HI-LO
      // OPCOD_L_MACRC
      
      vhdl->set_body(5,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(15 downto 0) = \"0000000000000000\" then ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MACRC)._type)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MACRC)._operation)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '1'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_INSTRUCTION_"+toString(i)+"(25 downto 21); ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_SPR_ACCESS)+"; ");
      vhdl->set_body(5,"else ");
      instruction_illegale(6,i)
      // illegal instruction
      vhdl->set_body(5,"end if; ");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_8  acces at HI-LO
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_9)+" => ");
      vhdl->set_comment(2," OPCOD_9  special  --");
      
      // TYPE_9  special
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_9 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(3,OPCOD_L_SYS)+" => ");
      vhdl->set_comment(4," OPCOD_L_SYS  --");
      
      // TYPE_9  special
      // OPCOD_L_SYS
      
      vhdl->set_body(5,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(22 downto 16) = \"0000000\" then ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_SYS)._type)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_SYS)._operation)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_SYSCALL)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_SYSCALL)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '1'; ");
      //vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_EXCEPTION)+"; ");
      vhdl->set_body(5,"else ");
      instruction_illegale(6,i)
      // illegal instruction
      vhdl->set_body(5,"end if; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(3,OPCOD_L_TRAP)+" => ");
      vhdl->set_comment(4," OPCOD_L_TRAP  --");
      
      // TYPE_9  special
      // OPCOD_L_TRAP
      
      vhdl->set_body(5,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(22 downto 16) = \"0000000\" then ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_TRAP)._type)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_TRAP)._operation)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '1'; ");
      extend_signal = "";
      for(uint32_t cp = 0;cp < _param->_size_general_data - 16;cp++) extend_signal += "0";
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT <= \""+extend_signal+"\" & internal_DECOD_INSTRUCTION_"+toString(i)+" (15 downto 0); ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_TRAP)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '1'; ");
      //vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      vhdl->set_body(5,"else ");
      instruction_illegale(6,i)
      // illegal instruction
      vhdl->set_body(5,"end if; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(3,OPCOD_L_MSYNC)+" => ");
      vhdl->set_comment(4," OPCOD_L_MSYNC  --");
      
      // TYPE_9  special
      // OPCOD_L_MSYNC
      
      vhdl->set_body(5,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(22 downto 0) = \"00000000000000000000000\" then ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_MSYNC)._type)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_MSYNC)._operation)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_MSYNC)+"; ");
      vhdl->set_body(5,"else ");
      instruction_illegale(6,i)
      // illegal instruction
      vhdl->set_body(5,"end if; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(3,OPCOD_L_PSYNC)+" => ");
      vhdl->set_comment(4," OPCOD_L_PSYNC  --");
      
      // TYPE_9  special
      // OPCOD_L_PSYNC
      
      vhdl->set_body(5,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(22 downto 0) = \"00000000000000000000000\" then ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_PSYNC)._type)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_PSYNC)._operation)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_PSYNC)+"; ");
      vhdl->set_body(5,"else ");
      instruction_illegale(6,i)
      // illegal instruction
      vhdl->set_body(5,"end if; ");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(3,OPCOD_L_CSYNC)+" => ");
      vhdl->set_comment(4," OPCOD_L_CSYNC  --");
      
      // TYPE_9  special
      // OPCOD_L_CSYNC
      
      vhdl->set_body(5,"if internal_DECOD_INSTRUCTION_"+toString(i)+"(23) = '0' then ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_CSYNC)._type)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_CSYNC)._operation)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '0'; ");
      //vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(6,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_CSYNC)+"; ");
      vhdl->set_body(5,"else ");
      instruction_illegale(6,i)
      // illegal instruction
      vhdl->set_body(5,"end if; ");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_9  special
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN "+std_logic_cst(6,OPCOD_10)+" => ");
      vhdl->set_comment(2," OPCOD_10  no operation  --");
      
      // TYPE_10  no operation
      
      vhdl->set_body(3,"case internal_DECOD_INSTRUCTION_"+toString(i)+"_OPCOD_TYPE_10 is");
      
      vhdl->set_body(4,"WHEN "+std_logic_cst(2,OPCOD_L_NOP)+" => ");
      vhdl->set_comment(4," OPCOD_L_NOP  --");
      
      // TYPE_10  no operation
      // OPCOD_L_NOP
      
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE <= "+std_logic_cst(_param->_size_type,instruction_information(INSTRUCTION_L_NOP)._type)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION <= "+std_logic_cst(_param->_size_operation,instruction_information(INSTRUCTION_L_NOP)._operation)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE <= '0'; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE <= "+std_logic_cst(_param->_size_exception_use,EXCEPTION_USE_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION <= "+std_logic_cst(_param->_size_exception_decod,EXCEPTION_DECOD_NONE)+"; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE <= '1'; ");
      //vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT; ");
      vhdl->set_body(5,"internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE <= "+std_logic_cst(_param->_size_event_type,EVENT_TYPE_NONE)+"; ");
      
      vhdl->set_body(4,"WHEN others => ");
      instruction_illegale(4,i)
      
      // TYPE_10  no operation
      // illegal instruction
      
      vhdl->set_body(3,"end case;");
      
      vhdl->set_body(2,"WHEN others => ");
      instruction_illegale(2,i)
      
      // TYPE_0  IMMEDIAT
      // illegal instruction
      
      vhdl->set_body(1,"end case;");
      vhdl->set_body(0,"end process case_DECOD_INST_"+toString(i)+";");
      vhdl->set_body(0,"");


    }

    vhdl->set_body(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Registers                       ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_body(0,"");
    
    vhdl->set_body(0,"reg_DECOD : process (in_CLOCK)");
    vhdl->set_body(0,"begin");
    vhdl->set_body(1,"if in_CLOCK'event AND in_CLOCK = '1' then");
    vhdl->set_body(2,"if in_NRESET = '0' then");
    
    for(uint32_t i = 0;i < _param->_nb_context;i++){
      vhdl->set_body(3,"reg_CONTEXT_"+toString(i)+"_ADDRESS_PREVIOUS <= "+std_logic_cst(_param->_size_instruction_address,0xfc)+";");
      vhdl->set_body(3,"reg_CONTEXT_"+toString(i)+"_IS_DELAY_SLOT <= '0';");
    }

    vhdl->set_body(2,"else");
    
    for(uint32_t i = 0;i < _param->_nb_context;i++){
      vhdl->set_body(3,"if internal_CONTEXT_"+toString(i)+"_HAVE_TRANSACTION = '1' then");

      vhdl->set_body(4,"reg_CONTEXT_"+toString(i)+"_ADDRESS_PREVIOUS <= internal_CONTEXT_"+toString(i)+"_ADDRESS_PREVIOUS ;");
      vhdl->set_body(4,"if internal_DECOD_INSTRUCTION_"+toString(_param->_nb_inst_decod - 1)+"_TYPE = "+std_logic_cst(_param->_size_type,TYPE_BRANCH)+" then");
      vhdl->set_body(5,"reg_CONTEXT_"+toString(i)+"_IS_DELAY_SLOT <= '1';");
      vhdl->set_body(4,"else");
      vhdl->set_body(5,"reg_CONTEXT_"+toString(i)+"_IS_DELAY_SLOT <= '0';");
      vhdl->set_body(4,"end if;");

      //vhdl->set_body(3,"else");

      //vhdl->set_body(4,"reg_CONTEXT_"+toString(i)+"_ADDRESS_PREVIOUS <= reg_CONTEXT_"+toString(i)+"_ADDRESS_PREVIOUS ;");
      //vhdl->set_body(4,"reg_CONTEXT_"+toString(i)+"_IS_DELAY_SLOT <= reg_CONTEXT_"+toString(i)+"_IS_DELAY_SLOT ;");
      
      vhdl->set_body(3,"end if;");
    }

    vhdl->set_body(2,"end if;");
    vhdl->set_body(1,"end if;");
    vhdl->set_body(0,"end process reg_DECOD;");
    vhdl->set_body(0,"");

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
