#ifdef VHDL
/*
 * $Id: Decod_queue_vhdl_declaration.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::vhdl_declaration"
  void Decod_queue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_begin(Decod_queue,FUNCTION);

    vhdl->set_signal ("internal_QUEUE_INSERT_DATA    ",_param->_size_internal_queue);
    vhdl->set_signal ("internal_QUEUE_RETIRE_DATA    ",_param->_size_internal_queue);
    vhdl->set_signal ("internal_QUEUE_INSERT_VAL     ",1);
    vhdl->set_signal ("internal_QUEUE_RETIRE_VAL     ",1);
    vhdl->set_signal ("internal_QUEUE_INSERT_ACK     ",1);
    vhdl->set_signal ("internal_QUEUE_RETIRE_ACK     ",1);

    vhdl->set_signal ("internal_QUEUE_NEW_HEAD       ",1);
    
    uint32_t min = 0;
    uint32_t max, size;

    for(uint32_t i = 0;i < _param->_nb_context;i++){
      
      vhdl->set_signal ("reg_NB_INST_"+toString(i)+"_ALL",_param->_size_nb_inst_decod);
      vhdl->set_signal ("internal_NB_INST_"+toString(i)+"_ALL",_param->_size_nb_inst_decod);

      for(uint32_t i_inst = 0;i_inst < _param->_nb_inst_decod;i_inst++){
	vhdl->set_signal ("internal_NB_INST_IN_"+toString(i)+"_"+toString(i_inst)+"_CONTEXT",_param->_size_nb_inst_decod);
	vhdl->set_signal ("internal_NB_INST_OUT_"+toString(i)+"_"+toString(i_inst)+"_CONTEXT",_param->_size_nb_inst_decod);
      }
    }
    
    for(uint32_t i = 0;i < _param->_nb_inst_decod;i++){
      vhdl->set_signal ("reg_DECOD_OUT_"+toString(i)+"_VAL",1);
      vhdl->set_signal ("internal_DECOD_OUT_"+toString(i)+"_VAL",1);
      vhdl->set_signal ("internal_OUT_DECOD_OUT_"+toString(i)+"_VAL",1);
      vhdl->set_signal ("internal_DECOD_"+toString(i)+"_VALID",1);
      vhdl->set_signal ("internal_INDEX_"+toString(i),_param->_size_nb_inst_decod + 1);
      
      max = min;

      if(_param->_have_port_context_id)
	{
	  size = _param->_size_context_id;
	  max = min-1+size;
	  vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_CONTEXT_ID",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	  vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	  min = max+1;
	}
      
      if(_param->_have_port_depth)
	{
	  size = _param->_size_depth;
	  max = min-1+size;
	  vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_DEPTH",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	  vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_DEPTH",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	  min = max+1;
	}
      
      size = _param->_size_type;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_TYPE",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_TYPE",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_operation;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_OPERATION",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_OPERATION",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_NO_EXECUTE",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_NO_EXECUTE",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_IS_DELAY_SLOT",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_IS_DELAY_SLOT",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
#ifdef DEBUG
      size = _param->_size_instruction_address;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_ADDRESS",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_ADDRESS",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
#endif
      
      size = _param->_size_instruction_address;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_ADDRESS_NEXT",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_ADDRESS_NEXT",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_HAS_IMMEDIAT",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_HAS_IMMEDIAT",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_general_data;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_IMMEDIAT",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_IMMEDIAT",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_READ_RA",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_READ_RA",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_general_register_logic;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_NUM_REG_RA",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RA",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_READ_RB",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_READ_RB",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_general_register_logic;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_NUM_REG_RB",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RB",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_READ_RC",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_READ_RC",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_special_register_logic;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_NUM_REG_RC",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RC",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_WRITE_RD",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_WRITE_RD",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_general_register_logic;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_NUM_REG_RD",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RD",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_WRITE_RE",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_WRITE_RE",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_special_register_logic;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_NUM_REG_RE",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RE",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_exception_use;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_EXCEPTION_USE",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_EXCEPTION_USE",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = _param->_size_exception_decod;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_EXCEPTION",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_DECOD_OUT_"+toString(i)+"_EXCEPTION",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;
      
      size = 1;
      max = min-1+size;
      vhdl->set_alias ("internal_DECOD_IN_"+toString(i)+"_VAL",std_logic(size),"internal_QUEUE_INSERT_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      vhdl->set_alias ("internal_QUEUE_OUT_"+toString(i)+"_VAL",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
      min = max+1;

    }

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
