#ifdef VHDL
/*
 * $Id: Address_management_vhdl_declaration.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::vhdl_declaration"
  void Address_management::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    vhdl->set_type    ("Tinstruction_enable  ","array "+_std_logic_range(_param->_nb_instruction)+" of std_logic");

    vhdl->set_signal  ("reg_PC_ACCESS_VAL                           ", 1);
    vhdl->set_signal  ("reg_PC_ACCESS                               ", _param->_size_instruction_address);
    vhdl->set_signal  ("reg_PC_ACCESS_IS_DS_TAKE                    ", 1);
    vhdl->set_signal  ("reg_PC_ACCESS_INSTRUCTION_ENABLE            ", "Tinstruction_enable");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_signal  ("reg_PC_ACCESS_INST_IFETCH_PTR               ", _param->_size_inst_ifetch_ptr);
    vhdl->set_signal  ("reg_PC_ACCESS_BRANCH_STATE                  ", _param->_size_branch_state);
    if (_param->_have_port_depth)
    vhdl->set_signal  ("reg_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID   ", _param->_size_depth);


    vhdl->set_signal  ("reg_PC_CURRENT_VAL                          ", 1);
    vhdl->set_signal  ("reg_PC_CURRENT                              ", _param->_size_instruction_address);
    vhdl->set_signal  ("reg_PC_CURRENT_IS_DS_TAKE                   ", 1);
    vhdl->set_signal  ("reg_PC_CURRENT_INSTRUCTION_ENABLE           ", "Tinstruction_enable");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_signal  ("reg_PC_CURRENT_INST_IFETCH_PTR              ",_param->_size_inst_ifetch_ptr);
    vhdl->set_signal  ("reg_PC_CURRENT_BRANCH_STATE                 ", _param->_size_branch_state);
    if (_param->_have_port_depth)
    vhdl->set_signal  ("reg_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID  ", _param->_size_depth);

    vhdl->set_signal  ("reg_PC_NEXT_VAL                             ", 1);
    vhdl->set_signal  ("reg_PC_NEXT                                 ", _param->_size_instruction_address);
    vhdl->set_signal  ("reg_PC_NEXT_IS_DS_TAKE                      ", 1);
    vhdl->set_signal  ("reg_PC_NEXT_INSTRUCTION_ENABLE              ", "Tinstruction_enable");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_signal  ("reg_PC_NEXT_INST_IFETCH_PTR                 ",_param->_size_inst_ifetch_ptr);
    vhdl->set_signal  ("reg_PC_NEXT_BRANCH_STATE                    ", _param->_size_branch_state);
    if (_param->_have_port_depth)
    vhdl->set_signal  ("reg_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID     ", _param->_size_depth);

    vhdl->set_signal  ("reg_PC_NEXT_NEXT_VAL                        ", 1);
    vhdl->set_signal  ("reg_PC_NEXT_NEXT                            ", _param->_size_instruction_address);
    vhdl->set_signal  ("reg_PC_NEXT_NEXT_IS_DS_TAKE                 ", 1);
//  vhdl->set_signal  ("reg_PC_NEXT_NEXT_INSTRUCTION_ENABLE         ", "Tinstruction_enable");
//  if (_param->_have_port_inst_ifetch_ptr)
//  vhdl->set_signal  ("reg_PC_NEXT_NEXT_INST_IFETCH_PTR            ",_param->_size_inst_ifetch_ptr);
//  vhdl->set_signal  ("reg_PC_NEXT_NEXT_BRANCH_STATE               ", _param->_size_branch_state);
//  if (_param->_have_port_depth)
//  vhdl->set_signal  ("reg_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID", _param->_size_depth);

    vhdl->set_signal  ("internal_PREDICT_VAL                        ", 1);
    vhdl->set_signal  ("internal_ADDRESS_VAL                        ", 1);
    vhdl->set_signal  ("internal_EVENT_ACK                          ", 1);

    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
