#ifdef VHDL
/*
 * $Id: Stat_List_unit_vhdl_declaration.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Stat_List_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {


#undef  FUNCTION
#define FUNCTION "Stat_List_unit::vhdl_declaration"
  void Stat_List_unit::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

    uint32_t size_bank     = log2(_param->_nb_bank);
    uint32_t size_gpr_ptr  = log2(_param->_nb_general_register_by_bank);
    uint32_t size_spr_ptr  = log2(_param->_nb_special_register_by_bank);

    // bit 0 : _is_free
    // bit 1 : _is_link
    vhdl->set_type  ("Tone_stat_list_gpr   ", "array " + _std_logic_range(_param->_nb_general_register_by_bank) + " of " + std_logic(2));
    vhdl->set_type  ("Tstat_list_gpr       ", "array " + _std_logic_range(_param->_nb_bank) + " of Tone_stat_list_gpr");
    vhdl->set_signal("gpr_stat_list        ", "Tstat_list_gpr");
                                           
    vhdl->set_type  ("Tone_stat_list_spr   ", "array " + _std_logic_range(_param->_nb_special_register_by_bank) + " of " + std_logic(2));
    vhdl->set_type  ("Tstat_list_spr       ", "array " + _std_logic_range(_param->_nb_bank) + " of Tone_stat_list_spr");
    vhdl->set_signal("spr_stat_list        ", "Tstat_list_spr");

    if (size_gpr_ptr>0)
    vhdl->set_signal("reg_GPR_PTR_FREE     ",size_gpr_ptr);
    if (size_spr_ptr>0)
    vhdl->set_signal("reg_SPR_PTR_FREE     ",size_spr_ptr);

    for (uint32_t i=0; i<_param->_nb_inst_insert; i ++)
    vhdl->set_signal ("internal_INSERT_"+toString(i)+"_ACK",1);

    for (uint32_t i=0; i<_param->_nb_inst_retire; i ++)
    vhdl->set_signal ("internal_RETIRE_"+toString(i)+"_ACK",1);

    for (uint32_t i=0; i<_param->_nb_reg_free; i ++)
      {
        vhdl->set_signal ("internal_PUSH_GPR_"+toString(i)+"_VAL     " ,1);
        if (size_bank>0)
        vhdl->set_signal ("internal_PUSH_GPR_"+toString(i)+"_NUM_BANK" ,size_bank);
        if (size_gpr_ptr>0)
        vhdl->set_signal ("internal_PUSH_GPR_"+toString(i)+"_NUM_REG " ,size_gpr_ptr);

        vhdl->set_signal ("internal_PUSH_SPR_"+toString(i)+"_VAL     " ,1);
        if (size_bank>0)
        vhdl->set_signal ("internal_PUSH_SPR_"+toString(i)+"_NUM_BANK" ,size_bank);
        if (size_spr_ptr>0)
        vhdl->set_signal ("internal_PUSH_SPR_"+toString(i)+"_NUM_REG " ,size_spr_ptr);
      }
	  
    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
