#ifdef VHDL
/*
 * $Id: Address_management_vhdl_body.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::vhdl_body"
  void Address_management::vhdl_body (Vhdl * & vhdl)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"=========================================");
    vhdl->set_comment(0,"===== CONSTANT ==========================");
    vhdl->set_comment(0,"=========================================");
    vhdl->set_body   (0,"");
    vhdl->set_body   (0,"internal_EVENT_ACK <= '1';");
    vhdl->set_body   (0,"     out_EVENT_ACK <= internal_EVENT_ACK;");

    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"=========================================");
    vhdl->set_comment(0,"===== TRANSITION ========================");
    vhdl->set_comment(0,"=========================================");
    vhdl->set_body   (0,"");
    
    vhdl->set_body   (0,"TRANSITION : process (in_CLOCK)");

    vhdl->set_body   (0,"");
    vhdl->set_body   (0,"variable var_PC_ACCESS_VAL                            : "+std_logic(1)+";");
    vhdl->set_body   (0,"variable var_PC_ACCESS                                : "+std_logic(_param->_size_instruction_address)+";");
    vhdl->set_body   (0,"variable var_PC_ACCESS_IS_DS_TAKE                     : "+std_logic(1)+";");
    vhdl->set_body   (0,"variable var_PC_ACCESS_INSTRUCTION_ENABLE             : Tinstruction_enable;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (0,"variable var_PC_ACCESS_INST_IFETCH_PTR                : "+std_logic(_param->_size_inst_ifetch_ptr)+";");
    vhdl->set_body   (0,"variable var_PC_ACCESS_BRANCH_STATE                   : "+std_logic(_param->_size_branch_state)+";");
    if (_param->_have_port_depth)
    vhdl->set_body   (0,"variable var_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID    : "+std_logic(_param->_size_depth)+";");
    vhdl->set_body   (0,"");
    vhdl->set_body   (0,"variable var_PC_CURRENT_VAL                           : "+std_logic(1)+";");
    vhdl->set_body   (0,"variable var_PC_CURRENT                               : "+std_logic(_param->_size_instruction_address)+";");
    vhdl->set_body   (0,"variable var_PC_CURRENT_IS_DS_TAKE                    : "+std_logic(1)+";");
    vhdl->set_body   (0,"variable var_PC_CURRENT_INSTRUCTION_ENABLE            : Tinstruction_enable;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (0,"variable var_PC_CURRENT_INST_IFETCH_PTR               : "+std_logic(_param->_size_inst_ifetch_ptr)+";");
    vhdl->set_body   (0,"variable var_PC_CURRENT_BRANCH_STATE                  : "+std_logic(_param->_size_branch_state)+";");
    if (_param->_have_port_depth)
    vhdl->set_body   (0,"variable var_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID   : "+std_logic(_param->_size_depth)+";");
    vhdl->set_body   (0,"");
    vhdl->set_body   (0,"variable var_PC_NEXT_VAL                              : "+std_logic(1)+";");
    vhdl->set_body   (0,"variable var_PC_NEXT                                  : "+std_logic(_param->_size_instruction_address)+";");
    vhdl->set_body   (0,"variable var_PC_NEXT_IS_DS_TAKE                       : "+std_logic(1)+";");
    vhdl->set_body   (0,"variable var_PC_NEXT_INSTRUCTION_ENABLE               : Tinstruction_enable;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (0,"variable var_PC_NEXT_INST_IFETCH_PTR                  : "+std_logic(_param->_size_inst_ifetch_ptr)+";");
    vhdl->set_body   (0,"variable var_PC_NEXT_BRANCH_STATE                     : "+std_logic(_param->_size_branch_state)+";");
    if (_param->_have_port_depth)
    vhdl->set_body   (0,"variable var_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID      : "+std_logic(_param->_size_depth)+";");
    vhdl->set_body   (0,"");
    vhdl->set_body   (0,"variable var_PC_NEXT_NEXT_VAL                         : "+std_logic(1)+";");
    vhdl->set_body   (0,"variable var_PC_NEXT_NEXT                             : "+std_logic(_param->_size_instruction_address)+";");
    vhdl->set_body   (0,"variable var_PC_NEXT_NEXT_IS_DS_TAKE                  : "+std_logic(1)+";");
//  vhdl->set_body   (0,"variable var_PC_NEXT_NEXT_INSTRUCTION_ENABLE          : Tinstruction_enable;");
//  if (_param->_have_port_inst_ifetch_ptr)
//  vhdl->set_body   (0,"variable var_PC_NEXT_NEXT_INST_IFETCH_PTR             : "+std_logic(_param->_size_inst_ifetch_ptr)+";");
//  vhdl->set_body   (0,"variable var_PC_NEXT_NEXT_BRANCH_STATE                : "+std_logic(_param->_size_branch_state)+";");
//  if (_param->_have_port_depth)
//  vhdl->set_body   (0,"variable var_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID : "+std_logic(_param->_size_depth)+";");
    vhdl->set_body   (0,"");
    vhdl->set_body   (0,"begin  -- TRANSITION");
    vhdl->set_body   (1,"if (in_CLOCK'event and in_CLOCK = '1')then");
    vhdl->set_body   (1,"");
    vhdl->set_body   (2,"if (in_NRESET = '0') then");
    vhdl->set_body   (3,"");

    {
      vhdl->set_body   (3,"reg_PC_ACCESS_VAL                       <= '0';");
#ifdef SYSTEMC_VHDL_COMPATIBILITY
      vhdl->set_body   (3,"reg_PC_ACCESS                           <= "+std_logic_cst(_param->_size_instruction_address,0)+";");
#endif
      vhdl->set_body   (3,"reg_PC_CURRENT_VAL                      <= '0';");
#ifdef SYSTEMC_VHDL_COMPATIBILITY
      vhdl->set_body   (3,"reg_PC_CURRENT                          <= "+std_logic_cst(_param->_size_instruction_address,0)+";");
#endif
      vhdl->set_body   (3,"reg_PC_NEXT_VAL                         <= '1';");
      vhdl->set_body   (3,"reg_PC_NEXT                             <= "+std_logic_cst(_param->_size_instruction_address,0x100>>2)+";");
      vhdl->set_body   (3,"reg_PC_NEXT_IS_DS_TAKE                  <= '0';");
      uint32_t index = reg_PC_NEXT % _param->_nb_instruction;
      for (uint32_t i=0; i<_param->_nb_instruction; i++)
	{
	  std::string value = (i != index)?"'0'":"'1'";
	  vhdl->set_body   (3,"reg_PC_NEXT_INSTRUCTION_ENABLE ("+toString(i)+") <= "+value+";");
	}
      if (_param->_have_port_inst_ifetch_ptr)
      vhdl->set_body   (3,"reg_PC_NEXT_INST_IFETCH_PTR             <= "+std_logic_cst(_param->_size_inst_ifetch_ptr,0)+";");
      vhdl->set_body   (3,"reg_PC_NEXT_BRANCH_STATE                <= "+std_logic_cst(_param->_size_branch_state   ,0)+";");
      if (_param->_have_port_depth)
      vhdl->set_body   (3,"reg_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID <= "+std_logic_cst(_param->_size_depth          ,0)+";");
      vhdl->set_body   (3,"reg_PC_NEXT_NEXT_VAL                    <= '0';");
#ifdef SYSTEMC_VHDL_COMPATIBILITY
      vhdl->set_body   (3,"reg_PC_NEXT_NEXT                        <= "+std_logic_cst(_param->_size_instruction_address,0)+";");
#endif
    }
    vhdl->set_body   (3,"");
    vhdl->set_body   (2,"else");

    vhdl->set_body   (3,"var_PC_ACCESS_VAL                            := reg_PC_ACCESS_VAL                            ;");
    vhdl->set_body   (3,"var_PC_ACCESS                                := reg_PC_ACCESS                                ;");
    vhdl->set_body   (3,"var_PC_ACCESS_IS_DS_TAKE                     := reg_PC_ACCESS_IS_DS_TAKE                     ;");
    vhdl->set_body   (3,"var_PC_ACCESS_INSTRUCTION_ENABLE             := reg_PC_ACCESS_INSTRUCTION_ENABLE             ;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (3,"var_PC_ACCESS_INST_IFETCH_PTR                := reg_PC_ACCESS_INST_IFETCH_PTR                ;");
    vhdl->set_body   (3,"var_PC_ACCESS_BRANCH_STATE                   := reg_PC_ACCESS_BRANCH_STATE                   ;");
    if (_param->_have_port_depth)
    vhdl->set_body   (3,"var_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID    := reg_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID    ;");
    vhdl->set_body   (3,"");
    vhdl->set_body   (3,"var_PC_CURRENT_VAL                           := reg_PC_CURRENT_VAL                           ;");
    vhdl->set_body   (3,"var_PC_CURRENT                               := reg_PC_CURRENT                               ;");
    vhdl->set_body   (3,"var_PC_CURRENT_IS_DS_TAKE                    := reg_PC_CURRENT_IS_DS_TAKE                    ;");
    vhdl->set_body   (3,"var_PC_CURRENT_INSTRUCTION_ENABLE            := reg_PC_CURRENT_INSTRUCTION_ENABLE            ;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (3,"var_PC_CURRENT_INST_IFETCH_PTR               := reg_PC_CURRENT_INST_IFETCH_PTR               ;");
    vhdl->set_body   (3,"var_PC_CURRENT_BRANCH_STATE                  := reg_PC_CURRENT_BRANCH_STATE                  ;");
    if (_param->_have_port_depth)
    vhdl->set_body   (3,"var_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID   := reg_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID   ;");
    vhdl->set_body   (3,"");
    vhdl->set_body   (3,"var_PC_NEXT_VAL                              := reg_PC_NEXT_VAL                              ;");
    vhdl->set_body   (3,"var_PC_NEXT                                  := reg_PC_NEXT                                  ;");
    vhdl->set_body   (3,"var_PC_NEXT_IS_DS_TAKE                       := reg_PC_NEXT_IS_DS_TAKE                       ;");
    vhdl->set_body   (3,"var_PC_NEXT_INSTRUCTION_ENABLE               := reg_PC_NEXT_INSTRUCTION_ENABLE               ;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (3,"var_PC_NEXT_INST_IFETCH_PTR                  := reg_PC_NEXT_INST_IFETCH_PTR                  ;");
    vhdl->set_body   (3,"var_PC_NEXT_BRANCH_STATE                     := reg_PC_NEXT_BRANCH_STATE                     ;");
    if (_param->_have_port_depth)
    vhdl->set_body   (3,"var_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID      := reg_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID      ;");
    vhdl->set_body   (3,"");
    vhdl->set_body   (3,"var_PC_NEXT_NEXT_VAL                         := reg_PC_NEXT_NEXT_VAL                         ;");
    vhdl->set_body   (3,"var_PC_NEXT_NEXT                             := reg_PC_NEXT_NEXT                             ;");
    vhdl->set_body   (3,"var_PC_NEXT_NEXT_IS_DS_TAKE                  := reg_PC_NEXT_NEXT_IS_DS_TAKE                  ;");
//  vhdl->set_body   (3,"var_PC_NEXT_NEXT_INSTRUCTION_ENABLE          := reg_PC_NEXT_NEXT_INSTRUCTION_ENABLE          ;");
//  if (_param->_have_port_inst_ifetch_ptr)
//  vhdl->set_body   (3,"var_PC_NEXT_NEXT_INST_IFETCH_PTR             := reg_PC_NEXT_NEXT_INST_IFETCH_PTR             ;");
//  vhdl->set_body   (3,"var_PC_NEXT_NEXT_BRANCH_STATE                := reg_PC_NEXT_NEXT_BRANCH_STATE                ;");
//  if (_param->_have_port_depth)
//  vhdl->set_body   (3,"var_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID := reg_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID ;");

    {
      vhdl->set_comment(3,"=========================================");
      vhdl->set_comment(3,"===== PREDICT ===========================");
      vhdl->set_comment(3,"=========================================");

      vhdl->set_body   (3,"if ((internal_PREDICT_VAL and in_PREDICT_ACK) = '1') then");
      vhdl->set_body   (4,"if (var_PC_NEXT_IS_DS_TAKE = '1') then");
      if (_param->_have_port_inst_ifetch_ptr)
      vhdl->set_body   (5,"var_PC_CURRENT_INST_IFETCH_PTR             := in_PREDICT_INST_IFETCH_PTR;");
      vhdl->set_body   (5,"var_PC_CURRENT_BRANCH_STATE                := in_PREDICT_BRANCH_STATE;");
      if (_param->_have_port_depth)
      vhdl->set_body   (5,"var_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID := in_PREDICT_BRANCH_UPDATE_PREDICTION_ID;");
      vhdl->set_body   (5,"else");
      if (_param->_have_port_inst_ifetch_ptr)
      vhdl->set_body   (5,"var_PC_NEXT_INST_IFETCH_PTR                := in_PREDICT_INST_IFETCH_PTR;");
      vhdl->set_body   (5,"var_PC_NEXT_BRANCH_STATE                   := in_PREDICT_BRANCH_STATE;");
      if (_param->_have_port_depth)
      vhdl->set_body   (5,"var_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID    := in_PREDICT_BRANCH_UPDATE_PREDICTION_ID;");
      vhdl->set_body   (4,"end if;");

      vhdl->set_body   (4,"var_PC_NEXT_NEXT_VAL                       := '1'; -- address is valid");
      vhdl->set_body   (4,"var_PC_NEXT_NEXT                           := in_PREDICT_PC_NEXT;");
      vhdl->set_body   (4,"var_PC_NEXT_NEXT_IS_DS_TAKE                := in_PREDICT_PC_NEXT_IS_DS_TAKE;");
      for (uint32_t i=0; i<_param->_nb_instruction; i++)
      vhdl->set_body   (4,"var_PC_NEXT_INSTRUCTION_ENABLE("+toString(i)+") := in_PREDICT_"+toString(i)+"_INSTRUCTION_ENABLE;");      

      vhdl->set_body   (3,"end if;");
    }

    {
      vhdl->set_comment(3,"=========================================");
      vhdl->set_comment(3,"===== ADDRESS ===========================");
      vhdl->set_comment(3,"=========================================");

      vhdl->set_body   (3,"if ((internal_ADDRESS_VAL and in_ADDRESS_ACK) = '1') then");

      vhdl->set_body   (4,"var_PC_ACCESS_VAL := '0'; -- transaction with icache");

      vhdl->set_body   (3,"end if;");
    }

    {
      vhdl->set_comment(3,"=========================================");
      vhdl->set_comment(3,"===== Shift Register ====================");
      vhdl->set_comment(3,"=========================================");

      vhdl->set_body   (3,"if ((var_PC_NEXT_NEXT_VAL and var_PC_NEXT_VAL and var_PC_CURRENT_VAL and not var_PC_ACCESS_VAL) = '1') then");
      vhdl->set_body   (4,"var_PC_ACCESS_VAL                          := '1'; -- new request");
      vhdl->set_body   (4,"var_PC_CURRENT_VAL                         := '0'; -- invalid current");
      vhdl->set_body   (4,"var_PC_ACCESS                              := var_PC_CURRENT;");
      vhdl->set_body   (4,"var_PC_ACCESS_IS_DS_TAKE                   := var_PC_CURRENT_IS_DS_TAKE;");
      if (_param->_have_port_inst_ifetch_ptr)
      vhdl->set_body   (4,"var_PC_ACCESS_INST_IFETCH_PTR              := var_PC_CURRENT_INST_IFETCH_PTR;");
      vhdl->set_body   (4,"var_PC_ACCESS_BRANCH_STATE                 := var_PC_CURRENT_BRANCH_STATE;");
      if (_param->_have_port_depth)
      vhdl->set_body   (4,"var_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID  := var_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID;");
//    for (uint32_t i=0; i<_param->_nb_instruction; i++)
//    vhdl->set_body   (4,"var_PC_ACCESS_INSTRUCTION_ENABLE("+toString(i)+") := var_PC_CURRENT_INSTRUCTION_ENABLE("+toString(i)+");");
      vhdl->set_body   (4,"var_PC_ACCESS_INSTRUCTION_ENABLE           := var_PC_CURRENT_INSTRUCTION_ENABLE;");
      vhdl->set_body   (3,"end if;");

      vhdl->set_body   (3,"if ((var_PC_NEXT_NEXT_VAL and var_PC_NEXT_VAL and not var_PC_CURRENT_VAL) = '1') then");
      vhdl->set_body   (4,"var_PC_CURRENT_VAL                         := '1'; -- new request");
      vhdl->set_body   (4,"var_PC_NEXT_VAL                            := '0'; -- invalid next");
      vhdl->set_body   (4,"var_PC_CURRENT                             := var_PC_NEXT;");
      vhdl->set_body   (4,"var_PC_CURRENT_IS_DS_TAKE                  := var_PC_NEXT_IS_DS_TAKE;");
      if (_param->_have_port_inst_ifetch_ptr)
      vhdl->set_body   (4,"var_PC_CURRENT_INST_IFETCH_PTR             := var_PC_NEXT_INST_IFETCH_PTR;");
      vhdl->set_body   (4,"var_PC_CURRENT_BRANCH_STATE                := var_PC_NEXT_BRANCH_STATE;");
      if (_param->_have_port_depth)
      vhdl->set_body   (4,"var_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID := var_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID;");
//    for (uint32_t i=0; i<_param->_nb_instruction; i++)
//    vhdl->set_body   (4,"var_PC_CURRENT_INSTRUCTION_ENABLE("+toString(i)+") := var_PC_NEXT_INSTRUCTION_ENABLE("+toString(i)+");");
      vhdl->set_body   (4,"var_PC_CURRENT_INSTRUCTION_ENABLE          := var_PC_NEXT_INSTRUCTION_ENABLE;");
      vhdl->set_body   (3,"end if;");

      vhdl->set_body   (3,"if ((var_PC_NEXT_NEXT_VAL and not var_PC_NEXT_VAL) = '1') then");
      vhdl->set_body   (4,"var_PC_NEXT_VAL                            := '1'; -- new request");
      vhdl->set_body   (4,"var_PC_NEXT_NEXT_VAL                       := '0'; -- invalid next_next");
      vhdl->set_body   (4,"var_PC_NEXT                                := var_PC_NEXT_NEXT;");
      vhdl->set_body   (4,"var_PC_NEXT_IS_DS_TAKE                     := var_PC_NEXT_NEXT_IS_DS_TAKE;");
//    if (_param->_have_port_inst_ifetch_ptr)
//    vhdl->set_body   (4,"var_PC_NEXT_INST_IFETCH_PTR                := var_PC_NEXT_NEXT_INST_IFETCH_PTR;");
//    vhdl->set_body   (4,"var_PC_NEXT_BRANCH_STATE                   := var_PC_NEXT_NEXT_BRANCH_STATE;");
//    if (_param->_have_port_depth)
//    vhdl->set_body   (4,"var_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID    := var_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID;");
//    for (uint32_t i=0; i<_param->_nb_instruction; i++)
//    vhdl->set_body   (4,"var_PC_NEXT_INSTRUCTION_ENABLE("+toString(i)+") := var_PC_NEXT_NEXT_INSTRUCTION_ENABLE("+toString(i)+");");
//    vhdl->set_body   (4,"var_PC_NEXT_INSTRUCTION_ENABLE             := var_PC_NEXT_NEXT_INSTRUCTION_ENABLE;");
      vhdl->set_body   (3,"end if;");
    }

    {
      vhdl->set_comment(3,"=========================================");
      vhdl->set_comment(3,"===== EVENT =============================");
      vhdl->set_comment(3,"=========================================");

      vhdl->set_body   (3,"if ((in_EVENT_VAL and internal_EVENT_ACK) = '1') then");
      vhdl->set_body   (4,"var_PC_ACCESS_VAL                       := '0';");
      vhdl->set_body   (4,"var_PC_CURRENT_VAL                      := '0';");
      vhdl->set_body   (4,"var_PC_NEXT_VAL                         := '1';");
      vhdl->set_body   (4,"var_PC_NEXT                             := in_EVENT_ADDRESS;");
      vhdl->set_body   (4,"var_PC_NEXT_IS_DS_TAKE                  := in_EVENT_IS_DS_TAKE;");

      if (is_power2(_param->_nb_instruction))
	{
	  uint32_t    size  = log2(_param->_nb_instruction);

	  if (size != 0)
	    {
	      std::string range = "var_PC_NEXT"+std_logic_range(size-1,0);
	      
	      for (uint32_t i=0; i<_param->_nb_instruction; i++)
		{
		  vhdl->set_body   (4,"if ("+range+" = "+std_logic_cst(size,i)+") then");
		  vhdl->set_body   (4,"var_PC_NEXT_INSTRUCTION_ENABLE("+toString(i)+") := '1';");
		  vhdl->set_body   (4,"else");
		  vhdl->set_body   (4,"var_PC_NEXT_INSTRUCTION_ENABLE("+toString(i)+") := '0';");
		  vhdl->set_body   (4,"end if;");
		}
	    }
	  else
	    vhdl->set_body   (4,"var_PC_NEXT_INSTRUCTION_ENABLE(0) := '1';");
	}
      else
	{
	  throw ERRORMORPHEO(FUNCTION,_("Not Yet supported, Comming Soon."));
	}
  
      vhdl->set_body   (4,"var_PC_NEXT_NEXT_VAL                    := in_EVENT_ADDRESS_NEXT_VAL;");
      vhdl->set_body   (4,"var_PC_NEXT_NEXT                        := in_EVENT_ADDRESS_NEXT;");
      vhdl->set_body   (4,"var_PC_NEXT_NEXT_IS_DS_TAKE             := '0';");
      
      vhdl->set_body   (3,"end if;");
    }

    vhdl->set_comment(3,"---------------------------------------------------------------------------");
    vhdl->set_comment(3,"WRITE Register");
    vhdl->set_comment(3,"---------------------------------------------------------------------------");

    vhdl->set_body   (3,"reg_PC_ACCESS_VAL                            <= var_PC_ACCESS_VAL                            ;");
    vhdl->set_body   (3,"reg_PC_ACCESS                                <= var_PC_ACCESS                                ;");
    vhdl->set_body   (3,"reg_PC_ACCESS_IS_DS_TAKE                     <= var_PC_ACCESS_IS_DS_TAKE                     ;");
    vhdl->set_body   (3,"reg_PC_ACCESS_INSTRUCTION_ENABLE             <= var_PC_ACCESS_INSTRUCTION_ENABLE             ;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (3,"reg_PC_ACCESS_INST_IFETCH_PTR                <= var_PC_ACCESS_INST_IFETCH_PTR                ;");
    vhdl->set_body   (3,"reg_PC_ACCESS_BRANCH_STATE                   <= var_PC_ACCESS_BRANCH_STATE                   ;");
    if (_param->_have_port_depth)
    vhdl->set_body   (3,"reg_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID    <= var_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID    ;");
    vhdl->set_body   (3,"");
    vhdl->set_body   (3,"reg_PC_CURRENT_VAL                           <= var_PC_CURRENT_VAL                           ;");
    vhdl->set_body   (3,"reg_PC_CURRENT                               <= var_PC_CURRENT                               ;");
    vhdl->set_body   (3,"reg_PC_CURRENT_IS_DS_TAKE                    <= var_PC_CURRENT_IS_DS_TAKE                    ;");
    vhdl->set_body   (3,"reg_PC_CURRENT_INSTRUCTION_ENABLE            <= var_PC_CURRENT_INSTRUCTION_ENABLE            ;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (3,"reg_PC_CURRENT_INST_IFETCH_PTR               <= var_PC_CURRENT_INST_IFETCH_PTR               ;");
    vhdl->set_body   (3,"reg_PC_CURRENT_BRANCH_STATE                  <= var_PC_CURRENT_BRANCH_STATE                  ;");
    if (_param->_have_port_depth)
    vhdl->set_body   (3,"reg_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID   <= var_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID   ;");
    vhdl->set_body   (3,"");
    vhdl->set_body   (3,"reg_PC_NEXT_VAL                              <= var_PC_NEXT_VAL                              ;");
    vhdl->set_body   (3,"reg_PC_NEXT                                  <= var_PC_NEXT                                  ;");
    vhdl->set_body   (3,"reg_PC_NEXT_IS_DS_TAKE                       <= var_PC_NEXT_IS_DS_TAKE                       ;");
    vhdl->set_body   (3,"reg_PC_NEXT_INSTRUCTION_ENABLE               <= var_PC_NEXT_INSTRUCTION_ENABLE               ;");
    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (3,"reg_PC_NEXT_INST_IFETCH_PTR                  <= var_PC_NEXT_INST_IFETCH_PTR                  ;");
    vhdl->set_body   (3,"reg_PC_NEXT_BRANCH_STATE                     <= var_PC_NEXT_BRANCH_STATE                     ;");
    if (_param->_have_port_depth)
    vhdl->set_body   (3,"reg_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID      <= var_PC_NEXT_BRANCH_UPDATE_PREDICTION_ID      ;");
    vhdl->set_body   (3,"");
    vhdl->set_body   (3,"reg_PC_NEXT_NEXT_VAL                         <= var_PC_NEXT_NEXT_VAL                         ;");
    vhdl->set_body   (3,"reg_PC_NEXT_NEXT                             <= var_PC_NEXT_NEXT                             ;");
    vhdl->set_body   (3,"reg_PC_NEXT_NEXT_IS_DS_TAKE                  <= var_PC_NEXT_NEXT_IS_DS_TAKE                  ;");
//  vhdl->set_body   (3,"reg_PC_NEXT_NEXT_INSTRUCTION_ENABLE          <= var_PC_NEXT_NEXT_INSTRUCTION_ENABLE          ;");
//  if (_param->_have_port_inst_ifetch_ptr)
//  vhdl->set_body   (3,"reg_PC_NEXT_NEXT_INST_IFETCH_PTR             <= var_PC_NEXT_NEXT_INST_IFETCH_PTR             ;");
//  vhdl->set_body   (3,"reg_PC_NEXT_NEXT_BRANCH_STATE                <= var_PC_NEXT_NEXT_BRANCH_STATE                ;");
//  if (_param->_have_port_depth)
//  vhdl->set_body   (3,"reg_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID <= var_PC_NEXT_NEXT_BRANCH_UPDATE_PREDICTION_ID ;");


    vhdl->set_body   (2,"end if; -- reset");
    vhdl->set_body   (1,"end if; -- clock");
    vhdl->set_body   (0,"end process; -- TRANSITION");

    vhdl->set_comment(0,"=========================================");
    vhdl->set_comment(0,"===== ADDRESS ===========================");
    vhdl->set_comment(0,"=========================================");

    vhdl->set_body   (0,"internal_ADDRESS_VAL                   <= reg_PC_ACCESS_VAL;");
    vhdl->set_body   (0,"     out_ADDRESS_VAL                   <= internal_ADDRESS_VAL;");

    if (is_power2(_param->_nb_instruction))
      {
	uint32_t    size  = log2(_param->_nb_instruction);

	vhdl->set_body   (0,"out_ADDRESS_INSTRUCTION_ADDRESS        <= reg_PC_ACCESS and not "+std_logic_cst(_param->_size_instruction_address,(1<<size)-1)+";");
      }
    else
      {
	throw ERRORMORPHEO(FUNCTION,_("Not Yet supported, Comming Soon."));
      }


    if (_param->_have_port_inst_ifetch_ptr)
    vhdl->set_body   (0,"out_ADDRESS_INST_IFETCH_PTR            <= reg_PC_ACCESS_INST_IFETCH_PTR;");
    vhdl->set_body   (0,"out_ADDRESS_BRANCH_STATE               <= reg_PC_ACCESS_BRANCH_STATE;");
    if (_param->_have_port_depth)
    vhdl->set_body   (0,"out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID<= reg_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID;");
    for (uint32_t i=0; i<_param->_nb_instruction; i++)
    vhdl->set_body   (0,"out_ADDRESS_"+toString(i)+"_INSTRUCTION_ENABLE <= reg_PC_ACCESS_INSTRUCTION_ENABLE ("+toString(i)+");");

    vhdl->set_comment(0,"=========================================");
    vhdl->set_comment(0,"===== PREDICT ===========================");
    vhdl->set_comment(0,"=========================================");

    vhdl->set_body   (0,"internal_PREDICT_VAL              <= not reg_PC_NEXT_NEXT_VAL;");
    vhdl->set_body   (0,"     out_PREDICT_VAL              <= internal_PREDICT_VAL;  ");
    vhdl->set_body   (0,"out_PREDICT_PC_PREVIOUS           <= reg_PC_CURRENT;        ");
    vhdl->set_body   (0,"out_PREDICT_PC_CURRENT            <= reg_PC_NEXT;           ");
    vhdl->set_body   (0,"out_PREDICT_PC_CURRENT_IS_DS_TAKE <= reg_PC_NEXT_IS_DS_TAKE;");

    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
