#ifdef VHDL
/*
 * $Id: Decod_queue_vhdl.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"
#include "Behavioural/include/Vhdl.h"
#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::vhdl"
  void Decod_queue::vhdl (void)
  {
    log_begin(Decod_queue,FUNCTION);

    //----- Queue -----
   
    morpheo::behavioural::generic::queue::Parameters * param_queue;
    morpheo::behavioural::generic::queue::Queue      * queue;
    
    param_queue = new morpheo::behavioural::generic::queue::Parameters
      (_param->_size_queue,
       _param->_size_internal_queue,
       0,
       false,
       false
       );
    
    std::string queue_name = _name + "_queue";
    queue = new morpheo::behavioural::generic::queue::Queue
      (queue_name.c_str()
#ifdef STATISTICS
       ,NULL
#endif
       ,param_queue
       ,USE_VHDL);
    
    _component->set_component(queue->_component
#ifdef POSITION
                              , 0, 0, 0, 0
#endif
                              , INSTANCE_LIBRARY
                              );

    Vhdl * vhdl = new Vhdl (_name);

    _interfaces->set_port(vhdl);
    _component->vhdl_instance(vhdl);

    vhdl_declaration (vhdl);
    vhdl_body        (vhdl);

    vhdl->generate_file();

    delete vhdl;

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
