#ifdef VHDL
/*
 * $Id: Decod_queue_vhdl_body.cpp 135 2009-07-17 08:59:05Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::vhdl_body"
  void Decod_queue::vhdl_body (Vhdl * & vhdl)
  {
    log_begin(Decod_queue,FUNCTION);

    vhdl->set_body(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Instance queue                  ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_body(0,"");

    vhdl->set_body   (0,"instance_"+_name+"_queue : "+_name+"_queue");
    vhdl->set_body   (0,"port map (");
    vhdl->set_body   (1,"  in_CLOCK => in_CLOCK ");
    vhdl->set_body   (1,", in_NRESET => in_NRESET");
    vhdl->set_body   (1,", in_INSERT_VAL => internal_QUEUE_INSERT_VAL");
    vhdl->set_body   (1,",out_INSERT_ACK => internal_QUEUE_INSERT_ACK");
    vhdl->set_body   (1,", in_INSERT_DATA => internal_QUEUE_INSERT_DATA");
    vhdl->set_body   (1,",out_RETIRE_VAL => internal_QUEUE_RETIRE_VAL");
    vhdl->set_body   (1,", in_RETIRE_ACK => internal_QUEUE_RETIRE_ACK");
    vhdl->set_body   (1,",out_RETIRE_DATA => internal_QUEUE_RETIRE_DATA");
    vhdl->set_body   (0,");");

    vhdl->set_body(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Entree Queue                    ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_body(0,"");

    for(uint32_t i=0;i < _param->_nb_inst_decod;i++){

      vhdl->set_body(0,"");
      vhdl->set_comment(0,"-----------------------------------");
      vhdl->set_comment(0,"-- Instruction "+toString(i)+"                   ");
      vhdl->set_comment(0,"-----------------------------------");
      vhdl->set_body(0,"");

      if(_param->_have_port_context_id) vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_CONTEXT_ID <= in_DECOD_IN_"+toString(i)+"_CONTEXT_ID ;");
      if(_param->_have_port_depth) vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_DEPTH <= in_DECOD_IN_"+toString(i)+"_DEPTH ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_TYPE <= in_DECOD_IN_"+toString(i)+"_TYPE ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_OPERATION <= in_DECOD_IN_"+toString(i)+"_OPERATION ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_NO_EXECUTE <= in_DECOD_IN_"+toString(i)+"_NO_EXECUTE ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_IS_DELAY_SLOT <= in_DECOD_IN_"+toString(i)+"_IS_DELAY_SLOT ;");
#ifdef DEBUG
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_ADDRESS <= in_DECOD_IN_"+toString(i)+"_ADDRESS ;");
#endif
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_ADDRESS_NEXT <= in_DECOD_IN_"+toString(i)+"_ADDRESS_NEXT ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_HAS_IMMEDIAT <= in_DECOD_IN_"+toString(i)+"_HAS_IMMEDIAT ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_IMMEDIAT <= in_DECOD_IN_"+toString(i)+"_IMMEDIAT ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_READ_RA <= in_DECOD_IN_"+toString(i)+"_READ_RA ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_NUM_REG_RA <= in_DECOD_IN_"+toString(i)+"_NUM_REG_RA ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_READ_RB <= in_DECOD_IN_"+toString(i)+"_READ_RB ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_NUM_REG_RB <= in_DECOD_IN_"+toString(i)+"_NUM_REG_RB ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_READ_RC <= in_DECOD_IN_"+toString(i)+"_READ_RC ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_NUM_REG_RC <= in_DECOD_IN_"+toString(i)+"_NUM_REG_RC ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_WRITE_RD <= in_DECOD_IN_"+toString(i)+"_WRITE_RD ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_NUM_REG_RD <= in_DECOD_IN_"+toString(i)+"_NUM_REG_RD ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_WRITE_RE <= in_DECOD_IN_"+toString(i)+"_WRITE_RE ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_NUM_REG_RE <= in_DECOD_IN_"+toString(i)+"_NUM_REG_RE ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_EXCEPTION_USE <= in_DECOD_IN_"+toString(i)+"_EXCEPTION_USE ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_EXCEPTION <= in_DECOD_IN_"+toString(i)+"_EXCEPTION ;");
      vhdl->set_body(0,"internal_DECOD_IN_"+toString(i)+"_VAL <= in_DECOD_IN_"+toString(i)+"_VAL ;");
      vhdl->set_body(0,"out_DECOD_IN_"+toString(i)+"_ACK <= internal_QUEUE_INSERT_ACK ;");
    }

    vhdl->set_body(0,"");

    vhdl->set_body(0,"internal_QUEUE_INSERT_VAL <= '0'");
    for(uint32_t i=0;i < _param->_nb_inst_decod;i++){
      vhdl->set_body(1," OR internal_DECOD_IN_"+toString(i)+"_VAL");
    }
    vhdl->set_body(1,";");

    vhdl->set_body(0,"");

    if(_param->_have_port_context_id){
      if(_param->_size_nb_inst_decod < 2){
	for(uint32_t i_context=0;i_context < _param->_nb_context;i_context++)
	  vhdl->set_body(0,"internal_NB_INST_"+toString(i_context)+"_ALL <= ( reg_NB_INST_"+toString(i_context)+"_ALL OR ( internal_DECOD_IN_0_VAL AND ( internal_QUEUE_INSERT_ACK AND internal_DECOD_OUT_0_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" ))) AND ( NOT ( internal_OUT_DECOD_OUT_0_VAL AND ( internal_DECOD_OUT_0_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" AND ( NOT internal_DECOD_OUT_0_VAL ))));");
      }
      else{
	for(uint32_t i_context=0;i_context < _param->_nb_context;i_context++){
	  
	  for(uint32_t i_inst=0;i_inst < _param->_nb_inst_decod;i_inst++){
	    vhdl->set_body(0,"internal_NB_INST_OUT_"+toString(i_context)+"_"+toString(i_inst)+"_CONTEXT <= "+std_logic_conv(_param->_size_nb_inst_decod,1)+" WHEN( internal_DECOD_OUT_"+toString(i_inst)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" AND internal_OUT_DECOD_OUT_"+toString(i_inst)+"_VAL = '1' AND internal_DECOD_OUT_"+toString(i_inst)+"_VAL = '0' ) ELSE "+std_logic_conv(_param->_size_nb_inst_decod,0)+";");
	    vhdl->set_body(0,"internal_NB_INST_IN_"+toString(i_context)+"_"+toString(i_inst)+"_CONTEXT <= "+std_logic_conv(_param->_size_nb_inst_decod,1)+" WHEN( internal_DECOD_IN_"+toString(i_inst)+"_VAL = '1' AND internal_QUEUE_INSERT_ACK = '1' AND internal_DECOD_IN_"+toString(i_inst)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" ) ELSE "+std_logic_conv(_param->_size_nb_inst_decod,0)+";");
	  }
	  
	  vhdl->set_body(0,"");
	  
	  vhdl->set_body(0,"internal_NB_INST_"+toString(i_context)+"_ALL <= reg_NB_INST_"+toString(i_context)+"_ALL");
	  
	  for(uint32_t i_inst=0;i_inst < _param->_nb_inst_decod;i_inst++){
	    vhdl->set_body(1,"+ internal_NB_INST_IN_"+toString(i_context)+"_"+toString(i_inst)+"_CONTEXT");
	    vhdl->set_body(1,"- internal_NB_INST_OUT_"+toString(i_context)+"_"+toString(i_inst)+"_CONTEXT");
	  }
	  vhdl->set_body(1,";");
	}
      }
    }
    else{
      if(_param->_size_nb_inst_decod < 2) vhdl->set_body(0,"internal_NB_INST_0_ALL <= ( reg_NB_INST_0_ALL OR ( internal_DECOD_IN_0_VAL AND internal_QUEUE_INSERT_ACK )) AND ( NOT ( internal_OUT_DECOD_OUT_0_VAL AND ( NOT internal_DECOD_OUT_0_VAL )));");
      else{
	for(uint32_t i_inst=0;i_inst < _param->_nb_inst_decod;i_inst++){
	  vhdl->set_body(0,"internal_NB_INST_OUT_0_"+toString(i_inst)+"_CONTEXT <= "+std_logic_conv(_param->_size_nb_inst_decod,1)+" WHEN(( internal_OUT_DECOD_OUT_"+toString(i_inst)+"_VAL = '1' ) AND internal_DECOD_OUT_"+toString(i_inst)+"_VAL = '0' ) ELSE "+std_logic_conv(_param->_size_nb_inst_decod,0)+";");
	  vhdl->set_body(0,"internal_NB_INST_IN_0_"+toString(i_inst)+"_CONTEXT <= "+std_logic_conv(_param->_size_nb_inst_decod,1)+" WHEN( internal_DECOD_IN_"+toString(i_inst)+"_VAL = '1' AND internal_QUEUE_INSERT_ACK = '1' ) ELSE "+std_logic_conv(_param->_size_nb_inst_decod,0)+";");
	}
	
	vhdl->set_body(0,"");
	
	vhdl->set_body(0,"internal_NB_INST_0_ALL <= reg_NB_INST_0_ALL");
	for(uint32_t i=0;i < _param->_nb_inst_decod;i++){
	  vhdl->set_body(1," + internal_NB_INST_IN_0_"+toString(i)+"_CONTEXT");
	  vhdl->set_body(1," - internal_NB_INST_OUT_0_"+toString(i)+"_CONTEXT");
	}
	vhdl->set_body(1,";");
      }
    }

    vhdl->set_body(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Sortie Queue                    ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_body(0,"");

    for(uint32_t i=0;i < _param->_nb_inst_decod;i++){

      vhdl->set_body(0,"");
      vhdl->set_comment(0,"-----------------------------------");
      vhdl->set_comment(0,"-- Instruction "+toString(i)+"                   ");
      vhdl->set_comment(0,"-----------------------------------");
      vhdl->set_body(0,"");

      if(_param->_have_port_context_id){
	vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_CONTEXT_ID <= internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID");
	for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	  
	  vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_CONTEXT_ID ");
	}
	vhdl->set_body(0," ;");
      }
      if(_param->_have_port_depth){
	vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_DEPTH <= internal_DECOD_OUT_"+toString(i)+"_DEPTH");
	for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	  
	  vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_DEPTH ");
	}
	vhdl->set_body(0," ;");
      }
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_TYPE <= internal_DECOD_OUT_"+toString(i)+"_TYPE");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_TYPE ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_OPERATION <= internal_DECOD_OUT_"+toString(i)+"_OPERATION");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_OPERATION ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_NO_EXECUTE <= internal_DECOD_OUT_"+toString(i)+"_NO_EXECUTE");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_NO_EXECUTE ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_IS_DELAY_SLOT <= internal_DECOD_OUT_"+toString(i)+"_IS_DELAY_SLOT");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_IS_DELAY_SLOT ");
      }
      vhdl->set_body(0," ;");
#ifdef DEBUG
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_ADDRESS <= internal_DECOD_OUT_"+toString(i)+"_ADDRESS");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_ADDRESS ");
      }
      vhdl->set_body(0," ;");
#endif
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_ADDRESS_NEXT <= internal_DECOD_OUT_"+toString(i)+"_ADDRESS_NEXT");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_ADDRESS_NEXT ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_HAS_IMMEDIAT <= internal_DECOD_OUT_"+toString(i)+"_HAS_IMMEDIAT");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_HAS_IMMEDIAT ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_IMMEDIAT <= internal_DECOD_OUT_"+toString(i)+"_IMMEDIAT");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_IMMEDIAT ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_READ_RA <= internal_DECOD_OUT_"+toString(i)+"_READ_RA");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_READ_RA ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RA <= internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RA");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_NUM_REG_RA ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_READ_RB <= internal_DECOD_OUT_"+toString(i)+"_READ_RB");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_READ_RB ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RB <= internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RB");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_NUM_REG_RB ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_READ_RC <= internal_DECOD_OUT_"+toString(i)+"_READ_RC");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_READ_RC ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RC <= internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RC");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_NUM_REG_RC ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_WRITE_RD <= internal_DECOD_OUT_"+toString(i)+"_WRITE_RD");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_WRITE_RD ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RD <= internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RD");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_NUM_REG_RD ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_WRITE_RE <= internal_DECOD_OUT_"+toString(i)+"_WRITE_RE");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_WRITE_RE ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RE <= internal_DECOD_OUT_"+toString(i)+"_NUM_REG_RE");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_NUM_REG_RE ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_EXCEPTION_USE <= internal_DECOD_OUT_"+toString(i)+"_EXCEPTION_USE");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod+1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_EXCEPTION_USE ");
      }
      vhdl->set_body(0," ;");
      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_EXCEPTION <= internal_DECOD_OUT_"+toString(i)+"_EXCEPTION");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod - 1;cp++){
	
	vhdl->set_body(1," WHEN( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod + 1,cp*2 + 1)+") ELSE internal_DECOD_OUT_"+toString(cp + 1)+"_EXCEPTION ");
      }
      vhdl->set_body(0," ;");

      vhdl->set_body(0,"");

      if(_param->_have_port_depth){
	if(_param->_have_port_context_id){
	  
	  vhdl->set_body(0,"internal_DECOD_"+toString(i)+"_VALID <= '1' WHEN(( in_DEPTH_0_FULL = '1' AND internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,0)+" ) ");
	  for(uint32_t i_context = 1;i_context < _param->_nb_context;i_context++)
	    vhdl->set_body(2," OR ( in_DEPTH_"+toString(i_context)+"_FULL = '1' AND internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" ) ");
	  
	  vhdl->set_body(1," ) ELSE '1' WHEN(( in_DEPTH_0_MIN = in_DEPTH_0_MAX AND internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,0)+" ) ");
	  for(uint32_t i_context = 1;i_context < _param->_nb_context;i_context++)
	    vhdl->set_body(2," OR ( in_DEPTH_"+toString(i_context)+"_MIN = in_DEPTH_"+toString(i_context)+"_MAX AND internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" ) ");
	  
	  vhdl->set_body(1," ) ELSE '1' WHEN((( internal_DECOD_OUT_"+toString(i)+"_DEPTH > in_DEPTH_0_MIN ) AND ( internal_DECOD_OUT_"+toString(i)+"_DEPTH < in_DEPTH_0_MAX ) AND ( in_DEPTH_0_MIN < in_DEPTH_0_MAX ) AND ( internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,0)+" )) ");
	  for(uint32_t i_context = 1;i_context < _param->_nb_context;i_context++)
	    vhdl->set_body(2," OR (( internal_DECOD_OUT_"+toString(i)+"_DEPTH > in_DEPTH_"+toString(i_context)+"_MIN ) AND ( internal_DECOD_OUT_"+toString(i)+"_DEPTH < in_DEPTH_"+toString(i_context)+"_MAX ) AND ( in_DEPTH_"+toString(i_context)+"_MIN < in_DEPTH_"+toString(i_context)+"_MAX ) AND internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" ) ");
	  
	  vhdl->set_body(1," ) ELSE '1' WHEN(((( internal_DECOD_OUT_"+toString(i)+"_DEPTH > in_DEPTH_0_MAX ) OR ( internal_DECOD_OUT_"+toString(i)+"_DEPTH < in_DEPTH_0_MIN )) AND ( in_DEPTH_0_MIN > in_DEPTH_0_MAX ) AND ( internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,0)+" ))");
	  for(uint32_t i_context = 1;i_context < _param->_nb_context;i_context++)
	    vhdl->set_body(2," OR ((( internal_DECOD_OUT_"+toString(i)+"_DEPTH > in_DEPTH_"+toString(i_context)+"_MAX ) OR ( internal_DECOD_OUT_"+toString(i)+"_DEPTH < in_DEPTH_"+toString(i_context)+"_MIN )) AND ( in_DEPTH_"+toString(i_context)+"_MIN > in_DEPTH_"+toString(i_context)+"_MAX ) AND internal_DECOD_OUT_"+toString(i)+"_CONTEXT_ID = "+std_logic_conv(_param->_size_context_id,i_context)+" ) ");
	  
	  vhdl->set_body(1," ) ELSE '0' ;");
	}
	else{
	  vhdl->set_body(0,"internal_DECOD_"+toString(i)+"_VALID <= '1' WHEN( in_DEPTH_0_FULL = '1' ) ELSE '1' WHEN( in_DEPTH_0_MIN = in_DEPTH_0_MAX ) ELSE '1' WHEN(( internal_DECOD_OUT_"+toString(i)+"_DEPTH > in_DEPTH_0_MIN ) AND ( internal_DECOD_OUT_"+toString(i)+"_DEPTH < in_DEPTH_0_MAX ) AND ( in_DEPTH_0_MIN < in_DEPTH_0_MAX )) ELSE '1' WHEN((( internal_DECOD_OUT_"+toString(i)+"_DEPTH > in_DEPTH_0_MAX ) OR ( internal_DECOD_OUT_"+toString(i)+"_DEPTH < in_DEPTH_0_MIN )) AND ( in_DEPTH_0_MIN > in_DEPTH_0_MAX )) ELSE '0' ;");
	}
	
	vhdl->set_body(0,"");
	
	vhdl->set_body(0,"internal_OUT_DECOD_OUT_"+toString(i)+"_VAL <= ( internal_QUEUE_OUT_"+toString(i)+"_VAL AND internal_QUEUE_RETIRE_VAL AND internal_DECOD_"+toString(i)+"_VALID ) WHEN( internal_QUEUE_NEW_HEAD = '1' ) ELSE reg_DECOD_OUT_"+toString(i)+"_VAL ;");
      }
      else vhdl->set_body(0,"internal_OUT_DECOD_OUT_"+toString(i)+"_VAL <= ( internal_QUEUE_OUT_"+toString(i)+"_VAL AND internal_QUEUE_RETIRE_VAL ) WHEN( internal_QUEUE_NEW_HEAD = '1' ) ELSE reg_DECOD_OUT_"+toString(i)+"_VAL ;");
      
      vhdl->set_body(0,"");
      
      vhdl->set_body(0,"internal_DECOD_OUT_"+toString(i)+"_VAL <= '0' WHEN(( in_DECOD_OUT_"+toString(i)+"_ACK = '1' ) AND ( internal_INDEX_"+toString(i)+" = "+std_logic_conv(_param->_size_nb_inst_decod + 1,i*2 + 1)+" ))");
      for(uint32_t cp = 0;cp < i;cp++){
	
	vhdl->set_body(1," ELSE '0' WHEN(( in_DECOD_OUT_"+toString(cp)+"_ACK = '1' ) AND ( internal_INDEX_"+toString(cp)+" = "+std_logic_conv(_param->_size_nb_inst_decod + 1,i*2 + 1)+" ))");
      }
      vhdl->set_body(1," ELSE '1' WHEN( internal_OUT_DECOD_OUT_"+toString(i)+"_VAL = '1' ) ELSE '0' ;");

      vhdl->set_body(0,"");

      vhdl->set_body(0,"out_DECOD_OUT_"+toString(i)+"_VAL <= internal_INDEX_"+toString(i)+"(0) ;");

      vhdl->set_body(0,"");

      vhdl->set_body(0,"internal_INDEX_"+toString(i)+" <= ");
      for(uint32_t cp = i;cp < _param->_nb_inst_decod;cp++){
	
	vhdl->set_body(1,std_logic_conv(_param->_size_nb_inst_decod + 1,cp*2 + 1)+" WHEN( internal_OUT_DECOD_OUT_"+toString(cp)+"_VAL = '1'");
	for(uint32_t cp2 = 0;cp2 < i;cp2++){
	
	  vhdl->set_body(2," AND NOT( internal_INDEX_"+toString(cp2)+" = "+std_logic_conv(_param->_size_nb_inst_decod + 1,cp*2 + 1)+" )");
	}
	vhdl->set_body(1," ) ELSE ");
      }
      vhdl->set_body(1,std_logic_conv(_param->_size_nb_inst_decod + 1,0)+" ;");
    }

    vhdl->set_body(0,"");

    vhdl->set_body(0,"internal_QUEUE_NEW_HEAD <= NOT( '0'");
    for(uint32_t i=0;i < _param->_nb_inst_decod;i++){
      vhdl->set_body(1," OR reg_DECOD_OUT_"+toString(i)+"_VAL");
    }
    vhdl->set_body(1,");");

    vhdl->set_body(0,"");

    vhdl->set_body(0,"internal_QUEUE_RETIRE_ACK <= NOT( '0'");
    for(uint32_t i=0;i < _param->_nb_inst_decod;i++){
      vhdl->set_body(1," OR internal_DECOD_OUT_"+toString(i)+"_VAL");
    }
    vhdl->set_body(1,");");

    vhdl->set_body(0,"");

    for(uint32_t i=0;i < _param->_nb_context;i++){
      vhdl->set_body(0,"out_NB_INST_"+toString(i)+"_ALL <= reg_NB_INST_"+toString(i)+"_ALL ;");
    }

    vhdl->set_body(0,"");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_comment(0,"-- Registers                       ");
    vhdl->set_comment(0,"-----------------------------------");
    vhdl->set_body(0,"");
    
    vhdl->set_body(0,"reg_DECOD_write: process (in_CLOCK)");
    vhdl->set_body(0,"begin");
    vhdl->set_body(1,"if in_CLOCK'event AND in_CLOCK = '1' then");
    vhdl->set_body(2,"if in_NRESET = '0' then");
    
    for(uint32_t i=0;i < _param->_nb_context;i++){
      vhdl->set_body(3,"reg_NB_INST_"+toString(i)+"_ALL <= "+std_logic_conv(_param->_size_nb_inst_decod,0)+";");
    }
    for(uint32_t i=0;i < _param->_nb_inst_decod;i++){
      vhdl->set_body(3,"reg_DECOD_OUT_"+toString(i)+"_VAL <= '0';");
    }

    vhdl->set_body(2,"else");
    
    for(uint32_t i=0;i < _param->_nb_context;i++){
      vhdl->set_body(3,"reg_NB_INST_"+toString(i)+"_ALL <= internal_NB_INST_"+toString(i)+"_ALL;");
    }  
    for(uint32_t i=0;i < _param->_nb_inst_decod;i++){
      vhdl->set_body(3,"reg_DECOD_OUT_"+toString(i)+"_VAL <= internal_DECOD_OUT_"+toString(i)+"_VAL;");
    }

    vhdl->set_body(2,"end if;");
    vhdl->set_body(1,"end if;");
    vhdl->set_body(0,"end process reg_DECOD_write;");

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
