/*
 * $Id: Read_queue.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


#undef  FUNCTION
#define FUNCTION "Read_queue::Read_queue"
  Read_queue::Read_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   std::string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics            * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage ):
    _name              (name)
    ,_param            (param)
    ,_usage (usage)
  {
    log_printf(FUNC,Read_queue,FUNCTION,_("<%s> Begin"),_name.c_str());

// #if DEBUG_Read_queue == true
//     log_printf(INFO,Read_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

#ifdef SYSTEMC
    log_printf(INFO,Read_queue,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation ();
#endif

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(INFO,Read_queue,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());
        
        statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {	
        // generate the vhdl
        log_printf(INFO,Read_queue,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
        
        vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {	
    log_printf(INFO,Read_queue,FUNCTION,_("<%s> Method - transition"),_name.c_str());

    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();

    log_printf(INFO,Read_queue,FUNCTION,_("<%s> Method - genMoore"),_name.c_str());

    SC_METHOD (genMoore);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg();

    log_printf(INFO,Read_queue,FUNCTION,_("<%s> Method - genMealy_read_queue_out_val"),_name.c_str());

    SC_METHOD (genMealy_read_queue_out_val);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg()
	      << (*(in_NRESET));
    for (uint32_t i=0; i<_param->_nb_gpr_read ; i++)
      sensitive << *(in_GPR_READ_ACK      [i]);
    for (uint32_t i=0; i<_param->_nb_spr_read ; i++)
      sensitive << *(in_SPR_READ_ACK      [i]);
    for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
      {
	if (_param->_have_port_ooo_engine_id)
	  sensitive << *(in_GPR_WRITE_OOO_ENGINE_ID [i]);

	sensitive << *(in_GPR_WRITE_VAL        [i])
		  << *(in_GPR_WRITE_NUM_REG    [i]);
      }
    for (uint32_t i=0; i<_param->_nb_spr_write; i++)
      {
	if (_param->_have_port_ooo_engine_id)
	  sensitive << *(in_SPR_WRITE_OOO_ENGINE_ID [i]);
	sensitive << *(in_SPR_WRITE_VAL        [i])
		  
		  << *(in_SPR_WRITE_NUM_REG    [i]);
      }
#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information

    (*(out_READ_QUEUE_OUT_VAL)) (*(in_GPR_READ_ACK                [0]));
    (*(out_READ_QUEUE_OUT_VAL)) (*(in_SPR_READ_ACK                [0]));
    
    for (uint32_t i=0; i<_param->_nb_gpr_write ; i++)
      {
	(*(out_READ_QUEUE_OUT_VAL)) (*(in_GPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	(*(out_READ_QUEUE_OUT_VAL)) (*(in_GPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_VAL)) (*(in_GPR_WRITE_NUM_REG    [i]));
      }
    for (uint32_t i=0; i<_param->_nb_spr_write ; i++)
      {
	(*(out_READ_QUEUE_OUT_VAL)) (*(in_SPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	(*(out_READ_QUEUE_OUT_VAL)) (*(in_SPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_VAL)) (*(in_SPR_WRITE_NUM_REG    [i]));
      }
#endif    
    
    log_printf(INFO,Read_queue,FUNCTION,_("<%s> Method - genMealy_read_queue_out_gpr"),_name.c_str());

    SC_METHOD (genMealy_read_queue_out_gpr);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg()
	      << (*(in_NRESET));
    for (uint32_t i=0; i<_param->_nb_gpr_read ; i++)
      sensitive << *(in_GPR_READ_ACK      [i])
		<< *(in_GPR_READ_DATA     [i])
		<< *(in_GPR_READ_DATA_VAL [i]);
    for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
      {
	if (_param->_have_port_ooo_engine_id)
	  sensitive << *(in_GPR_WRITE_OOO_ENGINE_ID [i]);
	sensitive << *(in_GPR_WRITE_VAL        [i])
		  << *(in_GPR_WRITE_NUM_REG    [i])
		  << *(in_GPR_WRITE_DATA       [i]);
      }
#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information

    (*(out_READ_QUEUE_OUT_DATA_RA_VAL)) (*(in_GPR_READ_ACK                [0]));
    (*(out_READ_QUEUE_OUT_DATA_RA_VAL)) (*(in_GPR_READ_DATA_VAL           [0]));
    (*(out_READ_QUEUE_OUT_DATA_RB_VAL)) (*(in_GPR_READ_ACK                [1]));
    (*(out_READ_QUEUE_OUT_DATA_RB_VAL)) (*(in_GPR_READ_DATA_VAL           [1]));
    
    (*(out_READ_QUEUE_OUT_DATA_RA    )) (*(in_GPR_READ_DATA               [0]));
    (*(out_READ_QUEUE_OUT_DATA_RB    )) (*(in_GPR_READ_DATA               [1]));
    
    for (uint32_t i=0; i<_param->_nb_gpr_write ; i++)
      {
	(*(out_READ_QUEUE_OUT_DATA_RA_VAL)) (*(in_GPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	  (*(out_READ_QUEUE_OUT_DATA_RA_VAL)) (*(in_GPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_DATA_RA_VAL)) (*(in_GPR_WRITE_NUM_REG    [i]));
	(*(out_READ_QUEUE_OUT_DATA_RB_VAL)) (*(in_GPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	  (*(out_READ_QUEUE_OUT_DATA_RB_VAL)) (*(in_GPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_DATA_RB_VAL)) (*(in_GPR_WRITE_NUM_REG    [i]));

	(*(out_READ_QUEUE_OUT_DATA_RA    )) (*(in_GPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	  (*(out_READ_QUEUE_OUT_DATA_RA    )) (*(in_GPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_DATA_RA    )) (*(in_GPR_WRITE_NUM_REG    [i]));
	(*(out_READ_QUEUE_OUT_DATA_RA    )) (*(in_GPR_WRITE_DATA       [i]));
	(*(out_READ_QUEUE_OUT_DATA_RB    )) (*(in_GPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	  (*(out_READ_QUEUE_OUT_DATA_RB    )) (*(in_GPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_DATA_RB    )) (*(in_GPR_WRITE_NUM_REG    [i]));
	(*(out_READ_QUEUE_OUT_DATA_RB    )) (*(in_GPR_WRITE_DATA       [i]));
      }
#endif    

    log_printf(INFO,Read_queue,FUNCTION,_("<%s> Method - genMealy_read_queue_out_spr"),_name.c_str());

    SC_METHOD (genMealy_read_queue_out_spr);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg()
	      << (*(in_NRESET));
    for (uint32_t i=0; i<_param->_nb_spr_read ; i++)
      sensitive << *(in_SPR_READ_ACK      [i])
		<< *(in_SPR_READ_DATA     [i])
		<< *(in_SPR_READ_DATA_VAL [i]);
    for (uint32_t i=0; i<_param->_nb_spr_write; i++)
      {
	if (_param->_have_port_ooo_engine_id)
	  sensitive << *(in_SPR_WRITE_OOO_ENGINE_ID [i]);
	sensitive << *(in_SPR_WRITE_VAL        [i])
		  << *(in_SPR_WRITE_NUM_REG    [i])
		  << *(in_SPR_WRITE_DATA       [i]);
      }
#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information

    (*(out_READ_QUEUE_OUT_DATA_RC_VAL)) (*(in_SPR_READ_ACK                [0]));
    (*(out_READ_QUEUE_OUT_DATA_RC_VAL)) (*(in_SPR_READ_DATA_VAL           [0]));
    
    (*(out_READ_QUEUE_OUT_DATA_RC    )) (*(in_SPR_READ_DATA               [0]));
    
    for (uint32_t i=0; i<_param->_nb_spr_write ; i++)
      {
	(*(out_READ_QUEUE_OUT_DATA_RC_VAL)) (*(in_SPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	  (*(out_READ_QUEUE_OUT_DATA_RC_VAL)) (*(in_SPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_DATA_RC_VAL)) (*(in_SPR_WRITE_NUM_REG    [i]));

	(*(out_READ_QUEUE_OUT_DATA_RC    )) (*(in_SPR_WRITE_VAL        [i]));
	if (_param->_have_port_ooo_engine_id)
	  (*(out_READ_QUEUE_OUT_DATA_RC    )) (*(in_SPR_WRITE_OOO_ENGINE_ID [i]));
	(*(out_READ_QUEUE_OUT_DATA_RC    )) (*(in_SPR_WRITE_NUM_REG    [i]));
	(*(out_READ_QUEUE_OUT_DATA_RC    )) (*(in_SPR_WRITE_DATA       [i]));
      }
#endif    
      }
#endif
    log_printf(FUNC,Read_queue,FUNCTION,_("<%s> End"),_name.c_str());
  };

#undef  FUNCTION
#define FUNCTION "Read_queue::~Read_queue"
  Read_queue::~Read_queue (void)
  {
    log_printf(FUNC,Read_queue,FUNCTION,_("<%s> Begin"),_name.c_str());

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(INFO,Read_queue,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());
        
        delete _stat;
      }
#endif

#ifdef SYSTEMC
    log_printf(INFO,Read_queue,FUNCTION,_("<%s> Deallocation"),_name.c_str());

    deallocation ();
#endif

    log_printf(FUNC,Read_queue,FUNCTION,_("<%s> End"),_name.c_str());
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
