#ifdef SYSTEMC
/*
 * $Id: Execute_queue_transition.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::transition"
  void Execute_queue::transition (void)
  {
    log_begin(Execute_queue,FUNCTION);
    log_function(Execute_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
	// Flush queue
	// FIXME "queue reset"
	// > 1) flush one slot by cycle
	// > 2) flush all slot in one cycle

        _queue->clear();
      }
    else
      {
	// Test if push
	if (PORT_READ(in_EXECUTE_QUEUE_IN_VAL) and internal_EXECUTE_QUEUE_IN_ACK)
	  {
	    execute_queue_entry_t * entry = new execute_queue_entry_t
	      ((_param->_have_port_context_id   )?PORT_READ(in_EXECUTE_QUEUE_IN_CONTEXT_ID   ):0,
	       (_param->_have_port_front_end_id )?PORT_READ(in_EXECUTE_QUEUE_IN_FRONT_END_ID ):0,
	       (_param->_have_port_ooo_engine_id)?PORT_READ(in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID):0,
	       (_param->_have_port_rob_ptr      )?PORT_READ(in_EXECUTE_QUEUE_IN_PACKET_ID    ):0,
	     //PORT_READ(in_EXECUTE_QUEUE_IN_OPERATION    ),
	     //PORT_READ(in_EXECUTE_QUEUE_IN_TYPE         ),
               PORT_READ(in_EXECUTE_QUEUE_IN_CANCEL       ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_FLAGS        ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_EXCEPTION    ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_NO_SEQUENCE  ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_ADDRESS      ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_DATA         ));
	    
	    _queue->push_back(entry);
	  }

	// Test if pop
	if (internal_EXECUTE_QUEUE_OUT_VAL and PORT_READ(in_EXECUTE_QUEUE_OUT_ACK))
	  {
	    delete _queue->front();
	    _queue->pop_front();
	  }
      }

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      *(_stat_use_queue) += _queue->size();
#endif
    
#if DEBUG_Execute_queue and (DEBUG >= DEBUG_TRACE)
    log_printf(TRACE,Execute_queue,FUNCTION,"  * Dump Execute_queue");
    {
      uint32_t i=0;
      for (std::list<execute_queue_entry_t *>::iterator it=_queue->begin();
           it!=_queue->end();
           ++it)
        {
          log_printf(TRACE,Execute_queue,FUNCTION,"  [%d] %.2d %.2d %.2d, %.1d, %.4d, %.1d, %.2d %.1d, %.8x %.8x",
                     i,
                     (*it)->_context_id   ,
                     (*it)->_front_end_id ,
                     (*it)->_ooo_engine_id,
                     (*it)->_packet_id    ,
                   //(*it)->_operation    ,
                   //(*it)->_type         ,
                     (*it)->_cancel       ,
                     (*it)->_flags        ,
                     (*it)->_exception    ,
                     (*it)->_no_sequence  ,
                     (*it)->_address      ,
                     (*it)->_data
                     );
          i++;
        }
    }
#endif


#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(Execute_queue,FUNCTION);
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
