#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id: Register_unit_Glue_genMealy_insert.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::genMealy_insert"
  void Register_unit_Glue::genMealy_insert (void)
  {
    log_begin(Register_unit_Glue,FUNCTION);
    log_function(Register_unit_Glue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
      {
	Tcontrol_t val            = PORT_READ(in_ISSUE_VAL    [i]);
	Tcontrol_t gpr_use        = PORT_READ(in_ISSUE_RD_USE [i]);
	Tcontrol_t spr_use        = PORT_READ(in_ISSUE_RE_USE [i]);
	Tcontext_t ooo_engine_id  = (_param->_have_port_ooo_engine_id)?PORT_READ(in_ISSUE_VAL [i]):0;
	Tcontrol_t gpr_status_ack = PORT_READ(in_ISSUE_GPR_STATUS_ACK [ooo_engine_id][i]);
	Tcontrol_t spr_status_ack = PORT_READ(in_ISSUE_SPR_STATUS_ACK [ooo_engine_id][i]);

	Tcontrol_t ack            = (gpr_status_ack and 
				     spr_status_ack);	    
	Tcontrol_t gpr_status_val = (val     and 
				     gpr_use and 
				     spr_status_ack);
	Tcontrol_t spr_status_val = (val     and 
				     spr_use and
				     gpr_status_ack);
	
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"  * issue [%d]",i);	
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * ooo_engine_id  (w) : %d",ooo_engine_id );
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * val            (r) : %d",val           );
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * ack            (w) : %d",ack           );
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * gpr_use (rd)   (r) : %d",gpr_use       );
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * gpr_status_val (w) : %d",gpr_status_val);
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * gpr_status_ack (r) : %d",gpr_status_ack);
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * spr_use (re)   (r) : %d",spr_use       );
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * spr_status_val (w) : %d",spr_status_val);
	log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * spr_status_ack (r) : %d",spr_status_ack);
	
	PORT_WRITE(out_ISSUE_ACK                           [i], ack           );
	PORT_WRITE(out_ISSUE_GPR_STATUS_VAL [ooo_engine_id][i], gpr_status_val);
	PORT_WRITE(out_ISSUE_SPR_STATUS_VAL [ooo_engine_id][i], spr_status_val);

	for (uint32_t j=0; j<_param->_nb_ooo_engine; ++j)
	  if (j!=ooo_engine_id)
	    {
	      PORT_WRITE(out_ISSUE_GPR_STATUS_VAL [j][i], 0);
	      PORT_WRITE(out_ISSUE_SPR_STATUS_VAL [j][i], 0);
	    }
        }
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
	  {
	    PORT_WRITE(out_ISSUE_ACK               [i], 0);
	    for (uint32_t j=0; j<_param->_nb_ooo_engine; j++)
	      {
	    PORT_WRITE(out_ISSUE_GPR_STATUS_VAL [j][i], 0);
	    PORT_WRITE(out_ISSUE_SPR_STATUS_VAL [j][i], 0);
	      }
	  }
      }

//     if (PORT_READ(in_NRESET))
//       {
//     for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
//       for (uint32_t j=0; j<_param->_nb_inst_insert_rob [i]; j++)
//         {
//           Tcontrol_t val            = PORT_READ(in_INSERT_ROB_VAL [i][j]);
//           Tcontrol_t gpr_use        = PORT_READ(in_INSERT_ROB_RD_USE [i][j]);
//           Tcontrol_t spr_use        = PORT_READ(in_INSERT_ROB_RE_USE [i][j]);
//           Tcontrol_t gpr_status_ack = PORT_READ(in_INSERT_ROB_GPR_STATUS_ACK [i][j]);
//           Tcontrol_t spr_status_ack = PORT_READ(in_INSERT_ROB_SPR_STATUS_ACK [i][j]);
	  
//           Tcontrol_t ack            = (gpr_status_ack and 
//                                        spr_status_ack);	    
//           Tcontrol_t gpr_status_val = (val     and 
//                                        gpr_use and 
//                                        spr_status_ack);
//           Tcontrol_t spr_status_val = (val     and 
//                                        spr_use and
//                                        gpr_status_ack);

//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"  * insert_rob [%d][%d]",i,j);
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * val            (r) : %d",val           );
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * ack            (w) : %d",ack           );
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * gpr_use (rd)   (r) : %d",gpr_use       );
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * gpr_status_val (w) : %d",gpr_status_val);
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * gpr_status_ack (r) : %d",gpr_status_ack);
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * spr_use (re)   (r) : %d",spr_use       );
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * spr_status_val (w) : %d",spr_status_val);
//           log_printf(TRACE,Register_unit_Glue,FUNCTION,"    * spr_status_ack (r) : %d",spr_status_ack);

//           PORT_WRITE(out_INSERT_ROB_ACK            [i][j], ack           );
//           PORT_WRITE(out_INSERT_ROB_GPR_STATUS_VAL [i][j], gpr_status_val);
//           PORT_WRITE(out_INSERT_ROB_SPR_STATUS_VAL [i][j], spr_status_val);
//         }
//       }
//     else
//       {
//         for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
//           for (uint32_t j=0; j<_param->_nb_inst_insert_rob [i]; j++)
//             {
//               PORT_WRITE(out_INSERT_ROB_ACK            [i][j], 0);
//               PORT_WRITE(out_INSERT_ROB_GPR_STATUS_VAL [i][j], 0);
//               PORT_WRITE(out_INSERT_ROB_SPR_STATUS_VAL [i][j], 0);
//             }
//       }

    log_end(Register_unit_Glue,FUNCTION);
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
