#ifdef SYSTEMC
/*
 * $Id: Ifetch_queue_function_full_assoc_genMoore.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {

#undef  FUNCTION
#define FUNCTION "Ifetch_queue::function_full_assoc_genMoore"
  void Ifetch_queue::function_full_assoc_genMoore (void)
  {
    log_begin(Ifetch_queue,FUNCTION);
    log_function(Ifetch_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    // ==========================================================
    // =====[ ADDRESS ]==========================================
    // ==========================================================
    {
      internal_ADDRESS_ACK = (_queue[reg_PTR_WRITE]->_state == IFETCH_QUEUE_STATE_EMPTY);
 
      log_printf(TRACE,Ifetch_queue,FUNCTION,"  * ADDRESS_ACK : %d",internal_ADDRESS_ACK);
     
      if (_param->_have_port_ifetch_queue_ptr)
      PORT_WRITE(out_ADDRESS_IFETCH_QUEUE_ID, reg_PTR_WRITE);
    }

    // ==========================================================
    // =====[ DECOD ]============================================
    // ==========================================================
    {
      bool     stop = false;
      uint32_t inst = 0;

      // init
      for (uint32_t i=0; i<_param->_nb_instruction; ++i)
	internal_DECOD_VAL [i] = 0;

      for (uint32_t i=0; i<_param->_size_queue; ++i)
	{	
	  uint32_t ptr = (reg_PTR_READ+i)%_param->_size_queue;
  
	  // Test if have an respons
	  if (_queue[ptr]->_state == IFETCH_QUEUE_STATE_HAVE_RSP)
	    {
	      for (uint32_t j=0; j<_param->_nb_instruction; j++)
		{
		  // test if instruction is enable
		  if (_queue[ptr]->_instruction_enable [j])
		    {
		      log_printf(TRACE,Ifetch_queue,FUNCTION,"  * DECOD_VAL [%d] : ifetch_queue[%d][%d]",inst,ptr,j);
		      
		      // Find an valid instruction
		      internal_DECOD_VAL [inst] = true;
		      internal_DECOD_PTR [inst] = ptr;
		      internal_DECOD_SLOT[inst] = j;
		      
		      // Get info
		      Tgeneral_address_t address                     = _queue[ptr]->_address;
		      Tinst_ifetch_ptr_t inst_ifetch_ptr             = _queue[ptr]->_inst_ifetch_ptr;
		      Tbranch_state_t    branch_state                = _queue[ptr]->_branch_state;
		      Tprediction_ptr_t  branch_update_prediction_id = _queue[ptr]->_branch_update_prediction_id;
		      Texception_t       exception                   = _queue[ptr]->_exception;
		      
		      PORT_WRITE(out_DECOD_INSTRUCTION                [inst],_queue[ptr]->_instruction [j]);
		      PORT_WRITE(out_DECOD_ADDRESS                    [inst],address+j);
		      
		      // Warning : ONE BRANCH PER SLOT
		      if (inst_ifetch_ptr == j)
		      PORT_WRITE(out_DECOD_BRANCH_STATE               [inst],branch_state);
		      else
		      PORT_WRITE(out_DECOD_BRANCH_STATE               [inst],BRANCH_STATE_NONE);
		      if (_param->_have_port_depth)
		      PORT_WRITE(out_DECOD_BRANCH_UPDATE_PREDICTION_ID[inst],branch_update_prediction_id);
		      PORT_WRITE(out_DECOD_EXCEPTION                  [inst],exception); // all is same
		      
		      inst ++;
		      
		      // Test if have all slot
		      if (inst >= _param->_nb_instruction)
			stop = true;
		    }
		  if (stop)
		    break;
		}
	    }
	  else
	    stop = true; // slot have not respons -> exit the loop
	 
	  // if not find an valid instruction, break the loop
	  if (stop)
	    break;
	}
    }
      }
    else
      {
        // Reset
        internal_ADDRESS_ACK = 0;
        for (uint32_t i=0; i<_param->_nb_instruction; i++)
          internal_DECOD_VAL [i] = 0;
        
      }

    // Write Output
    PORT_WRITE(out_ADDRESS_ACK  , internal_ADDRESS_ACK);
    for (uint32_t i=0; i<_param->_nb_instruction; i++)
    PORT_WRITE(out_DECOD_VAL [i], internal_DECOD_VAL [i]);

    log_end(Ifetch_queue,FUNCTION);
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
