#ifdef SYSTEMC
/*
 * $Id: Execute_loop_Glue_genMealy_issue.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Execute_loop_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace execute_loop_glue {


#undef  FUNCTION
#define FUNCTION "Execute_loop_Glue::genMealy_issue"
  void Execute_loop_Glue::genMealy_issue (void)
  {
    log_begin(Execute_loop_Glue,FUNCTION);

    for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
      {
	Tcontrol_t ack              ;
	Tcontrol_t read_unit_val    ;
	Tcontrol_t register_unit_val;
	
	if (PORT_READ(in_NRESET))
	  {
	    Tcontrol_t val               = PORT_READ(in_ISSUE_VAL               [i]);
	    Tcontrol_t read_unit_ack     = PORT_READ(in_ISSUE_READ_UNIT_ACK     [i]);
	    Tcontrol_t register_unit_ack = PORT_READ(in_ISSUE_REGISTER_UNIT_ACK [i]);

	    ack               = (
// 				 val               and
				 read_unit_ack     and
				 register_unit_ack
				 );
	    read_unit_val     = (
				 val               and
// 				 read_unit_ack     and
				 register_unit_ack
				 );
	    register_unit_val = (
				 val               and
				 read_unit_ack     // and
// 				 register_unit_ack
				 );
	  }
	else
	  {
	    ack               = false;
	    read_unit_val     = false;
	    register_unit_val = false;
	  }

	PORT_WRITE(out_ISSUE_ACK               [i],ack              );
	PORT_WRITE(out_ISSUE_READ_UNIT_VAL     [i],read_unit_val    );
	PORT_WRITE(out_ISSUE_REGISTER_UNIT_VAL [i],register_unit_val);
      }
    
    log_end(Execute_loop_Glue,FUNCTION);
  };

}; // end namespace execute_loop_glue
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
