#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_read_queue_Read_queue_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_read_queue_Read_queue_h

/*
 * $Id: Read_queue.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <list>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {

  class Read_queue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK               ;
  public    : SC_IN (Tcontrol_t        )    *  in_NRESET              ;

    // ~~~~~[ Interface "read_queue_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_VAL                  ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_IN_ACK                  ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_QUEUE_IN_CONTEXT_ID           ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_QUEUE_IN_FRONT_END_ID         ;
  public    : SC_IN (Tcontext_t        )    *  in_READ_QUEUE_IN_OOO_ENGINE_ID        ;
  public    : SC_IN (Tpacket_t         )    *  in_READ_QUEUE_IN_ROB_ID               ;
  public    : SC_IN (Toperation_t      )    *  in_READ_QUEUE_IN_OPERATION            ;
  public    : SC_IN (Ttype_t           )    *  in_READ_QUEUE_IN_TYPE                 ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_CANCEL               ;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_READ_QUEUE_IN_STORE_QUEUE_PTR_WRITE;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_READ_QUEUE_IN_STORE_QUEUE_PTR_READ ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_STORE_QUEUE_EMPTY    ;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_READ_QUEUE_IN_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_HAS_IMMEDIAT         ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_READ_QUEUE_IN_IMMEDIAT             ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_READ_RA              ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RA           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_READ_RB              ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RB           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_READ_RC              ;
  public    : SC_IN (Tspecial_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RC           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_WRITE_RD             ;
  public    : SC_IN (Tgeneral_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RD           ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_IN_WRITE_RE             ;
  public    : SC_IN (Tspecial_address_t)    *  in_READ_QUEUE_IN_NUM_REG_RE           ;

    // ~~~~~[ Interface "read_queue_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_VAL                  ;
  public    : SC_IN (Tcontrol_t        )    *  in_READ_QUEUE_OUT_ACK                  ;
  public    : SC_OUT(Tcontext_t        )    * out_READ_QUEUE_OUT_CONTEXT_ID           ;
  public    : SC_OUT(Tcontext_t        )    * out_READ_QUEUE_OUT_FRONT_END_ID         ;
  public    : SC_OUT(Tcontext_t        )    * out_READ_QUEUE_OUT_OOO_ENGINE_ID        ;
  public    : SC_OUT(Tpacket_t         )    * out_READ_QUEUE_OUT_ROB_ID               ;
  public    : SC_OUT(Toperation_t      )    * out_READ_QUEUE_OUT_OPERATION            ;
  public    : SC_OUT(Ttype_t           )    * out_READ_QUEUE_OUT_TYPE                 ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_CANCEL               ;
  public    : SC_OUT(Tlsq_ptr_t        )    * out_READ_QUEUE_OUT_STORE_QUEUE_PTR_WRITE;
  public    : SC_OUT(Tlsq_ptr_t        )    * out_READ_QUEUE_OUT_STORE_QUEUE_PTR_READ ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_STORE_QUEUE_EMPTY    ;
  public    : SC_OUT(Tlsq_ptr_t        )    * out_READ_QUEUE_OUT_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_HAS_IMMEDIAT         ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_READ_QUEUE_OUT_IMMEDIAT             ;
//public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_READ_RA              ;
  public    : SC_OUT(Tgeneral_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RA           ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_DATA_RA_VAL          ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_READ_QUEUE_OUT_DATA_RA              ;
//public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_READ_RB              ;
  public    : SC_OUT(Tgeneral_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RB           ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_DATA_RB_VAL          ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_READ_QUEUE_OUT_DATA_RB              ;
//public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_READ_RC              ;
  public    : SC_OUT(Tspecial_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RC           ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_DATA_RC_VAL          ;
  public    : SC_OUT(Tspecial_data_t   )    * out_READ_QUEUE_OUT_DATA_RC              ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_WRITE_RD             ;
  public    : SC_OUT(Tgeneral_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RD           ;
  public    : SC_OUT(Tcontrol_t        )    * out_READ_QUEUE_OUT_WRITE_RE             ;
  public    : SC_OUT(Tspecial_address_t)    * out_READ_QUEUE_OUT_NUM_REG_RE           ;

    // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_READ_VAL          ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_ACK          ;
  public    : SC_OUT(Tcontext_t        )   ** out_GPR_READ_OOO_ENGINE_ID;
  public    : SC_OUT(Tgeneral_address_t)   ** out_GPR_READ_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_READ_DATA         ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_DATA_VAL     ;

    // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_READ_VAL          ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_ACK          ;
  public    : SC_OUT(Tcontext_t        )   ** out_SPR_READ_OOO_ENGINE_ID;
  public    : SC_OUT(Tspecial_address_t)   ** out_SPR_READ_NUM_REG      ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_READ_DATA         ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_DATA_VAL     ;

    // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_WRITE_DATA         ;

    // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_WRITE_DATA         ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : Tread_queue_head_entry_t       * _queue_head;
  protected : std::list<Tread_queue_entry_t *>   * _queue;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_VAL         ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_READ_RA_VAL ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_READ_RB_VAL ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_READ_RC_VAL ;

  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_DATA_RA_VAL ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_DATA_RB_VAL ;
  protected  :Tgeneral_data_t                  internal_READ_QUEUE_OUT_DATA_RA     ;
  protected  :Tgeneral_data_t                  internal_READ_QUEUE_OUT_DATA_RB     ;
  protected  :Tcontrol_t                       internal_READ_QUEUE_OUT_DATA_RC_VAL ;
  protected  :Tspecial_data_t                  internal_READ_QUEUE_OUT_DATA_RC     ;
#endif

    // -----[ methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Read_queue);
#endif
  public  :          Read_queue              (
#ifdef SYSTEMC
					      sc_module_name                              name,
#else					       
					      std::string                                 name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
					      Parameters                                  * param,
					      morpheo::behavioural::Tusage_t                usage);
					       
  public  :          Read_queue              (Parameters * param );
  public  :          ~Read_queue             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                  (void);
  private : void     deallocation                (void);
					       
  public  : void     transition                  (void);
  public  : void     genMoore                    (void);
  public  : void     genMealy_read_queue_out_val (void); 
  public  : void     genMealy_read_queue_out_gpr (void);
  public  : void     genMealy_read_queue_out_spr (void);
#endif					       
#ifdef STATISTICS
  public  : void     statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
			
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
