#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_register_unit_register_unit_glue_Register_unit_Glue_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_register_unit_register_unit_glue_Register_unit_Glue_h

/*
 * $Id: Register_unit_Glue.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {


  class Register_unit_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const std::string       _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK  ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET ;
//public    : SC_OUT(Tcontrol_t        )    * out_CONST_0;
//public    : SC_OUT(Tcontrol_t        )    * out_CONST_1;

    // ~~~~~[Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_VAL              ;
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_READ_ACK              ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_READ_OOO_ENGINE_ID    ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_GPR_READ_DATA             ;
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_READ_DATA_VAL         ;

  public    : SC_OUT(Tcontrol_t        )  *** out_GPR_READ_REGISTERFILE_VAL ;
  public    : SC_IN (Tcontrol_t        )  ***  in_GPR_READ_REGISTERFILE_ACK ;
  public    : SC_IN (Tgeneral_data_t   )  ***  in_GPR_READ_REGISTERFILE_DATA;

  public    : SC_OUT(Tcontrol_t        )  *** out_GPR_READ_STATUS_VAL       ;
  public    : SC_IN (Tcontrol_t        )  ***  in_GPR_READ_STATUS_ACK       ;
  public    : SC_IN (Tgeneral_data_t   )  ***  in_GPR_READ_STATUS_DATA_VAL  ; // type for compatibility with the registerFile

    // ~~~~~[Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_VAL              ;
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_READ_ACK              ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_READ_OOO_ENGINE_ID    ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_SPR_READ_DATA             ;
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_READ_DATA_VAL         ;

  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_READ_REGISTERFILE_VAL ;
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_READ_REGISTERFILE_ACK ;
  public    : SC_IN (Tspecial_data_t   )  ***  in_SPR_READ_REGISTERFILE_DATA;

  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_READ_STATUS_VAL       ;
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_READ_STATUS_ACK       ;
  public    : SC_IN (Tspecial_data_t   )  ***  in_SPR_READ_STATUS_DATA_VAL  ; // type for compatibility with the registerFile

    // ~~~~~[Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_VAL             ;
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_WRITE_ACK             ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_OOO_ENGINE_ID   ;

  public    : SC_OUT(Tcontrol_t        )  *** out_GPR_WRITE_REGISTERFILE_VAL;
  public    : SC_IN (Tcontrol_t        )  ***  in_GPR_WRITE_REGISTERFILE_ACK;

  public    : SC_OUT(Tcontrol_t        )  *** out_GPR_WRITE_STATUS_VAL      ;
  public    : SC_IN (Tcontrol_t        )  ***  in_GPR_WRITE_STATUS_ACK      ;
  public    : SC_OUT(Tgeneral_data_t   )  *** out_GPR_WRITE_STATUS_DATA     ; // type for compatibility with the registerFile
    
    // ~~~~~[Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_VAL             ;
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_WRITE_ACK             ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_OOO_ENGINE_ID   ;

  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_WRITE_REGISTERFILE_VAL;
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_WRITE_REGISTERFILE_ACK;

  public    : SC_OUT(Tcontrol_t        )  *** out_SPR_WRITE_STATUS_VAL      ;
  public    : SC_IN (Tcontrol_t        )  ***  in_SPR_WRITE_STATUS_ACK      ;
  public    : SC_OUT(Tspecial_data_t   )  *** out_SPR_WRITE_STATUS_DATA     ; // type for compatibility with the registerFile

    // ~~~~~[Interface "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  **  in_ISSUE_VAL                  ;
  public    : SC_OUT(Tcontrol_t        )  ** out_ISSUE_ACK                  ;
  public    : SC_IN (Tcontext_t        )  **  in_ISSUE_OOO_ENGINE_ID        ;
  public    : SC_IN (Tcontrol_t        )  **  in_ISSUE_RD_USE               ;
  public    : SC_IN (Tcontrol_t        )  **  in_ISSUE_RE_USE               ;

  public    : SC_OUT(Tcontrol_t        ) *** out_ISSUE_GPR_STATUS_VAL       ;
  public    : SC_IN (Tcontrol_t        ) ***  in_ISSUE_GPR_STATUS_ACK       ;
  public    : SC_OUT(Tgeneral_data_t   ) *** out_ISSUE_GPR_STATUS_DATA      ; // type for compatibility with the registerFile

  public    : SC_OUT(Tcontrol_t        ) *** out_ISSUE_SPR_STATUS_VAL       ;
  public    : SC_IN (Tcontrol_t        ) ***  in_ISSUE_SPR_STATUS_ACK       ;
  public    : SC_OUT(Tspecial_data_t   ) *** out_ISSUE_SPR_STATUS_DATA      ; // type for compatibility with the registerFile

//     // ~~~~~[Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_VAL                       ;
//   public    : SC_OUT(Tcontrol_t        )  *** out_INSERT_ROB_ACK                       ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_RD_USE                    ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_RE_USE                    ;

//   public    : SC_OUT(Tcontrol_t        )  *** out_INSERT_ROB_GPR_STATUS_VAL            ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_GPR_STATUS_ACK            ;
//   public    : SC_OUT(Tgeneral_data_t   )  *** out_INSERT_ROB_GPR_STATUS_DATA           ; // type for compatibility with the registerFile

//   public    : SC_OUT(Tcontrol_t        )  *** out_INSERT_ROB_SPR_STATUS_VAL            ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_SPR_STATUS_ACK            ;
//   public    : SC_OUT(Tspecial_data_t   )  *** out_INSERT_ROB_SPR_STATUS_DATA           ; // type for compatibility with the registerFile

//     // ~~~~~[Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_VAL                       ;
//   public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_ROB_ACK                       ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RD_OLD_USE                ; 
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RD_NEW_USE                ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RE_OLD_USE                ; 
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RE_NEW_USE                ;

//   public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_ROB_GPR_STATUS_NEW_VAL        ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_GPR_STATUS_NEW_ACK        ;
//   public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_ROB_GPR_STATUS_OLD_VAL        ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_GPR_STATUS_OLD_ACK        ;

//   public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_ROB_SPR_STATUS_NEW_VAL        ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_SPR_STATUS_NEW_ACK        ;
//   public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_ROB_SPR_STATUS_OLD_VAL        ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_SPR_STATUS_OLD_ACK        ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Register_unit_Glue);
#endif
  public  :          Register_unit_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                        name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Register_unit_Glue             (void);
					       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void     constant                        (void);
  public  : void     transition                      (void);
  public  : void     genMealy_gpr_read               (void);
  public  : void     genMealy_gpr_read_status        (void);
  public  : void     genMealy_gpr_read_registerfile  (void);
  public  : void     genMealy_gpr_write              (void);
  public  : void     genMealy_gpr_write_status       (void);
  public  : void     genMealy_gpr_write_registerfile (void);
  public  : void     genMealy_spr_read               (void);
  public  : void     genMealy_spr_read_status        (void);
  public  : void     genMealy_spr_read_registerfile  (void);
  public  : void     genMealy_spr_write              (void);
  public  : void     genMealy_spr_write_status       (void);
  public  : void     genMealy_spr_write_registerfile (void);
  public  : void     genMealy_insert                 (void);
  public  : void     genMealy_retire                 (void);
#endif					       

#ifdef STATISTICS
  public  : void     statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
