/*
 * $Id: Execute_loop_Glue.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Execute_loop_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace execute_loop_glue {


#undef  FUNCTION
#define FUNCTION "Execute_loop_Glue::Execute_loop_Glue"
  Execute_loop_Glue::Execute_loop_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::execute_loop_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Execute_loop_Glue,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Execute_loop_Glue == true
//     log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    

	log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Method - genMealy_gpr_write"),_name.c_str());

	SC_METHOD (genMealy_gpr_write);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't internal register
	sensitive << (*(in_NRESET));

    for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
      {
	sensitive <<(*(in_GPR_WRITE_WRITE_UNIT_VAL           [i]))
		  <<(*(in_GPR_WRITE_WRITE_UNIT_NUM_REG       [i]))
		  <<(*(in_GPR_WRITE_WRITE_UNIT_DATA          [i]))
		  <<(*(in_GPR_WRITE_REGISTER_FILE_ACK        [i]));
	if (_param->_have_port_ooo_engine_id)
	sensitive <<(*(in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID [i]));
      }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
    for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
      {
	(*(out_GPR_WRITE_WRITE_UNIT_ACK               [i])) (*( in_GPR_WRITE_REGISTER_FILE_ACK         [i]));
	(*(out_GPR_WRITE_REGISTER_FILE_VAL            [i])) (*( in_GPR_WRITE_WRITE_UNIT_VAL            [i]));
	if (_param->_have_port_ooo_engine_id)
	(*(out_GPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  [i])) (*( in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID  [i]));
	(*(out_GPR_WRITE_REGISTER_FILE_NUM_REG        [i])) (*( in_GPR_WRITE_WRITE_UNIT_NUM_REG        [i]));
	(*(out_GPR_WRITE_REGISTER_FILE_DATA           [i])) (*( in_GPR_WRITE_WRITE_UNIT_DATA           [i]));
	(*(out_GPR_WRITE_READ_UNIT_VAL                [i])) (*( in_GPR_WRITE_WRITE_UNIT_VAL            [i]));
	(*(out_GPR_WRITE_READ_UNIT_VAL                [i])) (*( in_GPR_WRITE_REGISTER_FILE_ACK         [i]));
	if (_param->_have_port_ooo_engine_id)
	(*(out_GPR_WRITE_READ_UNIT_OOO_ENGINE_ID      [i])) (*( in_GPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID  [i]));
	(*(out_GPR_WRITE_READ_UNIT_NUM_REG            [i])) (*( in_GPR_WRITE_WRITE_UNIT_NUM_REG        [i]));
	(*(out_GPR_WRITE_READ_UNIT_DATA               [i])) (*( in_GPR_WRITE_WRITE_UNIT_DATA           [i]));
      }
# endif    

	log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Method - genMealy_spr_write"),_name.c_str());

	SC_METHOD (genMealy_spr_write);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't internal register
	sensitive << (*(in_NRESET));

    for (uint32_t i=0; i<_param->_nb_spr_write; i++)
      {
	sensitive <<(*(in_SPR_WRITE_WRITE_UNIT_VAL           [i]))
		  <<(*(in_SPR_WRITE_WRITE_UNIT_NUM_REG       [i]))
		  <<(*(in_SPR_WRITE_WRITE_UNIT_DATA          [i]))
		  <<(*(in_SPR_WRITE_REGISTER_FILE_ACK        [i]));
	if (_param->_have_port_ooo_engine_id)
	sensitive <<(*(in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID [i]));
      }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
    for (uint32_t i=0; i<_param->_nb_spr_write; i++)
      {
	(*(out_SPR_WRITE_WRITE_UNIT_ACK               [i])) (*( in_SPR_WRITE_REGISTER_FILE_ACK         [i]));
	(*(out_SPR_WRITE_REGISTER_FILE_VAL            [i])) (*( in_SPR_WRITE_WRITE_UNIT_VAL            [i]));
	if (_param->_have_port_ooo_engine_id)
	(*(out_SPR_WRITE_REGISTER_FILE_OOO_ENGINE_ID  [i])) (*( in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID  [i]));
	(*(out_SPR_WRITE_REGISTER_FILE_NUM_REG        [i])) (*( in_SPR_WRITE_WRITE_UNIT_NUM_REG        [i]));
	(*(out_SPR_WRITE_REGISTER_FILE_DATA           [i])) (*( in_SPR_WRITE_WRITE_UNIT_DATA           [i]));
	(*(out_SPR_WRITE_READ_UNIT_VAL                [i])) (*( in_SPR_WRITE_WRITE_UNIT_VAL            [i]));
	(*(out_SPR_WRITE_READ_UNIT_VAL                [i])) (*( in_SPR_WRITE_REGISTER_FILE_ACK         [i]));
	if (_param->_have_port_ooo_engine_id)
	(*(out_SPR_WRITE_READ_UNIT_OOO_ENGINE_ID      [i])) (*( in_SPR_WRITE_WRITE_UNIT_OOO_ENGINE_ID  [i]));
	(*(out_SPR_WRITE_READ_UNIT_NUM_REG            [i])) (*( in_SPR_WRITE_WRITE_UNIT_NUM_REG        [i]));
	(*(out_SPR_WRITE_READ_UNIT_DATA               [i])) (*( in_SPR_WRITE_WRITE_UNIT_DATA           [i]));
      }
# endif    

	log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Method - genMealy_issue"),_name.c_str());

	SC_METHOD (genMealy_issue);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg();// don't need internal register
	for (uint32_t i=0; i<_param->_nb_inst_issue; ++i)
	  sensitive << (*(in_ISSUE_VAL               [i]))
		    << (*(in_ISSUE_READ_UNIT_ACK     [i]))
		    << (*(in_ISSUE_REGISTER_UNIT_ACK [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Execute_loop_Glue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Execute_loop_Glue::~Execute_loop_Glue"
  Execute_loop_Glue::~Execute_loop_Glue (void)
  {
    log_begin(Execute_loop_Glue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Execute_loop_Glue,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Execute_loop_Glue,FUNCTION);
  };

}; // end namespace execute_loop_glue
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
