#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_read_queue_Types_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_read_queue_Types_h

/*
 * $Id: Types.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {
  
  class Tread_queue_entry_t
  {
  public    : Tcontext_t         _context_id   ;
  public    : Tcontext_t         _front_end_id ;
  public    : Tcontext_t         _ooo_engine_id;
  public    : Tpacket_t          _rob_id       ;
  public    : Toperation_t       _operation    ;
  public    : Ttype_t            _type         ;
  public    : Tcontrol_t         _cancel       ;
  public    : Tlsq_ptr_t         _store_queue_ptr_write;
  public    : Tlsq_ptr_t         _store_queue_ptr_read ;
  public    : Tcontrol_t         _store_queue_empty    ;
  public    : Tlsq_ptr_t         _load_queue_ptr_write;
  public    : Tcontrol_t         _has_immediat ;
  public    : Tgeneral_data_t    _immediat     ;
  public    : Tcontrol_t         _read_ra      ;
  public    : Tgeneral_address_t _num_reg_ra   ;
  public    : Tcontrol_t         _read_rb      ;
  public    : Tgeneral_address_t _num_reg_rb   ;
  public    : Tcontrol_t         _read_rc      ;
  public    : Tspecial_address_t _num_reg_rc   ;
  public    : Tcontrol_t         _write_rd     ;
  public    : Tgeneral_address_t _num_reg_rd   ;
  public    : Tcontrol_t         _write_re     ;
  public    : Tspecial_address_t _num_reg_re   ;

    friend std::ostream& operator<< (std::ostream& output_stream,
				morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue::Tread_queue_entry_t & x)
    {
      output_stream << " * _context_id            : " << toString(x._context_id   ) << std::endl
		    << " * _front_end_id          : " << toString(x._front_end_id ) << std::endl
		    << " * _ooo_engine_id         : " << toString(x._ooo_engine_id) << std::endl
		    << " * _rob_id                : " << toString(x._rob_id       ) << std::endl
		    << " * _operation             : " << toString(x._operation    ) << std::endl
		    << " * _type                  : " << toString(x._type         ) << std::endl
		    << " * _cancel                : " << toString(x._cancel       ) << std::endl
		    << " * _store_queue_ptr_write : " << toString(x._store_queue_ptr_write) << std::endl
		    << " * _store_queue_ptr_read  : " << toString(x._store_queue_ptr_read ) << std::endl
		    << " * _store_queue_empty     : " << toString(x._store_queue_empty    ) << std::endl
		    << " * _load_queue_ptr_write  : " << toString(x._load_queue_ptr_write ) << std::endl
		    << " * _has_immediat          : " << toString(x._has_immediat ) << std::endl
		    << " * _immediat              : " << toString(x._immediat     ) << std::endl
		    << " * _read_ra               : " << toString(x._read_ra      ) << std::endl
		    << " * _num_reg_ra            : " << toString(x._num_reg_ra   ) << std::endl
		    << " * _read_rb               : " << toString(x._read_rb      ) << std::endl
		    << " * _num_reg_rb            : " << toString(x._num_reg_rb   ) << std::endl
		    << " * _read_rc               : " << toString(x._read_rc      ) << std::endl
		    << " * _num_reg_rc            : " << toString(x._num_reg_rc   ) << std::endl
		    << " * _write_rd              : " << toString(x._write_rd     ) << std::endl
		    << " * _num_reg_rd            : " << toString(x._num_reg_rd   ) << std::endl
		    << " * _write_re              : " << toString(x._write_re     ) << std::endl
		    << " * _num_reg_re            : " << toString(x._num_reg_re   ) << std::endl;

      return output_stream;
    }

  };

  class Tread_queue_head_entry_t
  {
  public    : Tcontext_t         _context_id   ;
  public    : Tcontext_t         _front_end_id ;
  public    : Tcontext_t         _ooo_engine_id;
  public    : Tpacket_t          _rob_id       ;
  public    : Toperation_t       _operation    ;
  public    : Ttype_t            _type         ;
  public    : Tcontrol_t         _cancel       ;
  public    : Tlsq_ptr_t         _store_queue_ptr_write;
  public    : Tlsq_ptr_t         _store_queue_ptr_read ;
  public    : Tcontrol_t         _store_queue_empty    ;
  public    : Tlsq_ptr_t         _load_queue_ptr_write;
  public    : Tcontrol_t         _has_immediat ;
  public    : Tgeneral_data_t    _immediat     ;
  public    : Tcontrol_t         _read_ra      ;
  public    : Tcontrol_t         _read_ra_val  ; // 1 : must access at the registerFile (after access, is set at 0)
  public    : Tgeneral_address_t _num_reg_ra   ;
  public    : Tcontrol_t         _data_ra_val  ; // 1 : the read of registerFile is valid
  public    : Tgeneral_data_t    _data_ra      ;
  public    : Tcontrol_t         _read_rb      ;
  public    : Tcontrol_t         _read_rb_val  ;
  public    : Tgeneral_address_t _num_reg_rb   ;
  public    : Tcontrol_t         _data_rb_val  ;
  public    : Tgeneral_data_t    _data_rb      ;
  public    : Tcontrol_t         _read_rc      ;
  public    : Tcontrol_t         _read_rc_val  ;
  public    : Tspecial_address_t _num_reg_rc   ;
  public    : Tcontrol_t         _data_rc_val  ;
  public    : Tspecial_data_t    _data_rc      ;
  public    : Tcontrol_t         _write_rd     ;
  public    : Tgeneral_address_t _num_reg_rd   ;
  public    : Tcontrol_t         _write_re     ;
  public    : Tspecial_address_t _num_reg_re   ;

#undef  FUNCTION 
#define FUNCTION "Tread_queue_head_entry_t::operator="
  public    : Tread_queue_head_entry_t& operator=(Tread_queue_entry_t x)
    {
      log_printf(FUNC,Read_queue,FUNCTION,"Begin");
	  
      _context_id            = x._context_id   ;
      _front_end_id          = x._front_end_id ;
      _ooo_engine_id         = x._ooo_engine_id;
      _rob_id                = x._rob_id       ;
      _operation             = x._operation    ;
      _type                  = x._type         ;
      _cancel                = x._cancel       ;
      _store_queue_ptr_write = x._store_queue_ptr_write;
      _store_queue_ptr_read  = x._store_queue_ptr_read ;
      _store_queue_empty     = x._store_queue_empty    ;
      _load_queue_ptr_write  = x._load_queue_ptr_write ;
      _has_immediat          = x._has_immediat ;
      _immediat              = x._immediat     ;
      _read_ra               = x._read_ra      ;
      _read_ra_val           = ((x._read_ra == 1) and (x._num_reg_ra != 0)); //if not must read, the registerFile is already access
      _num_reg_ra            = x._num_reg_ra   ;
//    _data_ra_val           = ((x._read_ra == 0) or  (x._num_reg_ra == 0)); //if not must read, the data is already valid
      _data_ra_val           = not _read_ra_val;
      _data_ra               = 0               ;
      _read_rb               = x._read_rb      ;
      _read_rb_val           = ((x._read_rb == 1) and (x._num_reg_rb != 0));
      _num_reg_rb            = x._num_reg_rb   ;
//    _data_rb_val           = ((x._read_rb == 0) or  (x._num_reg_rb == 0));
      _data_rb_val           = not _read_rb_val;
      _data_rb               = 0               ;
      _read_rc               = x._read_rc      ;
      _read_rc_val           = x._read_rc == 1 ;
      _num_reg_rc            = x._num_reg_rc   ;
      _data_rc_val           = x._read_rc == 0 ;
      _data_rc               = 0               ;
      _write_rd              = x._write_rd     ;
      _num_reg_rd            = x._num_reg_rd   ;
      _write_re              = x._write_re     ;
      _num_reg_re            = x._num_reg_re   ;

      log_printf(FUNC,Read_queue,FUNCTION,"End");

      return *this;
    }

    friend std::ostream& operator<< (std::ostream& output_stream,
				morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue::Tread_queue_head_entry_t & x)
    {
      output_stream << " * _context_id            : " << x._context_id   << std::endl
		    << " * _front_end_id          : " << x._front_end_id << std::endl
		    << " * _ooo_engine_id         : " << x._ooo_engine_id<< std::endl
		    << " * _rob_id                : " << x._rob_id       << std::endl
		    << " * _operation             : " << x._operation    << std::endl
		    << " * _type                  : " << x._type         << std::endl
		    << " * _cancel                : " << x._cancel       << std::endl
		    << " * _store_queue_ptr_write : " << toString(x._store_queue_ptr_write) << std::endl
		    << " * _store_queue_ptr_read  : " << toString(x._store_queue_ptr_read ) << std::endl
		    << " * _store_queue_empty     : " << toString(x._store_queue_empty    ) << std::endl
		    << " * _load_queue_ptr_write  : " << toString(x._load_queue_ptr_write ) << std::endl
		    << " * _has_immediat          : " << x._has_immediat << std::endl
		    << " * _immediat              : " << x._immediat     << std::endl
		    << " * _read_ra               : " << x._read_ra      << std::endl
		    << " * _read_ra_val           : " << x._read_ra_val  << std::endl 
		    << " * _num_reg_ra            : " << x._num_reg_ra   << std::endl
		    << " * _data_ra_val           : " << x._data_ra_val  << std::endl
		    << " * _data_ra               : " << x._data_ra      << std::endl
		    << " * _read_rb               : " << x._read_rb      << std::endl
		    << " * _read_rb_val           : " << x._read_rb_val  << std::endl
		    << " * _num_reg_rb            : " << x._num_reg_rb   << std::endl
		    << " * _data_rb_val           : " << x._data_rb_val  << std::endl
		    << " * _data_rb               : " << x._data_rb      << std::endl
		    << " * _read_rc               : " << x._read_rc      << std::endl
		    << " * _read_rc_val           : " << x._read_rc_val  << std::endl
		    << " * _num_reg_rc            : " << x._num_reg_rc   << std::endl
		    << " * _data_rc_val           : " << x._data_rc_val  << std::endl
		    << " * _data_rc               : " << x._data_rc      << std::endl
		    << " * _write_rd              : " << x._write_rd     << std::endl
		    << " * _num_reg_rd            : " << x._num_reg_rd   << std::endl
		    << " * _write_re              : " << x._write_re     << std::endl
		    << " * _num_reg_re            : " << x._num_reg_re   << std::endl;

      return output_stream;
    }
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
