/*
 * $Id: Decod.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::Decod"
  Decod::Decod 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

// #if DEBUG_Decod == true
//     log_printf(INFO,Decod,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Decod,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Decod,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Decod,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Decod,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
	log_printf(INFO,Decod,FUNCTION,"Method - genMealy");

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg() //use internal register
		  << (*(in_NRESET))
		  << (*(in_CONTEXT_EVENT_ACK));
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  {
	    for (uint32_t j=0; j<_param->_nb_inst_fetch [i]; j++)
	      {
		sensitive << (*(in_IFETCH_VAL                         [i][j]))
			  << (*(in_IFETCH_INSTRUCTION                 [i][j]))
			  << (*(in_IFETCH_ADDRESS                     [i][j]))
// 	                  << (*(in_IFETCH_ADDRESS_NEXT                [i][j]))
			  << (*(in_IFETCH_BRANCH_STATE                [i][j]))
			  << (*(in_IFETCH_EXCEPTION                   [i][j]));

		if (_param->_have_port_context_id)
		sensitive << (*(in_IFETCH_CONTEXT_ID                  [i][j]));
		if (_param->_have_port_depth)
		sensitive << (*(in_IFETCH_BRANCH_UPDATE_PREDICTION_ID [i][j]));
// 		if (_param->_have_port_inst_ifetch_ptr)
// 		sensitive << (*(in_IFETCH_INST_IFETCH_PTR             [i][j]));
	      }
	    sensitive << (*(in_CONTEXT_DECOD_ENABLE               [i]))
		      << (*(in_CONTEXT_DEPTH_VAL                  [i]));
	    if (_param->_have_port_depth)
	    sensitive << (*(in_CONTEXT_DEPTH                      [i]));
	  }

	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  sensitive << (*(in_DECOD_ACK            [i]))
		    << (*(in_PREDICT_ACK          [i]))
 		    << (*(in_PREDICT_CAN_CONTINUE [i]))
	    ;

# ifdef SYSTEMCASS_SPECIFIC
        /*
	// List dependency information

	for (uint32_t i=0; i<_param->_nb_context; i++)
	  {
	    for (uint32_t j=0; j<_param->_nb_inst_fetch [i]; j++)
	      {
		(*(out_IFETCH_ACK [i][j])) (*(in_IFETCH_VAL           [i][j]));
		(*(out_IFETCH_ACK [i][j])) (*(in_IFETCH_INSTRUCTION   [i][j]));
		if (_param->_have_port_context_id)
		(*(out_IFETCH_ACK [i][j])) (*(in_IFETCH_CONTEXT_ID    [i]   ));
		(*(out_IFETCH_ACK [i][j])) (*(in_CONTEXT_DECOD_ENABLE [i]   ));
		(*(out_IFETCH_ACK [i][j])) (*(in_CONTEXT_EVENT_ACK          ));
		for (uint32_t x=0; x<_param->_nb_inst_decod; x++)
		  {
		    (*(out_IFETCH_ACK [i][j])) (*(in_DECOD_ACK   [x]));
		    (*(out_IFETCH_ACK [i][j])) (*(in_PREDICT_ACK [x]));
// 		    (*(out_IFETCH_ACK [i][j])) (*(in_PREDICT_CAN_CONTINUE [x]));
		  }
	      }
	  }

	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {

	    (*(out_DECOD_VAL [i])) (*(in_PREDICT_ACK          [i]));
// 	    (*(out_DECOD_VAL [i])) (*(in_PREDICT_CAN_CONTINUE [i]));
	    (*(out_DECOD_VAL [i])) (*(in_CONTEXT_EVENT_ACK    ));
	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_VAL [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_VAL [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_VAL [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_VAL [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    if (_param->_have_port_context_id)
	      {
	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_CONTEXT_ID [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		(*(out_DECOD_CONTEXT_ID [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_CONTEXT_ID [i])) (*(in_IFETCH_VAL [x][y]));
		  }
	      }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
	    if (_param->_have_port_depth[i])
	      {

		(*(out_DECOD_DEPTH [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		(*(out_DECOD_DEPTH [i])) (*(in_CONTEXT_DEPTH        [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_DEPTH [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_DEPTH [i])) (*(in_IFETCH_VAL [x][y]));
		  }
	      }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_TYPE [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_TYPE [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_TYPE [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_TYPE [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_OPERATION [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_OPERATION [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_OPERATION [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_OPERATION [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_IS_DELAY_SLOT [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_IS_DELAY_SLOT [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_IS_DELAY_SLOT [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_IS_DELAY_SLOT [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_HAS_IMMEDIAT [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_HAS_IMMEDIAT [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_HAS_IMMEDIAT [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_HAS_IMMEDIAT [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_READ_RA [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_READ_RA [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_READ_RA [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_READ_RA [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }
	    
	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_NUM_REG_RA [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_NUM_REG_RA [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_NUM_REG_RA [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_NUM_REG_RA [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_READ_RB [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_READ_RB [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_READ_RB [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_READ_RB [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_NUM_REG_RB [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_NUM_REG_RB [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_NUM_REG_RB [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_NUM_REG_RB [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_READ_RC [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_READ_RC [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_READ_RC [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_READ_RC [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_NUM_REG_RC [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_NUM_REG_RC [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_NUM_REG_RC [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_NUM_REG_RC [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_WRITE_RD [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_WRITE_RD [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_WRITE_RD [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_WRITE_RD [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_NUM_REG_RD [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_NUM_REG_RD [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_NUM_REG_RD [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_NUM_REG_RD [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_WRITE_RE [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_WRITE_RE [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_WRITE_RE [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_WRITE_RE [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_NUM_REG_RE [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_NUM_REG_RE [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_NUM_REG_RE [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_NUM_REG_RE [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_EXCEPTION_USE [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_EXCEPTION_USE [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_EXCEPTION_USE [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_EXCEPTION_USE [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_ADDRESS [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_ADDRESS [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		(*(out_DECOD_ADDRESS [i])) (*(in_IFETCH_ADDRESS       [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_ADDRESS [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_ADDRESS [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_DECOD_IMMEDIAT [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_DECOD_IMMEDIAT [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
// 		(*(out_DECOD_IMMEDIAT [i])) (*(in_IFETCH_ADDRESS_NEXT  [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_DECOD_IMMEDIAT [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_DECOD_IMMEDIAT [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    if (_param->_have_port_context_id)
	      {
	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_CONTEXT_ID [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		(*(out_PREDICT_CONTEXT_ID [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_CONTEXT_ID [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_CONTEXT_ID [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_MATCH_INST_IFETCH_PTR [i])) (*(in_CONTEXT_DECOD_ENABLE   [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_MATCH_INST_IFETCH_PTR [i])) (*(in_IFETCH_CONTEXT_ID      [x]));
		if (_param->_have_port_inst_ifetch_ptr[i])
		(*(out_PREDICT_MATCH_INST_IFETCH_PTR [i])) (*(in_IFETCH_INST_IFETCH_PTR [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_MATCH_INST_IFETCH_PTR [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_MATCH_INST_IFETCH_PTR [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_BRANCH_STATE [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_BRANCH_STATE [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		(*(out_PREDICT_BRANCH_STATE [i])) (*(in_IFETCH_BRANCH_STATE  [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_BRANCH_STATE [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_BRANCH_STATE [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    if (_param->_have_port_branch_update_prediction_id)
	      {
	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i])) (*(in_CONTEXT_DECOD_ENABLE                [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i])) (*(in_IFETCH_CONTEXT_ID                   [x]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i])) (*(in_IFETCH_BRANCH_UPDATE_PREDICTION_ID  [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_BRANCH_CONDITION [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_BRANCH_CONDITION [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_BRANCH_CONDITION [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_BRANCH_CONDITION [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

// 	    for (uint32_t x=0; x<_param->_nb_context; x++)
// 	      {
// 		(*(out_PREDICT_BRANCH_STACK_WRITE [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
// 		if (_param->_have_port_context_id)
// 		(*(out_PREDICT_BRANCH_STACK_WRITE [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
// 		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
// 		  {
// 		    (*(out_PREDICT_BRANCH_STACK_WRITE [i])) (*(in_IFETCH_VAL         [x][y]));
// 		    (*(out_PREDICT_BRANCH_STACK_WRITE [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
// 		  }
// 	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_BRANCH_DIRECTION [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_BRANCH_DIRECTION [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_BRANCH_DIRECTION [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_BRANCH_DIRECTION [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }

	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_ADDRESS_DEST [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_ADDRESS_DEST [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		(*(out_PREDICT_ADDRESS_DEST [i])) (*(in_IFETCH_ADDRESS       [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_ADDRESS_DEST [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_ADDRESS_DEST [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }

		(*(out_PREDICT_ADDRESS_SRC [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_ADDRESS_SRC [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		(*(out_PREDICT_ADDRESS_SRC [i])) (*(in_IFETCH_ADDRESS       [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_ADDRESS_SRC [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_ADDRESS_SRC [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }

	      }


	    (*(out_PREDICT_VAL [i])) (*(in_CONTEXT_EVENT_ACK));
	    (*(out_PREDICT_VAL [i])) (*(in_DECOD_ACK [i]));
	    for (uint32_t x=0; x<_param->_nb_context; x++)
	      {
		(*(out_PREDICT_VAL [i])) (*(in_CONTEXT_DECOD_ENABLE [x]));
		if (_param->_have_port_context_id)
		(*(out_PREDICT_VAL [i])) (*(in_IFETCH_CONTEXT_ID    [x]));
		(*(out_PREDICT_VAL [i])) (*(in_IFETCH_ADDRESS       [x]));
		for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
		  {
		    (*(out_PREDICT_VAL [i])) (*(in_IFETCH_VAL         [x][y]));
		    (*(out_PREDICT_VAL [i])) (*(in_IFETCH_INSTRUCTION [x][y]));
		  }
	      }
	  }

	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    (*(out_CONTEXT_EVENT_VAL)) (*(in_PREDICT_ACK          [i]));
// 	    (*(out_CONTEXT_EVENT_VAL)) (*(in_PREDICT_CAN_CONTINUE [i]));
	    (*(out_CONTEXT_EVENT_VAL)) (*(in_DECOD_ACK   [i]));
	  }
	for (uint32_t x=0; x<_param->_nb_context; x++)
	  {
	    (*(out_CONTEXT_EVENT_VAL)) (*(in_CONTEXT_DECOD_ENABLE [x]));
	    if (_param->_have_port_context_id)
	    (*(out_CONTEXT_EVENT_VAL)) (*(in_IFETCH_CONTEXT_ID    [x]));
	    (*(out_CONTEXT_EVENT_VAL)) (*(in_IFETCH_ADDRESS       [x]));
	    for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
	      {
		(*(out_CONTEXT_EVENT_VAL)) (*(in_IFETCH_VAL         [x][y]));
		(*(out_CONTEXT_EVENT_VAL)) (*(in_IFETCH_INSTRUCTION [x][y]));
	      }
	  }

	if (_param->_have_port_context_id)
	  {
	for (uint32_t x=0; x<_param->_nb_context; x++)
	  {
	    (*(out_CONTEXT_EVENT_CONTEXT_ID)) (*(in_CONTEXT_DECOD_ENABLE [x]));
	    (*(out_CONTEXT_EVENT_CONTEXT_ID)) (*(in_IFETCH_CONTEXT_ID    [x]));
	    for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
	      {
		(*(out_CONTEXT_EVENT_CONTEXT_ID)) (*(in_IFETCH_VAL         [x][y]));
		(*(out_CONTEXT_EVENT_CONTEXT_ID)) (*(in_IFETCH_INSTRUCTION [x][y]));
	      }
	  }
	  }

	for (uint32_t x=0; x<_param->_nb_context; x++)
	  {
	    (*(out_CONTEXT_EVENT_TYPE)) (*(in_CONTEXT_DECOD_ENABLE [x]));
	    if (_param->_have_port_context_id)
	    (*(out_CONTEXT_EVENT_TYPE)) (*(in_IFETCH_CONTEXT_ID    [x]));
	    for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
	      {
		(*(out_CONTEXT_EVENT_TYPE)) (*(in_IFETCH_VAL         [x][y]));
		(*(out_CONTEXT_EVENT_TYPE)) (*(in_IFETCH_INSTRUCTION [x][y]));
	      }
	  }

	for (uint32_t x=0; x<_param->_nb_context; x++)
	  {
	    (*(out_CONTEXT_EVENT_IS_DELAY_SLOT)) (*(in_CONTEXT_DECOD_ENABLE [x]));
	    if (_param->_have_port_context_id)
	    (*(out_CONTEXT_EVENT_IS_DELAY_SLOT)) (*(in_IFETCH_CONTEXT_ID    [x]));
	    for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
	      {
		(*(out_CONTEXT_EVENT_IS_DELAY_SLOT)) (*(in_IFETCH_VAL         [x][y]));
		(*(out_CONTEXT_EVENT_IS_DELAY_SLOT)) (*(in_IFETCH_INSTRUCTION [x][y]));
	      }
	  }

	for (uint32_t x=0; x<_param->_nb_context; x++)
	  {
	    (*(out_CONTEXT_EVENT_ADDRESS)) (*(in_CONTEXT_DECOD_ENABLE [x]));
	    if (_param->_have_port_context_id)
	    (*(out_CONTEXT_EVENT_ADDRESS)) (*(in_IFETCH_CONTEXT_ID    [x]));
	    (*(out_CONTEXT_EVENT_ADDRESS)) (*(in_IFETCH_ADDRESS       [x]));
// 	    (*(out_CONTEXT_EVENT_ADDRESS)) (*(in_IFETCH_ADDRESS_NEXT  [x]));
	    for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
	      {
		(*(out_CONTEXT_EVENT_ADDRESS)) (*(in_IFETCH_VAL         [x][y]));
		(*(out_CONTEXT_EVENT_ADDRESS)) (*(in_IFETCH_INSTRUCTION [x][y]));
	      }
	  }

	for (uint32_t x=0; x<_param->_nb_context; x++)
	  {
	    (*(out_CONTEXT_EVENT_ADDRESS_EPCR)) (*(in_CONTEXT_DECOD_ENABLE [x]));
	    if (_param->_have_port_context_id)
	    (*(out_CONTEXT_EVENT_ADDRESS_EPCR)) (*(in_IFETCH_CONTEXT_ID    [x]));
	    (*(out_CONTEXT_EVENT_ADDRESS_EPCR)) (*(in_IFETCH_ADDRESS       [x]));
// 	    (*(out_CONTEXT_EVENT_ADDRESS_EPCR)) (*(in_IFETCH_ADDRESS_NEXT  [x]));
	    for (uint32_t y=0; y<_param->_nb_inst_fetch [x]; y++)
	      {
		(*(out_CONTEXT_EVENT_ADDRESS_EPCR)) (*(in_IFETCH_VAL         [x][y]));
		(*(out_CONTEXT_EVENT_ADDRESS_EPCR)) (*(in_IFETCH_INSTRUCTION [x][y]));
	      }
	  }
        */
# endif    
	
      }
#endif

    log_printf(FUNC,Decod,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Decod::~Decod"
  Decod::~Decod (void)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Decod,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
