#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_write_queue_Types_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_write_queue_Types_h

/*
 * $Id: Types.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {

  typedef enum 
    {
       WRITE_QUEUE_SCHEME_MOORE // Write register and pop is not in same cycle
      ,WRITE_QUEUE_SCHEME_MEALY // Write register and pop can be in same cycle
    } Twrite_queue_scheme_t;

  typedef enum
    {
      BYPASS_WRITE_FROM_ALU,
      BYPASS_WRITE_FROM_QUEUE
    } Tbypass_write_scheme_t;

  class write_queue_entry_t
  {
  public  : Tcontext_t         _context_id   ;
  public  : Tcontext_t         _front_end_id ;
  public  : Tcontext_t         _ooo_engine_id;
  public  : Tpacket_t          _packet_id    ;
//public  : Toperation_t       _operation    ;
//public  : Ttype_t            _type         ;
  public  : Tcontrol_t         _cancel       ;
  public  : Tcontrol_t         _write_rd     ;
  public  : Tgeneral_address_t _num_reg_rd   ;
  public  : Tgeneral_data_t    _data_rd      ;
  public  : Tcontrol_t         _write_re     ;
  public  : Tspecial_address_t _num_reg_re   ;
  public  : Tspecial_data_t    _data_re      ;
  public  : Texception_t       _exception    ;
  public  : Tcontrol_t         _no_sequence  ;
  public  : Tgeneral_data_t    _address      ;
    
  public  : write_queue_entry_t (Tcontext_t         context_id   ,
				 Tcontext_t         front_end_id ,
				 Tcontext_t         ooo_engine_id,
				 Tpacket_t          packet_id    ,
// 			         Toperation_t       operation    ,
// 				 Ttype_t            type         ,
				 Tcontrol_t         cancel       ,
				 Tcontrol_t         write_rd     ,
				 Tgeneral_address_t num_reg_rd   ,
				 Tgeneral_data_t    data_rd      ,
				 Tcontrol_t         write_re     ,
				 Tspecial_address_t num_reg_re   ,
				 Tspecial_data_t    data_re      ,
				 Texception_t       exception    ,
				 Tcontrol_t         no_sequence  ,
				 Tgeneral_data_t    address      )
    {
      _context_id    = context_id   ;
      _front_end_id  = front_end_id ;
      _ooo_engine_id = ooo_engine_id;
      _packet_id     = packet_id    ;
    //_operation     = operation    ;
    //_type          = type         ;
      _cancel        = cancel       ;
      _write_rd      = write_rd     ;
      _num_reg_rd    = num_reg_rd   ;
      _data_rd       = data_rd      ;
      _write_re      = write_re     ;
      _num_reg_re    = num_reg_re   ;
      _data_re       = data_re      ;
      _exception     = exception    ;
      _no_sequence   = no_sequence  ;
      _address       = address      ;
    };
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t>(const morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::WRITE_QUEUE_SCHEME_MOORE : return "moore"; break;
      case morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::WRITE_QUEUE_SCHEME_MEALY : return "mealy"; break;
      default : return ""; break;
      }
  };

  template<> inline morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t fromString<morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t>(const std::string& x)
  {
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::WRITE_QUEUE_SCHEME_MOORE))) == 0) or
         (x.compare("moore") == 0))
      return morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::WRITE_QUEUE_SCHEME_MOORE;
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::WRITE_QUEUE_SCHEME_MEALY))) == 0) or
         (x.compare("mealy") == 0))
      return morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::WRITE_QUEUE_SCHEME_MEALY;
    
    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };

  template<> inline std::string toString<morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Tbypass_write_scheme_t>(const morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Tbypass_write_scheme_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::BYPASS_WRITE_FROM_ALU   : return "alu"  ; break;
      case morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::BYPASS_WRITE_FROM_QUEUE : return "queue"; break;
      default : return ""; break;
      }
  };

  template<> inline morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Tbypass_write_scheme_t fromString<morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Tbypass_write_scheme_t>(const std::string& x)
  {
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::BYPASS_WRITE_FROM_ALU))) == 0) or
         (x.compare("alu") == 0))
      return morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::BYPASS_WRITE_FROM_ALU;
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::BYPASS_WRITE_FROM_QUEUE))) == 0) or
         (x.compare("queue") == 0))
      return morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::BYPASS_WRITE_FROM_QUEUE;
    
    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };

}; // end namespace morpheo              

#endif
