/*
 * $Id: Write_unit_deallocation.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/include/Write_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {


#undef  FUNCTION
#define FUNCTION "Write_unit::deallocation"
  void Write_unit::deallocation (void)
  {
    log_printf(FUNC,Write_unit,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE0_SIGNAL( in_WRITE_UNIT_IN_VAL          ,1);
        DELETE0_SIGNAL(out_WRITE_UNIT_IN_ACK          ,1);
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_CONTEXT_ID   ,_param->_size_context_id       );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_FRONT_END_ID ,_param->_size_front_end_id     );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_OOO_ENGINE_ID,_param->_size_ooo_engine_id    );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_PACKET_ID    ,_param->_size_rob_ptr          );
//      DELETE0_SIGNAL( in_WRITE_UNIT_IN_OPERATION    ,_param->_size_operation        );
//      DELETE0_SIGNAL( in_WRITE_UNIT_IN_TYPE         ,_param->_size_type             );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_CANCEL       ,1                              );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_WRITE_RD     ,1                              );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_NUM_REG_RD   ,_param->_size_general_register );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_DATA_RD      ,_param->_size_general_data     );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_WRITE_RE     ,1                              );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_NUM_REG_RE   ,_param->_size_special_register );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_DATA_RE      ,_param->_size_special_data     );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_EXCEPTION    ,_param->_size_exception        );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_NO_SEQUENCE  ,1                              );
        DELETE0_SIGNAL( in_WRITE_UNIT_IN_ADDRESS      ,_param->_size_instruction_address);
        
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_VAL          ,1);
        DELETE0_SIGNAL( in_WRITE_UNIT_OUT_ACK          ,1);
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_CONTEXT_ID   ,_param->_size_context_id   );
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_FRONT_END_ID ,_param->_size_front_end_id );
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_OOO_ENGINE_ID,_param->_size_ooo_engine_id);
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_PACKET_ID    ,_param->_size_rob_ptr      );
//      DELETE0_SIGNAL(out_WRITE_UNIT_OUT_OPERATION    ,_param->_size_operation    );
//      DELETE0_SIGNAL(out_WRITE_UNIT_OUT_TYPE         ,_param->_size_type         );
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_CANCEL       ,1                          );
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_FLAGS        ,_param->_size_special_data );
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_EXCEPTION    ,_param->_size_exception    );
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_NO_SEQUENCE  ,1                          );
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_ADDRESS      ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_WRITE_UNIT_OUT_DATA         ,_param->_size_general_data );
        
        DELETE1_SIGNAL(out_GPR_WRITE_VAL          , _param->_nb_gpr_write,1);
        DELETE1_SIGNAL( in_GPR_WRITE_ACK          , _param->_nb_gpr_write,1);
        DELETE1_SIGNAL(out_GPR_WRITE_OOO_ENGINE_ID, _param->_nb_gpr_write,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL(out_GPR_WRITE_NUM_REG      , _param->_nb_gpr_write,_param->_size_general_register);
        DELETE1_SIGNAL(out_GPR_WRITE_DATA         , _param->_nb_gpr_write,_param->_size_general_data    );
        
        DELETE1_SIGNAL(out_SPR_WRITE_VAL          , _param->_nb_spr_write,1);
        DELETE1_SIGNAL( in_SPR_WRITE_ACK          , _param->_nb_spr_write,1);
        DELETE1_SIGNAL(out_SPR_WRITE_OOO_ENGINE_ID, _param->_nb_spr_write,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL(out_SPR_WRITE_NUM_REG      , _param->_nb_spr_write,_param->_size_special_register);
        DELETE1_SIGNAL(out_SPR_WRITE_DATA         , _param->_nb_spr_write,_param->_size_special_data    );
        
        DELETE1_SIGNAL(out_BYPASS_WRITE_OOO_ENGINE_ID, _param->_nb_bypass_write,_param->_size_ooo_engine_id   );
        DELETE1_SIGNAL(out_BYPASS_WRITE_GPR_VAL      , _param->_nb_bypass_write,1                             );
        DELETE1_SIGNAL(out_BYPASS_WRITE_GPR_NUM_REG  , _param->_nb_bypass_write,_param->_size_general_register);
        DELETE1_SIGNAL(out_BYPASS_WRITE_GPR_DATA     , _param->_nb_bypass_write,_param->_size_general_data    );
        DELETE1_SIGNAL(out_BYPASS_WRITE_SPR_VAL      , _param->_nb_bypass_write,1                             );
        DELETE1_SIGNAL(out_BYPASS_WRITE_SPR_NUM_REG  , _param->_nb_bypass_write,_param->_size_special_register);
        DELETE1_SIGNAL(out_BYPASS_WRITE_SPR_DATA     , _param->_nb_bypass_write,_param->_size_special_data    );
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete component_write_queue;
    if (_param->_have_component_execute_queue)
      delete component_execute_queue;

    delete _component;

    log_printf(FUNC,Write_unit,FUNCTION,"End");
  };

}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
