#ifdef SYSTEMC
/*
 * $Id: Ifetch_queue_function_no_assoc_genMoore.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {

#undef  FUNCTION
#define FUNCTION "Ifetch_queue::function_no_assoc_genMoore"
  void Ifetch_queue::function_no_assoc_genMoore (void)
  {
    log_begin(Ifetch_queue,FUNCTION);
    log_function(Ifetch_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    // ==========================================================
    // =====[ ADDRESS ]==========================================
    // ==========================================================
    {
      internal_ADDRESS_ACK = (_queue[reg_PTR_WRITE]->_state == IFETCH_QUEUE_STATE_EMPTY);
 
      log_printf(TRACE,Ifetch_queue,FUNCTION,"  * ADDRESS_ACK : %d",internal_ADDRESS_ACK);
     
      if (_param->_have_port_ifetch_queue_ptr)
      PORT_WRITE(out_ADDRESS_IFETCH_QUEUE_ID, reg_PTR_WRITE);
    }

    // ==========================================================
    // =====[ DECOD ]============================================
    // ==========================================================
    {
      bool ack = (_queue[reg_PTR_READ]->_state == IFETCH_QUEUE_STATE_HAVE_RSP);

      Tgeneral_address_t address                       = _queue[reg_PTR_READ]->_address;
      Tinst_ifetch_ptr_t inst_ifetch_ptr               = _queue[reg_PTR_READ]->_inst_ifetch_ptr;
      Tbranch_state_t    branch_state                  = _queue[reg_PTR_READ]->_branch_state;
      Tprediction_ptr_t  branch_update_prediction_id   = _queue[reg_PTR_READ]->_branch_update_prediction_id;
      Texception_t       exception                     = _queue[reg_PTR_READ]->_exception;
      
      for (uint32_t i=0; i<_param->_nb_instruction; i++)
        {
          internal_DECOD_VAL [i] = ack and _queue[reg_PTR_READ]->_instruction_enable [i];

          log_printf(TRACE,Ifetch_queue,FUNCTION,"  * DECOD_VAL [%d] : %d",i,internal_DECOD_VAL [i]);

          PORT_WRITE(out_DECOD_INSTRUCTION                [i],_queue[reg_PTR_READ]->_instruction [i]);
	  PORT_WRITE(out_DECOD_ADDRESS                    [i],address+i);
	  if (inst_ifetch_ptr == i)
	    {
	  PORT_WRITE(out_DECOD_BRANCH_STATE               [i],branch_state);
	    }
	  else
	    {
	  PORT_WRITE(out_DECOD_BRANCH_STATE               [i], BRANCH_STATE_NONE);
	    }
	  if (_param->_have_port_depth)
	  PORT_WRITE(out_DECOD_BRANCH_UPDATE_PREDICTION_ID[i],branch_update_prediction_id);
	  PORT_WRITE(out_DECOD_EXCEPTION                  [i],exception); // all is same
        }
      
    }
      }
    else
      {
        // Reset
        internal_ADDRESS_ACK = 0;
        for (uint32_t i=0; i<_param->_nb_instruction; i++)
          internal_DECOD_VAL [i] = 0;
        
      }

    // Write Output
    PORT_WRITE(out_ADDRESS_ACK  , internal_ADDRESS_ACK);
    for (uint32_t i=0; i<_param->_nb_instruction; i++)
    PORT_WRITE(out_DECOD_VAL [i], internal_DECOD_VAL [i]);

    log_end(Ifetch_queue,FUNCTION);
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
