/*
 * $Id: Decod_unit_allocation.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/include/Decod_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {

#undef  FUNCTION
#define FUNCTION "Decod_unit::allocation"
  void Decod_unit::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_begin(Decod_unit,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Decod_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "ifetch" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("ifetch", IN, WEST, _("Instruction's bundle"), _param->_nb_context, _param->_nb_inst_fetch[it1]);
      
      _ALLOC2_VALACK_IN ( in_IFETCH_VAL                       ,VAL, _param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_VALACK_OUT(out_IFETCH_ACK                       ,ACK, _param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_SIGNAL_IN ( in_IFETCH_INSTRUCTION               ,"instruction"                ,Tinstruction_t     ,_param->_size_instruction        ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_SIGNAL_IN (in_IFETCH_CONTEXT_ID                 ,"context_id"                 ,Tcontext_t         ,_param->_size_context_id         ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_SIGNAL_IN (in_IFETCH_ADDRESS                    ,"address"                    ,Tgeneral_address_t ,_param->_size_instruction_address,_param->_nb_context, _param->_nb_inst_fetch[it1]);
//    _ALLOC2_SIGNAL_IN (in_IFETCH_ADDRESS_NEXT               ,"address_next"               ,Tgeneral_address_t ,_param->_size_instruction_address,_param->_nb_context, _param->_nb_inst_fetch[it1]);
//    _ALLOC2_SIGNAL_IN (in_IFETCH_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t ,_param->_size_inst_ifetch_ptr    ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_SIGNAL_IN (in_IFETCH_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state       ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_SIGNAL_IN (in_IFETCH_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth              ,_param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_SIGNAL_IN (in_IFETCH_EXCEPTION                  ,"exception"                  ,Texception_t       ,_param->_size_exception_ifetch   ,_param->_nb_context, _param->_nb_inst_fetch[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_context, _param->_nb_inst_fetch[it1]);
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	     
    {
      ALLOC1_INTERFACE_BEGIN("decod", OUT, EAST, _("Instruction decoded"), _param->_nb_inst_decod);

      ALLOC1_VALACK_OUT(out_DECOD_VAL          ,VAL);
      ALLOC1_VALACK_IN ( in_DECOD_ACK          ,ACK);
      ALLOC1_SIGNAL_OUT(out_DECOD_CONTEXT_ID   ,"context_id"   ,Tcontext_t        ,_param->_size_context_id            );
      ALLOC1_SIGNAL_OUT(out_DECOD_DEPTH        ,"depth"        ,Tdepth_t          ,_param->_size_depth                 );
      ALLOC1_SIGNAL_OUT(out_DECOD_TYPE         ,"type"         ,Ttype_t           ,_param->_size_type                  );
      ALLOC1_SIGNAL_OUT(out_DECOD_OPERATION    ,"operation"    ,Toperation_t      ,_param->_size_operation             );
      ALLOC1_SIGNAL_OUT(out_DECOD_NO_EXECUTE   ,"no_execute"   ,Tcontrol_t        ,1                                   );
//    ALLOC1_SIGNAL_OUT(out_DECOD_HAVE_EVENT   ,"have_event"   ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_LAST_EVENT   ,"last_event"   ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_IS_DELAY_SLOT,"is_delay_slot",Tcontrol_t        ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT(out_DECOD_ADDRESS      ,"address"      ,Tgeneral_data_t   ,_param->_size_instruction_address   );
#endif
      ALLOC1_SIGNAL_OUT(out_DECOD_ADDRESS_NEXT ,"address_next" ,Tgeneral_data_t   ,_param->_size_instruction_address   );
      ALLOC1_SIGNAL_OUT(out_DECOD_HAS_IMMEDIAT ,"has_immediat" ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_IMMEDIAT     ,"immediat"     ,Tgeneral_data_t   ,_param->_size_general_data          );
      ALLOC1_SIGNAL_OUT(out_DECOD_READ_RA      ,"read_ra"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RA   ,"num_reg_ra"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_READ_RB      ,"read_rb"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RB   ,"num_reg_rb"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_READ_RC      ,"read_rc"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RC   ,"num_reg_rc"   ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_WRITE_RD     ,"write_rd"     ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RD   ,"num_reg_rd"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_WRITE_RE     ,"write_re"     ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RE   ,"num_reg_re"   ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_EXCEPTION_USE,"exception_use",Texception_t      ,_param->_size_exception_use         );
      ALLOC1_SIGNAL_OUT(out_DECOD_EXCEPTION    ,"exception"    ,Texception_t      ,_param->_size_exception_decod       );
    
      ALLOC1_INTERFACE_END(_param->_nb_inst_decod);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("predict",OUT,NORTH,_("Decod a branch -> inform the branch predictor."),_param->_nb_inst_decod);

      ALLOC1_VALACK_OUT(out_PREDICT_VAL                        ,VAL);
      ALLOC1_VALACK_IN ( in_PREDICT_ACK                        ,ACK);
      ALLOC1_SIGNAL_OUT(out_PREDICT_CONTEXT_ID                 ,"context_id"                 ,Tcontext_t         ,_param->_size_context_id      );
      ALLOC1_SIGNAL_OUT(out_PREDICT_MATCH_INST_IFETCH_PTR      ,"match_inst_ifetch_ptr"      ,Tcontrol_t         ,1                             );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state    );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth           );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_CONDITION           ,"branch_condition"           ,Tbranch_condition_t,_param->_size_branch_condition);
//    ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_STACK_WRITE         ,"branch_stack_write"         ,Tcontrol_t         ,1                             );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_DIRECTION           ,"branch_direction"           ,Tcontrol_t         ,1                             );
      ALLOC1_SIGNAL_OUT(out_PREDICT_ADDRESS_SRC                ,"address_src"                ,Tgeneral_data_t    ,_param->_size_instruction_address    );
      ALLOC1_SIGNAL_OUT(out_PREDICT_ADDRESS_DEST               ,"address_dest"               ,Tgeneral_data_t    ,_param->_size_instruction_address    );
      ALLOC1_SIGNAL_IN ( in_PREDICT_CAN_CONTINUE               ,"can_continue"               ,Tcontrol_t         ,1                             );
    
      ALLOC1_INTERFACE_END(_param->_nb_inst_decod);
    }
    
    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~            
    {
      ALLOC1_INTERFACE_BEGIN("depth",IN ,NORTH,_("Depth"), _param->_nb_context);

      ALLOC1_SIGNAL_IN ( in_DEPTH_MIN      ,"min"      ,Tdepth_t           ,_param->_size_depth);
      ALLOC1_SIGNAL_IN ( in_DEPTH_MAX      ,"max"      ,Tdepth_t           ,_param->_size_depth);
      ALLOC1_SIGNAL_IN ( in_DEPTH_FULL     ,"full"     ,Tcontrol_t         ,1);

      ALLOC1_INTERFACE_END(_param->_nb_context);
    }

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~            
    {
      ALLOC1_INTERFACE_BEGIN("nb_inst",OUT,NORTH,_("Instruction's number"), _param->_nb_context);

      ALLOC1_SIGNAL_OUT(out_NB_INST_DECOD_ALL  ,"decod_all"   ,Tcounter_t         ,_param->_size_nb_inst_decod);

      ALLOC1_INTERFACE_END(_param->_nb_context);
    }
    
    // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("context", IN, NORTH, _("context's information"), _param->_nb_context);

      ALLOC1_SIGNAL_IN (in_CONTEXT_DECOD_ENABLE,"decod_enable",Tcontrol_t,1);
      ALLOC1_SIGNAL_IN (in_CONTEXT_EVENT       ,"event"       ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN (in_CONTEXT_DEPTH_VAL   ,"depth_val"   ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN (in_CONTEXT_DEPTH       ,"depth"       ,Tdepth_t  ,_param->_size_depth);

      ALLOC1_INTERFACE_END(_param->_nb_context);
    }

    // ~~~~~[ Interface : "context_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	     
    {
      ALLOC0_INTERFACE_BEGIN("context_event", OUT, NORTH, _("context's evenement"));

      ALLOC0_VALACK_OUT(out_CONTEXT_EVENT_VAL          ,VAL);
      ALLOC0_VALACK_IN ( in_CONTEXT_EVENT_ACK          ,ACK);
      ALLOC0_SIGNAL_OUT(out_CONTEXT_EVENT_CONTEXT_ID   ,"context_id"   ,Tcontext_t     ,_param->_size_context_id  );
      ALLOC0_SIGNAL_OUT(out_CONTEXT_EVENT_DEPTH        ,"depth"        ,Tdepth_t       ,_param->_size_depth       );
      ALLOC0_SIGNAL_OUT(out_CONTEXT_EVENT_TYPE         ,"type"         ,Tevent_type_t  ,_param->_size_event_type  );
      ALLOC0_SIGNAL_OUT(out_CONTEXT_EVENT_IS_DELAY_SLOT,"is_delay_slot",Tcontrol_t     ,1                         );
      ALLOC0_SIGNAL_OUT(out_CONTEXT_EVENT_ADDRESS      ,"address"      ,Tgeneral_data_t,_param->_size_instruction_address);
      ALLOC0_SIGNAL_OUT(out_CONTEXT_EVENT_ADDRESS_EPCR ,"address_epcr" ,Tgeneral_data_t,_param->_size_instruction_address);

      ALLOC0_INTERFACE_END();
    }
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    std::string src,dest;
    
    {
      src = _name+"_decod";
      log_printf(INFO,Decod_unit,FUNCTION,_("Create   : %s"),src.c_str());
      
      _component_decod = new morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::Decod
        (src.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_decod
         ,_usage);
      
      _component->set_component (_component_decod->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }
    
    {
      src = _name+"_decod_queue";
      log_printf(INFO,Decod_unit,FUNCTION,_("Create   : %s"),src.c_str());
      
      _component_decod_queue = new morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue
        (src.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_decod_queue
         ,_usage);
      
      _component->set_component (_component_decod_queue->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }
    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ===================================================================
    // =====[ decod ]=====================================================
    // ===================================================================
    {
      src = _name+"_decod";
      log_printf(INFO,Decod_unit,FUNCTION,_("Instance : %s"),src.c_str());
           
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;
	
	  for (uint32_t j=0; j<_param->_nb_inst_fetch [i]; j++)
	    {
#ifdef POSITION
	      _component->interface_map (src ,"ifetch_"+toString(i)+"_"+toString(j),
					 dest,"ifetch_"+toString(i)+"_"+toString(j));
#endif
	      
	      PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_VAL"        ,
		                  dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_VAL"        );
	      PORT_MAP(_component,src ,"out_IFETCH_"+toString(i)+"_"+toString(j)+"_ACK"        ,
		                  dest,"out_IFETCH_"+toString(i)+"_"+toString(j)+"_ACK"        );
	      PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_INSTRUCTION",
		                  dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_INSTRUCTION");
	      if (_param->_have_port_context_id)
              PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"                 ,
	                          dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"                 );
              PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_ADDRESS"                    ,
	      	                  dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_ADDRESS"                    );
//            PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT"               ,
// 	      	                  dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT"               );
//	      if (_param->_have_port_inst_ifetch_ptr)
//            PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_INST_IFETCH_PTR"            ,
//	      	                  dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_INST_IFETCH_PTR"            );
              PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_BRANCH_STATE"               ,
	      	                  dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_BRANCH_STATE"               );
              if (_param->_have_port_depth)
	      PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_BRANCH_UPDATE_PREDICTION_ID",
	        	          dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_BRANCH_UPDATE_PREDICTION_ID");
	      PORT_MAP(_component,src , "in_IFETCH_"+toString(i)+"_"+toString(j)+"_EXCEPTION"                  ,
	        	          dest, "in_IFETCH_"+toString(i)+"_"+toString(j)+"_EXCEPTION"                  );
	    }
  
	}
	
      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  dest = _name+"_decod_queue";

#ifdef POSITION
	  _component->interface_map (src ,"decod_"   +toString(i),
				     dest,"decod_in_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_VAL"          ,
			           dest, "in_DECOD_IN_"+toString(i)+"_VAL"          );
	  COMPONENT_MAP(_component,src , "in_DECOD_"   +toString(i)+"_ACK"          ,
			           dest,"out_DECOD_IN_"+toString(i)+"_ACK"          );
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_CONTEXT_ID"   ,
			           dest, "in_DECOD_IN_"+toString(i)+"_CONTEXT_ID"   );
	  if (_param->_have_port_depth)
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_DEPTH"        ,
			           dest, "in_DECOD_IN_"+toString(i)+"_DEPTH"        );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_TYPE"         ,
			           dest, "in_DECOD_IN_"+toString(i)+"_TYPE"         );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_OPERATION"    ,
			           dest, "in_DECOD_IN_"+toString(i)+"_OPERATION"    );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_NO_EXECUTE"   ,
			           dest, "in_DECOD_IN_"+toString(i)+"_NO_EXECUTE"   );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_IS_DELAY_SLOT",
			           dest, "in_DECOD_IN_"+toString(i)+"_IS_DELAY_SLOT");
#ifdef DEBUG
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_ADDRESS"      ,
			           dest, "in_DECOD_IN_"+toString(i)+"_ADDRESS"      );
#endif
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_ADDRESS_NEXT" ,
			           dest, "in_DECOD_IN_"+toString(i)+"_ADDRESS_NEXT" );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_HAS_IMMEDIAT" ,
			           dest, "in_DECOD_IN_"+toString(i)+"_HAS_IMMEDIAT" );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_IMMEDIAT"     ,
			           dest, "in_DECOD_IN_"+toString(i)+"_IMMEDIAT"     );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_READ_RA"      ,
			           dest, "in_DECOD_IN_"+toString(i)+"_READ_RA"      );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_NUM_REG_RA"   ,
			           dest, "in_DECOD_IN_"+toString(i)+"_NUM_REG_RA"   );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_READ_RB"      ,
			           dest, "in_DECOD_IN_"+toString(i)+"_READ_RB"      );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_NUM_REG_RB"   ,
			           dest, "in_DECOD_IN_"+toString(i)+"_NUM_REG_RB"   );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_READ_RC"      ,
			           dest, "in_DECOD_IN_"+toString(i)+"_READ_RC"      );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_NUM_REG_RC"   ,
			           dest, "in_DECOD_IN_"+toString(i)+"_NUM_REG_RC"   );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_WRITE_RD"     ,
			           dest, "in_DECOD_IN_"+toString(i)+"_WRITE_RD"     );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_NUM_REG_RD"   ,
			           dest, "in_DECOD_IN_"+toString(i)+"_NUM_REG_RD"   );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_WRITE_RE"     ,
			           dest, "in_DECOD_IN_"+toString(i)+"_WRITE_RE"     );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_NUM_REG_RE"   ,
			           dest, "in_DECOD_IN_"+toString(i)+"_NUM_REG_RE"   );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_EXCEPTION_USE",
			           dest, "in_DECOD_IN_"+toString(i)+"_EXCEPTION_USE");
	  COMPONENT_MAP(_component,src ,"out_DECOD_"   +toString(i)+"_EXCEPTION"    ,
			           dest, "in_DECOD_IN_"+toString(i)+"_EXCEPTION"    );
	}

      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"predict"+toString(i),
				     dest,"predict"+toString(i));
#endif

          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_VAL"                        ,
		              dest,"out_PREDICT_"+toString(i)+"_VAL"                        );
          PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_ACK"                        ,
		              dest, "in_PREDICT_"+toString(i)+"_ACK"                        );
	  if (_param->_have_port_context_id)
          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_CONTEXT_ID"                 ,
		              dest,"out_PREDICT_"+toString(i)+"_CONTEXT_ID"                 );
          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_MATCH_INST_IFETCH_PTR"      ,
		              dest,"out_PREDICT_"+toString(i)+"_MATCH_INST_IFETCH_PTR"      );
          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_BRANCH_STATE"               ,
		              dest,"out_PREDICT_"+toString(i)+"_BRANCH_STATE"               );
          if (_param->_have_port_depth)
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_BRANCH_UPDATE_PREDICTION_ID",
		              dest,"out_PREDICT_"+toString(i)+"_BRANCH_UPDATE_PREDICTION_ID");
          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_BRANCH_CONDITION"           ,
		              dest,"out_PREDICT_"+toString(i)+"_BRANCH_CONDITION"           );
//        PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_BRANCH_STACK_WRITE"         ,
// 		              dest,"out_PREDICT_"+toString(i)+"_BRANCH_STACK_WRITE"         );
          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_BRANCH_DIRECTION"           ,
		              dest,"out_PREDICT_"+toString(i)+"_BRANCH_DIRECTION"           );
          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_ADDRESS_SRC"                ,
		              dest,"out_PREDICT_"+toString(i)+"_ADDRESS_SRC"                );
          PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_ADDRESS_DEST"               ,
		              dest,"out_PREDICT_"+toString(i)+"_ADDRESS_DEST"               );
          PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_CAN_CONTINUE"               ,
 		              dest, "in_PREDICT_"+toString(i)+"_CAN_CONTINUE"               );
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"context_"+toString(i),
				     dest,"context_"+toString(i));
#endif
	  
          PORT_MAP(_component,src , "in_CONTEXT_"+toString(i)+"_DECOD_ENABLE",
		              dest, "in_CONTEXT_"+toString(i)+"_DECOD_ENABLE");
	  PORT_MAP(_component,src , "in_CONTEXT_"+toString(i)+"_DEPTH_VAL"   ,
		              dest, "in_CONTEXT_"+toString(i)+"_DEPTH_VAL"   );
          if (_param->_have_port_depth)
	  PORT_MAP(_component,src , "in_CONTEXT_"+toString(i)+"_DEPTH"       ,
		              dest, "in_CONTEXT_"+toString(i)+"_DEPTH"       );
	}

      {
	dest = _name;
	
#ifdef POSITION
	_component->interface_map (src ,"context_event",
				   dest,"context_event");
#endif

	PORT_MAP(_component,src ,"out_CONTEXT_EVENT_VAL"          ,
		            dest,"out_CONTEXT_EVENT_VAL"          );
	PORT_MAP(_component,src , "in_CONTEXT_EVENT_ACK"          ,
		            dest, "in_CONTEXT_EVENT_ACK"          );
	if (_param->_have_port_context_id)
	PORT_MAP(_component,src ,"out_CONTEXT_EVENT_CONTEXT_ID"   ,
		            dest,"out_CONTEXT_EVENT_CONTEXT_ID"   );
	if (_param->_have_port_depth)
	PORT_MAP(_component,src ,"out_CONTEXT_EVENT_DEPTH"        ,
		            dest,"out_CONTEXT_EVENT_DEPTH"        );
	PORT_MAP(_component,src ,"out_CONTEXT_EVENT_TYPE"         ,
		            dest,"out_CONTEXT_EVENT_TYPE"         );
	PORT_MAP(_component,src ,"out_CONTEXT_EVENT_IS_DELAY_SLOT",
		            dest,"out_CONTEXT_EVENT_IS_DELAY_SLOT");
	PORT_MAP(_component,src ,"out_CONTEXT_EVENT_ADDRESS"      ,
		            dest,"out_CONTEXT_EVENT_ADDRESS"      );
	PORT_MAP(_component,src ,"out_CONTEXT_EVENT_ADDRESS_EPCR" ,
		            dest,"out_CONTEXT_EVENT_ADDRESS_EPCR" );

      }
    }

    // ===================================================================
    // =====[ decod_queue ]===============================================
    // ===================================================================
    {
      src = _name+"_decod_queue";
      log_printf(INFO,Decod_unit,FUNCTION,_("Instance : %s"),src.c_str());
           
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // in_DECOD_IN_VAL            - component decod
      //out_DECOD_IN_ACK            - component decod
      // in_DECOD_IN_CONTEXT_ID     - component decod
      // in_DECOD_IN_DEPTH          - component decod
      // in_DECOD_IN_TYPE           - component decod
      // in_DECOD_IN_OPERATION      - component decod
      // in_DECOD_IN_NO_EXECUTE     - component decod
      // in_DECOD_IN_IS_DELAY_SLOT  - component decod
      // in_DECOD_IN_ADDRESS        - component decod
      // in_DECOD_IN_ADDRESS_NEXT   - component decod
      // in_DECOD_IN_HAS_IMMEDIAT   - component decod
      // in_DECOD_IN_IMMEDIAT       - component decod
      // in_DECOD_IN_READ_RA        - component decod
      // in_DECOD_IN_NUM_REG_RA     - component decod
      // in_DECOD_IN_READ_RB        - component decod
      // in_DECOD_IN_NUM_REG_RB     - component decod
      // in_DECOD_IN_READ_RC        - component decod
      // in_DECOD_IN_NUM_REG_RC     - component decod
      // in_DECOD_IN_WRITE_RD       - component decod
      // in_DECOD_IN_NUM_REG_RD     - component decod
      // in_DECOD_IN_WRITE_RE       - component decod
      // in_DECOD_IN_NUM_REG_RE     - component decod
      // in_DECOD_IN_EXCEPTION_USE  - component decod
      // in_DECOD_IN_EXCEPTION      - component decod

      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"decod_out_"+toString(i),
				     dest,"decod"     +toString(i));
#endif

	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_VAL"          ,
		              dest,"out_DECOD_"    +toString(i)+"_VAL"          );
	  PORT_MAP(_component,src , "in_DECOD_OUT_"+toString(i)+"_ACK"          ,
		              dest, "in_DECOD_"    +toString(i)+"_ACK"          );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_CONTEXT_ID"   ,
		              dest,"out_DECOD_"    +toString(i)+"_CONTEXT_ID"   );
	  if (_param->_have_port_depth)
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_DEPTH"        ,
		              dest,"out_DECOD_"    +toString(i)+"_DEPTH"        );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_TYPE"         ,
		              dest,"out_DECOD_"    +toString(i)+"_TYPE"         );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_OPERATION"    ,
		              dest,"out_DECOD_"    +toString(i)+"_OPERATION"    );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_NO_EXECUTE"   ,
		              dest,"out_DECOD_"    +toString(i)+"_NO_EXECUTE"   );
// 	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_HAVE_EVENT"   ,
// 		              dest,"out_DECOD_"    +toString(i)+"_HAVE_EVENT"   );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_LAST_EVENT"   ,
		              dest,"out_DECOD_"    +toString(i)+"_LAST_EVENT"   );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_IS_DELAY_SLOT",
		              dest,"out_DECOD_"    +toString(i)+"_IS_DELAY_SLOT");
#ifdef DEBUG
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_ADDRESS"      ,
		              dest,"out_DECOD_"    +toString(i)+"_ADDRESS"      );
#endif
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_ADDRESS_NEXT" ,
		              dest,"out_DECOD_"    +toString(i)+"_ADDRESS_NEXT" );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_HAS_IMMEDIAT" ,
		              dest,"out_DECOD_"    +toString(i)+"_HAS_IMMEDIAT" );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_IMMEDIAT"     ,
		              dest,"out_DECOD_"    +toString(i)+"_IMMEDIAT"     );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_READ_RA"      ,
		              dest,"out_DECOD_"    +toString(i)+"_READ_RA"      );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RA"   ,
		              dest,"out_DECOD_"    +toString(i)+"_NUM_REG_RA"   );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_READ_RB"      ,
		              dest,"out_DECOD_"    +toString(i)+"_READ_RB"      );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RB"   ,
		              dest,"out_DECOD_"    +toString(i)+"_NUM_REG_RB"   );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_READ_RC"      ,
		              dest,"out_DECOD_"    +toString(i)+"_READ_RC"      );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RC"   ,
		              dest,"out_DECOD_"    +toString(i)+"_NUM_REG_RC"   );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_WRITE_RD"     ,
		              dest,"out_DECOD_"    +toString(i)+"_WRITE_RD"     );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RD"   ,
		              dest,"out_DECOD_"    +toString(i)+"_NUM_REG_RD"   );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_WRITE_RE"     ,
		              dest,"out_DECOD_"    +toString(i)+"_WRITE_RE"     );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_NUM_REG_RE"   ,
		              dest,"out_DECOD_"    +toString(i)+"_NUM_REG_RE"   );
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_EXCEPTION_USE",
		              dest,"out_DECOD_"    +toString(i)+"_EXCEPTION_USE");
	  PORT_MAP(_component,src ,"out_DECOD_OUT_"+toString(i)+"_EXCEPTION"    ,
		              dest,"out_DECOD_"    +toString(i)+"_EXCEPTION"    );
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"depth"+toString(i),
				     dest,"depth"+toString(i));
#endif

          if (_param->_have_port_depth)
            {
	  PORT_MAP(_component,src , "in_DEPTH_"+toString(i)+"_MIN",
		              dest, "in_DEPTH_"+toString(i)+"_MIN");
	  PORT_MAP(_component,src , "in_DEPTH_"+toString(i)+"_MAX",
		              dest, "in_DEPTH_"+toString(i)+"_MAX");
            }
	  PORT_MAP(_component,src , "in_DEPTH_"+toString(i)+"_FULL",
		              dest, "in_DEPTH_"+toString(i)+"_FULL");
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"nb_inst"+toString(i),
				     dest,"nb_inst"+toString(i));
#endif

	  PORT_MAP(_component,src ,"out_NB_INST_"+toString(i)+      "_ALL",
		              dest,"out_NB_INST_"+toString(i)+"_DECOD_ALL");
	}



      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"context_"+toString(i),
				     dest,"context_"+toString(i));
#endif
	  
          PORT_MAP(_component,src , "in_CONTEXT_"+toString(i)+"_EVENT"       ,
		              dest, "in_CONTEXT_"+toString(i)+"_EVENT"       );

	}
    }
    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if DEBUG_Decod_unit == true
      _component->test_map();
#endif

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif
    
    log_end(Decod_unit,FUNCTION);
  };

}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
