/*
 * $Id: RegisterFile_Multi_Banked_allocation.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  void RegisterFile_Multi_Banked::allocation (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"allocation","Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"RegisterFile_Multi_Banked"
#ifdef POSITION
					      ,REGISTER 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

     // ~~~~~[ Interface : "read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     { 
       ALLOC1_INTERFACE_BEGIN("read",IN,WEST,_("Interface Read"),_param->_nb_port_read);

       ALLOC1_VALACK_IN ( in_READ_VAL    ,VAL);
       ALLOC1_VALACK_OUT(out_READ_ACK    ,ACK);
       ALLOC1_SIGNAL_IN ( in_READ_ADDRESS,"address",Taddress_t, _param->_size_address);
       ALLOC1_SIGNAL_OUT(out_READ_DATA   ,"data"   ,Tdata_t   , _param->_size_word);

       ALLOC1_INTERFACE_END(_param->_nb_port_read);
     }
     
     // ~~~~~[ Interface : "write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("write",IN,EAST,_("Interface Write"),_param->_nb_port_write);

       ALLOC1_VALACK_IN ( in_WRITE_VAL    ,VAL);
       ALLOC1_VALACK_OUT(out_WRITE_ACK    ,ACK);
       ALLOC1_SIGNAL_IN ( in_WRITE_ADDRESS,"address",Taddress_t,_param->_size_address);
       ALLOC1_SIGNAL_IN ( in_WRITE_DATA   ,"data"   ,Tdata_t   ,_param->_size_word);

       ALLOC1_INTERFACE_END(_param->_nb_port_write);
      }

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        // ~~~~~[ Registers ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        ALLOC2(reg_DATA,Tdata_t,_param->_nb_bank,_param->_nb_word);

        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        ALLOC1(internal_WRITE_VAL    ,bool      ,_param->_nb_port_write);
        ALLOC1(internal_WRITE_BANK   ,Taddress_t,_param->_nb_port_write);
        ALLOC1(internal_WRITE_NUM_REG,Taddress_t,_param->_nb_port_write);

#ifdef STATISTICS
        ALLOC1(internal_READ_VAL     ,bool      ,_param->_nb_port_read);
#endif
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif
    
    log_printf(FUNC,RegisterFile_Multi_Banked,"allocation","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
