/*
 * $Id: RegisterFile_Multi_Banked_deallocation.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  void RegisterFile_Multi_Banked::deallocation (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"deallocation","Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        delete in_CLOCK;
        delete in_NRESET;
     
        DELETE1_SIGNAL( in_READ_VAL     ,_param->_nb_port_read,1);
        DELETE1_SIGNAL(out_READ_ACK     ,_param->_nb_port_read,1);
        DELETE1_SIGNAL( in_READ_ADDRESS ,_param->_nb_port_read,_param->_size_address);
        DELETE1_SIGNAL(out_READ_DATA    ,_param->_nb_port_read,_param->_size_word);
        
        DELETE1_SIGNAL( in_WRITE_VAL    ,_param->_nb_port_write,1);
        DELETE1_SIGNAL(out_WRITE_ACK    ,_param->_nb_port_write,1);
        DELETE1_SIGNAL( in_WRITE_ADDRESS,_param->_nb_port_write,_param->_size_address);
        DELETE1_SIGNAL( in_WRITE_DATA   ,_param->_nb_port_write,_param->_size_word);
        
        DELETE2(reg_DATA                ,_param->_nb_bank,_param->_nb_word);
        
        DELETE1(internal_WRITE_VAL      ,_param->_nb_port_write);
        DELETE1(internal_WRITE_BANK     ,_param->_nb_port_write);
        DELETE1(internal_WRITE_NUM_REG  ,_param->_nb_port_write);

#ifdef STATISTICS
        DELETE1(internal_READ_VAL       ,_param->_nb_port_read);
#endif

      }       

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,RegisterFile_Multi_Banked,"deallocation","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
