/*
 * $Id: Debug_signal.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */
#ifdef DEBUG_SIGNAL

#include "Behavioural/include/Debug_signal.h"
#include "Common/include/Message.h"

namespace morpheo {
namespace behavioural {

  debug_signal _debug_signal;

  void debug_signal::add (void *      signal,
                          std::string name)
  {
    _signal[signal] = name;
  }

  void debug_signal::write (void * signal)
  {
    std::map <void *,std::string>::iterator it=_signal.find(signal);
    if (it != _signal.end())
      _signal_access.push_back(it->second);

// else
//   msgError("At file %s, in line %d, invalid signal.\n",__FILE__,__LINE__); 
  }

  void debug_signal::end_cycle (void)
  {
    _signal_access.clear();
  }

  void debug_signal::print (void)
  {
    msg("List of access signal\n");
    for (std::list<std::string>::iterator it = _signal_access.begin();
         it != _signal_access.end();
         ++ it)
      {
        msg(" * %s\n",(*it).c_str());
      }
  }

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
