#ifndef morpheo_behavioural_generic_shifter_Parameters_h
#define morpheo_behavioural_generic_shifter_Parameters_h

/*
 * $Id: Parameters.h 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/Shifter/include/Types.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t    _size_data           ;
  public : uint32_t    _nb_port             ;
  public : uint32_t    _shift_value         ; // 0 = external shifter's value 
  public : rotate_t    _rotate              ;
  public : direction_t _direction           ;
  public : carry_t     _carry               ;
  public : uint32_t    _size_data_completion;
  public : bool        _type_completion_bool;

  public : uint32_t    _size_shift        ;

  public : bool        _internal_direction;
  public : bool        _internal_type     ;
  public : bool        _internal_carry    ;

  public : bool        _have_shift_logic_left        ;
  public : bool        _have_shift_logic_right       ;
  public : bool        _have_shift_logic             ;
  public : bool        _have_shift_arithmetic_left   ;
  public : bool        _have_shift_arithmetic_right  ;
  public : bool        _have_shift_arithmetic        ;
  public : bool        _have_shift                   ;
  public : bool        _have_rotate_left             ;
  public : bool        _have_rotate_right            ;
  public : bool        _have_rotate                  ;
    
  public : bool        _have_direction_left          ;
  public : bool        _have_direction_right         ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    size_data           ,
			uint32_t    nb_port             ,
			uint32_t    shift_value         ,
			rotate_t    rotate              ,
			direction_t direction           ,
			carry_t     carry               ,
			bool        type_completion_bool = false);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					      morpheo::behavioural::generic::shifter::Parameters & x);
  };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
