#!/bin/bash

#-----------------------------------------------------------
# $Id$
#-----------------------------------------------------------
file_version="${MORPHEO_TOPLEVEL}/Version";

#-----[ usage ]---------------------------------------------
function usage ()
{
    echo "Usage           : ${0} action";
    echo "Arguments       : ";
    echo " * action";     
    echo "   * add        : add all file unpresent in project and set proprity";
    echo "   * commit     : update revision number and commit";
    echo "   * status     : print only locally modified items";
    echo "   * status_new : print only locally new      items";
    echo "   * help       : print this message";
    echo "Note            :";
    echo " * Morpheo's environnement must be positionned.";
    exit;
}

#-----[ main ]----------------------------------------------
function main ()
{
    # Test operand
    if test ${#} -ne 1; then
	usage ${*};
    fi;

    if test -z ${MORPHEO_TOPLEVEL}; then
	usage ${*};
    fi;

    export LC_ALL=C;
    export EDITOR="emacs";

    pwd=${PWD};
    
    case ${1} in
	"commit")
	    cd ${MORPHEO_TOPLEVEL};
    
	    # +1 because is the next revision
	    major_version=0;
	    minor_version=2;
	    codename="Castor";

	    revision=$(($(export LC_ALL=C; svnversion  | tr -d [:alpha:] | cut -d : -f 2) + 1));
            date_day=$(date +%d);
            date_month=$(date +%m);
            date_year=$(date +%Y);
            
	    echo "${major_version} ${minor_version} ${revision} ${codename} ${date_day} ${date_month} ${date_year}" > ${file_version};
	    
	    svn commit;

	    cd ${pwd};
	    ;;

	"add")
	    cd ${MORPHEO_TOPLEVEL};

	    for i in $(svn status | grep '?'); do
		if test -e ${i}; then
		    svn add ${i};
		    svn propset svn:keywords "Id" ${i} -R
		fi;
	    done;

	    cd ${pwd};
	    ;;

	"status")
	    cd ${MORPHEO_TOPLEVEL};

	    svn status;

	    cd ${pwd};
	    ;;

	"status_new")
	    cd ${MORPHEO_TOPLEVEL};

	    svn status | grep '?';

	    cd ${pwd};
	    ;;
	    
	"help")
	    usage ${*};
	    ;;
	*)
	    usage ${*};
    esac
}

#-----[ Body ]----------------------------------------------
main ${*}
