#ifndef Morpheo_Environment_h
#define Morpheo_Environment_h

/*
 * $Id: Environment.h 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include <string>

namespace morpheo {

#if (defined(STATISTICS) and not defined(SYSTEMC))
# error "To have the statistics, you must set flags SYSTEMC"
#endif

#if (defined(INFORMATION) and not defined(STATISTICS))
# error "To have the information, you must set flags STATISTICS"
#endif

#if (defined(VHDL_TESTBENCH) and not defined(SYSTEMC))
# error "To have the vhdl's test bench, you must set flags SYSTEMC"
#endif

#if (defined(VHDL_TESTBENCH) and not defined(VHDL))
# error "To have the vhdl's test bench, you must set flags VHDL"
#endif

#if (defined(VHDL_TESTBENCH_ASSERT) and not defined(VHDL_TESTBENCH))
# error "To have an assert in vhdl's test bench, you must set flags VHDL_TESTBENCH"
#endif

#if (defined(VHDL_TESTBENCH) and defined(SYSTEMC))
# define SYSTEMC_VHDL_COMPATIBILITY
#endif

#if (defined(DEBUG))
# define DEBUG_TEST
#endif

#if defined(MTI_SYSTEMC) and defined(SYSTEMC) and defined(VHDL)
# define MODELSIM_COSIMULATION
#endif

  // Environment variable
  extern std::string MORPHEO_HOME;
  extern std::string MORPHEO_TOPLEVEL;
  extern std::string MORPHEO_VERSION;
  extern std::string MORPHEO_HEADER;
  extern std::string MORPHEO_DATE;
  
  void environment (void);
  
  extern std::string MORPHEO_STATISTICS;
  extern std::string MORPHEO_VHDL;
  extern std::string MORPHEO_POSITION;
  extern std::string MORPHEO_LOG;
  
  void directory      (void);
  void directory_init (std::string MORPHEO_STATISTICS =".",
                       std::string MORPHEO_VHDL       =".",
                       std::string MORPHEO_POSITION   =".",
                       std::string MORPHEO_LOG        =".");

}; // end namespace morpheo

#endif
