/*
 * $Id: Parameters_print.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {


#undef  FUNCTION
#define FUNCTION "OOO_Engine::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(OOO_Engine,FUNCTION);

    std::string str = "";
    
    str+= toString(MSG_INFORMATION)+"   * nb_front_end                     : "+toString<uint32_t         >(_nb_front_end                     )+"\n";
    for (uint32_t i=0; i<_nb_front_end; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_context                         ["+toString(i)+"] : "+toString<uint32_t         >(_nb_context [i]                   )+"\n";//[nb_front_end]
    str+= toString(MSG_INFORMATION)+"   * nb_rename_unit                   : "+toString<uint32_t         >(_nb_rename_unit                   )+"\n";
    str+= toString(MSG_INFORMATION)+"   * nb_execute_loop                  : "+toString<uint32_t         >(_nb_execute_loop                  )+"\n";
    for (uint32_t i=0; i<_nb_front_end; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_inst_decod                      ["+toString(i)+"] : "+toString<uint32_t         >(_nb_inst_decod [i]                )+"\n";//[nb_front_end]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_inst_insert                     ["+toString(i)+"] : "+toString<uint32_t         >(_nb_inst_insert [i]               )+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_inst_retire                     ["+toString(i)+"] : "+toString<uint32_t         >(_nb_inst_retire [i]               )+"\n";//[nb_rename_unit]
    str+= toString(MSG_INFORMATION)+"   * nb_inst_issue                    : "+toString<uint32_t         >(_nb_inst_issue                    )+"\n";
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_inst_execute                    ["+toString(i)+"] : "+toString<uint32_t         >(_nb_inst_execute [i]              )+"\n";//[nb_execute_loop]
    str+= toString(MSG_INFORMATION)+"   * nb_inst_reexecute                : "+toString<uint32_t         >(_nb_inst_reexecute                )+"\n";
    str+= toString(MSG_INFORMATION)+"   * nb_inst_commit                   : "+toString<uint32_t         >(_nb_inst_commit                   )+"\n";
    str+= toString(MSG_INFORMATION)+"   * nb_inst_branch_complete          : "+toString<uint32_t         >(_nb_inst_branch_complete          )+"\n";
    for (uint32_t i=0; i<_nb_front_end; ++i)
    for (uint32_t j=0; j<_nb_context[i]; ++j)
    str+= toString(MSG_INFORMATION)+"   * nb_branch_speculated               ["+toString(i)+"]["+toString(j)+"] : "+toString<uint32_t         >(_nb_branch_speculated [i][j]      )+"\n";//[nb_front_end][nb_context]
    str+= toString(MSG_INFORMATION)+"   * nb_rename_unit_select            : "+toString<uint32_t         >(_nb_rename_unit_select            )+"\n";
    str+= toString(MSG_INFORMATION)+"   * nb_execute_loop_select           : "+toString<uint32_t         >(_nb_execute_loop_select           )+"\n";
    str+= toString(MSG_INFORMATION)+"   * size_general_data                : "+toString<uint32_t         >(_size_general_data                )+"\n";
    str+= toString(MSG_INFORMATION)+"   * size_special_data                : "+toString<uint32_t         >(_size_special_data                )+"\n";
    for (uint32_t i=0; i<_nb_front_end; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_rename_unit_with_front_end    ["+toString(i)+"] : "+toString<uint32_t         >(_link_rename_unit_with_front_end[i])+"\n";//[nb_front_end]
    str+= toString(MSG_INFORMATION)+"   * size_re_order_buffer             : "+toString<uint32_t         >(_size_re_order_buffer             )+"\n";
    str+= toString(MSG_INFORMATION)+"   * nb_re_order_buffer_bank          : "+toString<uint32_t         >(_nb_re_order_buffer_bank          )+"\n";
    str+= toString(MSG_INFORMATION)+"   * commit_priority                  : "+toString<Tpriority_t      >(_commit_priority                  )+"\n";
    str+= toString(MSG_INFORMATION)+"   * commit_load_balancing            : "+toString<Tload_balancing_t>(_commit_load_balancing            )+"\n";
    str+= toString(MSG_INFORMATION)+"   * size_issue_queue                 : "+toString<uint32_t         >(_size_issue_queue                 )+"\n";
    str+= toString(MSG_INFORMATION)+"   * nb_issue_queue_bank              : "+toString<uint32_t         >(_nb_issue_queue_bank              )+"\n";
    str+= toString(MSG_INFORMATION)+"   * issue_priority                   : "+toString<Tpriority_t      >(_issue_priority                   )+"\n";
    str+= toString(MSG_INFORMATION)+"   * issue_load_balancing             : "+toString<Tload_balancing_t>(_issue_load_balancing             )+"\n";
//  for (uint32_t i=0; i<_nb_rename_unit; ++i)
//  for (uint32_t j=0; j<_nb_inst_issue ; ++j)
//  str+= toString(MSG_INFORMATION)+"   * table_routing                      ["+toString(i)+"]["+toString(j)+"] : "+toString<bool             >(_table_routing [i][j]             )+"\n";//[nb_rename_unit][nb_inst_issue]
//  for (uint32_t i=0; i<_nb_inst_issue ; ++i)
//  for (uint32_t j=0; j<_nb_type; ++j)
//  str+= toString(MSG_INFORMATION)+"   * table_issue_type                   ["+toString(i)+"]["+toString(j)+"] : "+toString<bool             >(_table_issue_type [i][j]          )+"\n";//[nb_inst_issue][nb_type]
    str+= toString(MSG_INFORMATION)+"   * size_reexecute_queue             : "+toString<uint32_t         >(_size_reexecute_queue             )+"\n";
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * rename_select_priority             ["+toString(i)+"] : "+toString<Tpriority_t      >(_rename_select_priority           [i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * rename_select_load_balancing       ["+toString(i)+"] : "+toString<Tload_balancing_t>(_rename_select_load_balancing     [i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * rename_select_nb_front_end_select  ["+toString(i)+"] : "+toString<uint32_t         >(_rename_select_nb_front_end_select[i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_general_register                ["+toString(i)+"] : "+toString<uint32_t         >(_nb_general_register              [i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_special_register                ["+toString(i)+"] : "+toString<uint32_t         >(_nb_special_register              [i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_reg_free                        ["+toString(i)+"] : "+toString<uint32_t         >(_nb_reg_free                      [i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_rename_unit_bank                ["+toString(i)+"] : "+toString<uint32_t         >(_nb_rename_unit_bank              [i])+"\n";//[nb_rename_unit]
//     for (uint32_t i=0; i<_nb_rename_unit; ++i)
//     str+= toString(MSG_INFORMATION)+"   * size_read_counter                  ["+toString(i)+"] : "+toString<uint32_t         >(_size_read_counter                [i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * nb_load_store_queue                ["+toString(i)+"] : "+toString<uint32_t         >(_nb_load_store_queue              [i])+"\n";//[nb_rename_unit]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    for (uint32_t j=0; j<_nb_load_store_queue[i]; ++j)
    str+= toString(MSG_INFORMATION)+"   * size_store_queue                   ["+toString(i)+"]["+toString(j)+"] : "+toString<uint32_t         >(_size_store_queue                 [i][j])+"\n";//[nb_rename_unit][nb_load_store_queue]
    for (uint32_t i=0; i<_nb_rename_unit; ++i)
    for (uint32_t j=0; j<_nb_load_store_queue[i]; ++j)
    str+= toString(MSG_INFORMATION)+"   * size_load_queue                    ["+toString(i)+"]["+toString(j)+"] : "+toString<uint32_t         >(_size_load_queue                  [i][j])+"\n";//[nb_rename_unit][nb_load_store_queue]
    for (uint32_t i=0; i<_nb_front_end; ++i)
    for (uint32_t j=0; j<_nb_context[i]; ++j)
    str+= toString(MSG_INFORMATION)+"   * link_load_store_unit_with_thread   ["+toString(i)+"]["+toString(j)+"] : "+toString<uint32_t         >(_link_load_store_unit_with_thread [i][j])+"\n";//[nb_front_end][nb_context]
    for (uint32_t i=0; i<_nb_front_end; ++i)
    for (uint32_t j=0; j<_nb_context[i]; ++j)
    for (uint32_t k=0; k<NB_GROUP; ++k)
    str+= toString(MSG_INFORMATION)+"   * implement_group                    ["+toString(i)+"]["+toString(j)+"]["+toString(k)+"] : "+toString<bool             >(_implement_group                  [i][j][k])+"\n";//[nb_front_end][nb_context][NB_GROUP]

//     XML xml ("ooo_engine");

//     xml.balise_open("ooo_engine");
// //  xml.singleton_begin(""); xml.attribut("value",toString(_)); xml.singleton_end();
//     xml.balise_close();

    log_end(OOO_Engine,FUNCTION);
    
//     return xml.get_body(depth);
    return str;
  };

#undef  FUNCTION
#define FUNCTION "OOO_Engine::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::Parameters & x)
  {
    log_begin(OOO_Engine,FUNCTION);

    output_stream << x.print(0);
    
    log_end(OOO_Engine,FUNCTION);

    return output_stream;
  };

}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
