#ifdef STATISTICS
#include "Behavioural/include/Stat.h"

namespace morpheo {
namespace behavioural {
  counters_t * Stat::create_counters (std::string varname, 
                                      uint32_t    nb_counter, 
                                      std::string unit,
                                      std::string description_counter,
                                      std::string description_percent,
                                      std::string description_average)
  {
    counters_t * counters = new counters_t (nb_counter);

    _list_counters->push_back(counters);

    std::string sum = "0";

    for (uint32_t i=0; i<=nb_counter; ++i) // 0 and _nb_counter
      {
        std::string name=varname+"_"+toString(i);
        
        counters->set_counter(alloc_operand (TYPE_COUNTER, name, unit, toString(description_counter.c_str(),i)), i);

        create_expr_percent("percent_"+name,name,"cycle",toString(description_percent.c_str(),i));

        if (i!=0)
          sum = "+ "+sum+" * "+toString(i)+" "+name; // "cycle"
      }

    create_expr_average_by_cycle("average_"+varname,sum,unit+" / cycle",description_average);

    return counters;
  }
};
};
#endif
