/*
 * $Id: Debug.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Common/include/Environment.h"

namespace morpheo {

static bool       debug_initialized;
debug_verbosity_t debug;
bool              debug_cycle_test;
double            debug_cycle_start;
double            debug_cycle_stop ;
double            debug_idle_cycle ;
uint32_t          debug_idle_time  ;

#undef  FUNCTION
#define FUNCTION "debug_init"
void debug_init (void)
{
#ifdef DEBUG
  if (not debug_initialized)
    {
      debug = DEBUG;
      debug_cycle_test = false;
//    debug_initialized = true;
    }
#endif
}

#undef  FUNCTION
#define FUNCTION "debug_init"
void debug_init (debug_verbosity_t level,
                 double            cycle_start,
                 double            cycle_stop ,
                 double            idle_cycle ,
                 uint32_t          idle_time  )
{
  if (not debug_initialized)
    {
#ifdef DEBUG
      // Take min
      debug             = (level < DEBUG)?level:DEBUG;
     
# ifdef SYSTEMC
      debug_cycle_test  = (not (cycle_start == -1) and
                           ((cycle_stop > cycle_start) or 
                            (cycle_stop == -1)));
      debug_cycle_start = cycle_start;
      debug_cycle_stop  = cycle_stop;
# else
      debug_cycle_test  = false;
# endif
# else
      debug             = DEBUG_NONE;
      debug_cycle_test  = false;
      debug_cycle_start = 0;
      debug_cycle_stop  = 0;
#endif

      debug_idle_cycle  = idle_cycle;
      debug_idle_time   = idle_time ;

      msgInformation(_("Debug level : %s\n"),toString(debug).c_str());
      // msgDebug(_("Cycle test  : %d\n"),debug_cycle_test);
      // msgDebug(_("Cycle start : %f\n"),cycle_start);
      // msgDebug(_("Cycle stop  : %f\n"),cycle_stop);

      debug_initialized = true;
    }
}

}; // end namespace morpheo
