#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_Parameters_h

/*
 * $Id: Parameters.h 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t    _nb_inst_read            ;
  public : uint32_t    _size_read_queue         ;
  public : uint32_t    _size_reservation_station;
  public : uint32_t    _nb_context              ;
  public : uint32_t    _nb_front_end            ;
  public : uint32_t    _nb_ooo_engine           ;
  public : uint32_t    _nb_packet               ;
//public : uint32_t    _size_general_data       ;
//public : uint32_t    _size_special_data       ;
  public : uint32_t    _nb_general_register     ;
  public : uint32_t    _nb_special_register     ;
  public : uint32_t    _nb_gpr_write            ;
  public : uint32_t    _nb_spr_write            ;
//public : uint32_t    _size_store_queue        ;
//public : uint32_t    _size_load_queue         ;
  public : uint32_t    _nb_inst_retire          ;
  public : uint32_t    _nb_bypass_write         ;
  public : uint32_t    _nb_bypass_memory        ;
	          			      
  public : uint32_t    _nb_gpr_read             ;
  public : uint32_t    _nb_spr_read             ;    
//public : uint32_t    _size_context_id         ;
//public : uint32_t    _size_front_end_id       ;
//public : uint32_t    _size_ooo_engine_id      ;
//public : uint32_t    _size_packet_id          ;
//public : uint32_t    _size_general_register   ;
//public : uint32_t    _size_special_register   ;

//public : bool        _have_port_context_id    ;
//public : bool        _have_port_front_end_id  ;
//public : bool        _have_port_ooo_engine_id ;
//public : bool        _have_port_packet_id     ;
//public : bool        _have_port_load_queue_ptr;

  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue         ::Parameters * _param_read_queue;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Parameters * _param_reservation_station;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t nb_inst_read            ,
                        uint32_t size_read_queue         ,
			uint32_t size_reservation_station,
			uint32_t nb_context              ,
			uint32_t nb_front_end            ,
			uint32_t nb_ooo_engine           ,
			uint32_t nb_packet               ,
			uint32_t size_general_data       ,
			uint32_t size_special_data       ,
			uint32_t nb_general_register     ,
			uint32_t nb_special_register     ,
			uint32_t nb_gpr_write            ,
			uint32_t nb_spr_write            ,
			uint32_t size_store_queue        ,
			uint32_t size_load_queue         ,
			uint32_t nb_inst_retire          ,
			uint32_t nb_bypass_write         ,
			uint32_t nb_bypass_memory        ,
                        bool     is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::Parameters & x);
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
