#ifdef SYSTEMC
/*
 * $Id: Decod_transition.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::transition"
  void Decod::transition (void)
  {
    log_begin(Decod,FUNCTION);

    if (PORT_READ(in_NRESET) == 0)
      {
	_priority->reset();

	for (uint32_t i=0; i<_param->_nb_context; i++)
	  {
	    reg_CONTEXT_ADDRESS_PREVIOUS [i] = 0xfc; // 0x100-4. (0x100 : reset address)
	    reg_CONTEXT_IS_DELAY_SLOT    [i] = 0;
	    // reg_CONTEXT_SAVE_RAT         [i] = 0;
	  }
      }
    else
      {
	_priority->transition();

	// Compute "next previous" address
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  if (internal_CONTEXT_HAVE_TRANSACTION[i])
	    {
	      reg_CONTEXT_ADDRESS_PREVIOUS [i] = internal_CONTEXT_ADDRESS_PREVIOUS [i];
	      reg_CONTEXT_IS_DELAY_SLOT    [i] = internal_CONTEXT_IS_DELAY_SLOT    [i];
	      // reg_CONTEXT_SAVE_RAT         [i] = internal_CONTEXT_SAVE_RAT         [i];
	    }

// 	for (uint32_t i=0; i<_param->_nb_context; i++)
// 	  log_printf(TRACE,Decod,FUNCTION,"[%d] %.8x %d",i,reg_CONTEXT_ADDRESS_PREVIOUS [i], reg_CONTEXT_IS_DELAY_SLOT [i]);

#ifdef STATISTICS
        if (usage_is_set(_usage,USE_STATISTICS))
          for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
            if (internal_DECOD_VAL [i] and PORT_READ(in_DECOD_ACK[i]))
              (*_stat_sum_inst_decod) ++;
#endif
      }

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(Decod,FUNCTION);
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
