#ifdef SYSTEMC
/*
 * $Id: Register_Address_Translation_unit_function_one_save_constant.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::function_one_save_constant"
  void Register_Address_Translation_unit::function_one_save_constant (void)
  {
    log_begin(Register_Address_Translation_unit,FUNCTION);
    log_function(Register_Address_Translation_unit,FUNCTION,_name.c_str());

    // Constant : accepted already transaction
    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      {
        internal_INSERT_ACK [i] = 1;
        internal_RENAME_ACK [i] = 1;
        
        PORT_WRITE(out_INSERT_ACK[i],internal_INSERT_ACK [i]);
        PORT_WRITE(out_RENAME_ACK[i],internal_RENAME_ACK [i]);
      }
    
    for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
      {
        internal_RETIRE_ACK [i] = 1;
        
        PORT_WRITE(out_RETIRE_ACK[i],internal_RETIRE_ACK [i]);
      }
    
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
        {
          internal_RETIRE_EVENT_ACK [i][j] = 1;
          
          PORT_WRITE(out_RETIRE_EVENT_ACK[i][j],internal_RETIRE_EVENT_ACK [i][j]);
        }
    
    log_end(Register_Address_Translation_unit,FUNCTION);
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
