#ifndef morpheo_behavioural_Entity_h
#define morpheo_behavioural_Entity_h

/*
 * $Id: Entity.h 139 2010-07-30 14:47:27Z rosiere $
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
//#include "Behavioural/include/Description.h"
#include "Behavioural/include/Interfaces.h"
#include "Behavioural/include/Schema.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Usage.h"

namespace morpheo              {
namespace behavioural          {

  class Entity
  {
    // -----[fields ]----------------------------------------------------
  private   : const std::string     _name         ;
  private   : const std::string     _type         ;
#ifdef POSITION
  private   : const schema_t        _schema       ;
#endif
  private   : const Tusage_t        _usage;

  private   : Interfaces          * _interfaces   ;

#ifdef POSITION
  private   : std::string           _comment      ;

  private   :       bool            _is_map       ;
  private   :       uint32_t        _map_size_x   ;
  private   :       uint32_t        _map_size_y   ;
  private   :       uint32_t        _map_pos_x    ;
  private   :       uint32_t        _map_pos_y    ;
#endif

    // -----[methods ]---------------------------------------------------
  public    :                       Entity            ( std::string        name   
						       ,std::string        type   
#ifdef POSITION
						       ,schema_t      schema 
#endif
							,Tusage_t       usage
							);
  public    :                        Entity           (const Entity & entity);
  public    :                       ~Entity           ();

  public    : std::string           get_name          (void);
  public    : std::string           get_type          (void);
  public    : Tusage_t              get_usage         (void);

#ifdef POSITION
  public    : void                  set_comment       (std::string comment);
  private   : std::string           get_comment       (void          );
#endif
  public    : Interfaces *          set_interfaces    (void);
  private   : std::string           get_interfaces    (void);
  public    : Interfaces *          get_interfaces_list(void);

  public    : Interface  *          find_interface    (std::string name);
  public    : Signal     *          find_signal       (std::string name);
  public    : bool                  find_signal       (Signal * signal);

#ifdef POSITION
  public    : void                  mapping           (uint32_t pos_x,
						       uint32_t pos_y,
						       uint32_t size_x ,
						       uint32_t size_y );
#endif

  public    : bool                  test_map          (bool top_level, bool is_behavioural);
//public    : bool                  test_equi         (uint32_t depth);

#ifdef POSITION
  public    : XML                   toXML             (void);
  public    : XML                   toXML_mapping     (void);
#endif
  public    : friend std::ostream&       operator<<        (std::ostream& output_stream,
							    morpheo::behavioural::Entity & x);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
