/*
 * $Id: Parameters.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_translation_unit::Parameters"
  Parameters::Parameters (uint32_t         nb_front_end        ,
			  uint32_t       * nb_context          ,//[nb_front_end]
			  uint32_t         nb_general_register ,
			  uint32_t         nb_special_register ,
                          Trat_scheme_t    rat_scheme          ,
			  uint32_t         nb_inst_insert      ,
			  uint32_t         nb_inst_retire      ,
			  uint32_t         nb_reg_free         ,
			  uint32_t         nb_bank             ,
// 			  uint32_t         size_read_counter   ,
                          uint32_t      ** nb_branch_speculated,//[nb_front_end][nb_context]
                          bool             is_toplevel)
  {
    log_printf(FUNC,Register_translation_unit,FUNCTION,"Begin");
    
    _nb_front_end         = nb_front_end        ;
    _nb_context           = nb_context          ;
    _nb_general_register  = nb_general_register ;
    _nb_special_register  = nb_special_register ;
    _rat_scheme           = rat_scheme          ;
    _nb_inst_insert       = nb_inst_insert      ;
    _nb_inst_retire       = nb_inst_retire      ;
    _nb_reg_free          = nb_reg_free         ;
    _nb_bank              = nb_bank             ;
//  _size_read_counter    = size_read_counter   ;
    _nb_branch_speculated = nb_branch_speculated;

    uint32_t size_general_register = log2(nb_general_register);
    uint32_t size_special_register = log2(nb_special_register);
    uint32_t max_nb_context        = max<uint32_t>(nb_context, nb_front_end);
    
    uint32_t nb_thread = 0;
    for (uint32_t i=0; i<nb_front_end; i++)
      nb_thread += nb_context[i];

    _param_dependency_checking_unit          = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::dependency_checking_unit::Parameters 
      (_nb_front_end       ,
       max_nb_context      ,
       _nb_general_register,
       _nb_special_register,
       _nb_inst_insert     );

    _param_free_list_unit                    = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::free_list_unit::Parameters
      (nb_thread           ,
       _nb_general_register,
       _nb_special_register,
       _nb_bank            ,
       _nb_inst_insert     ,
       _nb_reg_free        ,
       PRIORITY_ROUND_ROBIN);

    _param_register_address_translation_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Parameters
      (_nb_front_end        ,
       _nb_context          ,
       _nb_general_register ,
       _nb_special_register ,
       _rat_scheme          ,
       _nb_inst_insert      ,
       _nb_inst_retire      ,
       _nb_branch_speculated);

    _param_stat_list_unit                    = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::stat_list_unit::Parameters
      (_nb_front_end       ,
       _nb_context         ,
       _nb_general_register,
       _nb_special_register,
       _nb_inst_insert     ,
       _nb_inst_retire     ,
       _nb_reg_free        ,
       _nb_bank            // ,
//     _size_read_counter  
       );

    _param_register_translation_unit_glue    = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_translation_unit_glue::Parameters
      (_nb_inst_insert,
       _nb_inst_retire,
        size_general_register,
        size_special_register);
      
    test();

    if (is_toplevel)
      {
        _size_front_end_id      = log2(nb_front_end       );
        _size_context_id        = log2(max_nb_context     );
        _size_depth             = log2(max<uint32_t>(_nb_branch_speculated,_nb_front_end,_nb_context));
        _size_general_register  = size_general_register;
        _size_special_register  = size_special_register;
        
        _have_port_front_end_id = _size_front_end_id>0;
        _have_port_context_id   = _size_context_id  >0;
        _have_port_depth        = _size_depth       >0;

        copy();
      }

    log_printf(FUNC,Register_translation_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Register_translation_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Register_translation_unit,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Register_translation_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Register_translation_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Register_translation_unit,FUNCTION,"Begin");

    delete _param_dependency_checking_unit;
    delete _param_free_list_unit;
    delete _param_register_address_translation_unit;
    delete _param_stat_list_unit;    
    delete _param_register_translation_unit_glue;

    log_printf(FUNC,Register_translation_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Register_translation_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Register_translation_unit,FUNCTION,"Begin");

    COPY(_param_dependency_checking_unit);
    COPY(_param_free_list_unit);
    COPY(_param_register_address_translation_unit);
    COPY(_param_stat_list_unit);    
    COPY(_param_register_translation_unit_glue);

    log_printf(FUNC,Register_translation_unit,FUNCTION,"End");
  };

}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
