/*
 * $Id: Register_Address_Translation_unit_allocation.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"
#include "Behavioural/include/Allocation.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {

#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::allocation"
  void Register_Address_Translation_unit::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");
    
    _component   = new Component (_usage);
    
    Entity * entity = _component->set_entity (_name       
					      ,"Register_Address_Translation_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );
    
    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }
    
    // ~~~~~[ Interface "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("rename",IN,EAST,_("Input to rename source logical register"), _param->_nb_inst_insert);

      ALLOC1_VALACK_IN      ( in_RENAME_VAL               , VAL);
      ALLOC1_VALACK_OUT     (out_RENAME_ACK               , ACK);
      ALLOC1_SIGNAL_IN      ( in_RENAME_FRONT_END_ID      ,"front_end_id"      ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_IN      ( in_RENAME_CONTEXT_ID        ,"context_id"        ,Tcontext_t        ,_param->_size_context_id  );
      ALLOC1_SIGNAL_IN_COND ( in_RENAME_DEPTH             ,"depth"             ,Tdepth_t          ,_param->_size_depth,_param->_rat_scheme == RAT_DEPTH_SAVE);
      ALLOC1_SIGNAL_IN      ( in_RENAME_SAVE_RAT          ,"save_rat"          ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN      ( in_RENAME_NUM_REG_RA_LOG    ,"num_reg_ra_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN      ( in_RENAME_NUM_REG_RB_LOG    ,"num_reg_rb_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN      ( in_RENAME_NUM_REG_RC_LOG    ,"num_reg_rc_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_IN      ( in_RENAME_NUM_REG_RD_LOG    ,"num_reg_rd_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN      ( in_RENAME_NUM_REG_RE_LOG    ,"num_reg_re_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT     (out_RENAME_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT     (out_RENAME_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT     (out_RENAME_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_OUT     (out_RENAME_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_OUT     (out_RENAME_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register);

      ALLOC1_INTERFACE_END(_param->_nb_inst_insert);
    }
    
    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("insert",IN,NORTH,_("Input to rename destination logical register"), _param->_nb_inst_insert);
      
      ALLOC1_VALACK_IN ( in_INSERT_VAL           ,VAL);
      ALLOC1_VALACK_OUT(out_INSERT_ACK           ,ACK);
//    ALLOC1_SIGNAL_IN ( in_INSERT_FRONT_END_ID  ,"front_end_id"  ,Tcontext_t        ,_param->_size_front_end_id);
//    ALLOC1_SIGNAL_IN ( in_INSERT_CONTEXT_ID    ,"context_id"    ,Tcontext_t        ,_param->_size_context_id  );
      ALLOC1_SIGNAL_IN ( in_INSERT_WRITE_RD      ,"write_rd"      ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_WRITE_RE      ,"write_re"      ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RD_LOG,"num_reg_rd_log",Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RE_LOG,"num_reg_re_log",Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RD_PHY,"num_reg_rd_phy",Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RE_PHY,"num_reg_re_phy",Tspecial_address_t,_param->_size_special_register);

      ALLOC1_INTERFACE_END(_param->_nb_inst_insert);
    }
    
    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("retire",IN,NORTH,_("Input to update on event"), _param->_nb_inst_retire);

      ALLOC1_VALACK_IN ( in_RETIRE_VAL               ,VAL);
      ALLOC1_VALACK_OUT(out_RETIRE_ACK               ,ACK);
      ALLOC1_SIGNAL_IN ( in_RETIRE_FRONT_END_ID      ,"front_end_id"      ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_IN ( in_RETIRE_CONTEXT_ID        ,"context_id"        ,Tcontext_t        ,_param->_size_context_id  );
      ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_LOG    ,"num_reg_rd_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_LOG    ,"num_reg_re_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_IN ( in_RETIRE_RESTORE           ,"restore"           ,Tcontrol_t        ,1);

      ALLOC1_INTERFACE_END(_param->_nb_inst_retire);
    }

    // ~~~~~[ Interface : "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("retire_event", IN,NORTH, _("Retire event"), _param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_VALACK_IN      ( in_RETIRE_EVENT_VAL        ,VAL,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_VALACK_OUT     (out_RETIRE_EVENT_ACK        ,ACK,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN      ( in_RETIRE_EVENT_STATE      ,"state"             ,Tevent_state_t    ,_param->_size_event_state, _param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN_COND ( in_RETIRE_EVENT_TYPE       ,"type"              ,Tevent_type_t     ,_param->_size_event_type , _param->_nb_front_end, _param->_nb_context[it1],_param->_rat_scheme == RAT_DEPTH_SAVE);
      _ALLOC2_SIGNAL_IN_COND ( in_RETIRE_EVENT_DEPTH      ,"depth"             ,Tdepth_t          ,_param->_size_depth      , _param->_nb_front_end, _param->_nb_context[it1],_param->_rat_scheme == RAT_DEPTH_SAVE);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    ALLOC1(internal_RENAME_ACK       ,Tcontrol_t,_param->_nb_inst_insert);
    ALLOC1(internal_RENAME_SAVE      ,Tcontrol_t,_param->_nb_inst_insert);
    ALLOC1(internal_INSERT_ACK       ,Tcontrol_t,_param->_nb_inst_insert);
    ALLOC1(internal_RETIRE_ACK       ,Tcontrol_t,_param->_nb_inst_retire);
    ALLOC2(internal_RETIRE_EVENT_ACK ,Tcontrol_t,_param->_nb_front_end,_param->_nb_context[it1]);

    ALLOC3(rat_gpr_speculative      ,Tgeneral_address_t,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_general_register_logic);
    ALLOC3(rat_spr_speculative      ,Tspecial_address_t,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_special_register_logic);

    switch(_param->_rat_scheme)
      {
      case RAT_NO_SAVE    :
        {
          break;
        }
      case RAT_ONE_SAVE   :
        {
          ALLOC3(rat_gpr_not_speculative  ,Tgeneral_address_t,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_general_register_logic);
          ALLOC3(rat_gpr_speculative_valid,bool              ,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_general_register_logic);

          ALLOC3(rat_spr_not_speculative  ,Tspecial_address_t,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_special_register_logic);
          ALLOC3(rat_spr_speculative_valid,bool              ,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_special_register_logic);
          
          break;
        }
      case RAT_DEPTH_SAVE :
        {
          ALLOC4(rat_gpr_save             ,Tgeneral_address_t,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_branch_speculated[it1][it2],_param->_nb_general_register_logic);
          ALLOC4(rat_spr_save             ,Tspecial_address_t,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_branch_speculated[it1][it2],_param->_nb_special_register_logic);
          ALLOC2(rat_depth                ,Tdepth_t          ,_param->_nb_front_end,_param->_nb_context[it1]);
    
          break;
        }
      }
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
