#ifdef STATISTICS
/*
 * $Id: Commit_unit_statistics_deallocation.cpp 142 2010-08-04 20:09:03Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Commit_unit.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


#undef  FUNCTION
#define FUNCTION "Commit_unit::statistics_deallocation"
  void Commit_unit::statistics_deallocation (void)
  {
    log_begin(Commit_unit,FUNCTION);

    log_printf(INFO,Commit_unit,FUNCTION,_("<%s> : Generate Statistics file"),_name.c_str());

    delete _stat;

    delete [] _stat_nb_inst_retire_ok;
    delete [] _stat_nb_inst_retire_ko;
    delete [] _stat_nb_inst_instruction;
    delete [] _stat_nb_inst_type;
    delete [] _stat_bank_nb_inst;

    delete [] _stat_nb_cycle_state_no_event      ;
    delete [] _stat_nb_cycle_state_not_yet_event ;
    delete [] _stat_nb_cycle_state_event         ;
    delete [] _stat_nb_cycle_state_wait_end      ;

    delete [] _stat_nb_inst_insert;
    delete [] _stat_nb_inst_retire;
    delete [] _stat_nb_inst_commit;

//  uint32_t mask_inst      = gen_mask<uint32_t>(SIZE_INSTRUCTION);
    uint32_t mask_type      = gen_mask<uint32_t>(SIZE_TYPE       );
    uint32_t mask_operation = gen_mask<uint32_t>(SIZE_OPERATION  );

    for (uint32_t i=0; i<_param->_nb_thread; ++i)
      for(stat_inst_fusion_t::iterator it = _stat_inst_fusion [i].begin();
          it != _stat_inst_fusion [i].end();
          ++it)
        {
          uint32_t value = it->second;

          if (value != 0)
            {
              uint32_t inst = it->first;

              type_t   type_0      = static_cast<type_t>((inst>>(SIZE_TYPE+2*SIZE_OPERATION))&mask_type     );
              uint32_t operation_0 =                     (inst>>(SIZE_TYPE+  SIZE_OPERATION))&mask_operation ;
              type_t   type_1      = static_cast<type_t>((inst>>(            SIZE_OPERATION))&mask_type     );
              uint32_t operation_1 =                      inst                               &mask_operation ;

              // log_printf(STAT,Commit_unit,FUNCTION,
              msgInformation(
                           //"  * %s - %s : %d\n"
                           //,toString_instruction((inst>>SIZE_INSTRUCTION)&mask_inst).c_str()
                           //,toString_instruction( inst                   &mask_inst).c_str(),value
                             "  * %s.%s - %s.%s : %d\n"
                             ,toString          (type_0            ).c_str()
                             ,toString_operation(type_0,operation_0).c_str()
                             ,toString          (type_1            ).c_str()
                             ,toString_operation(type_1,operation_1).c_str()
                             ,value
                             );
            }
        }

 // DELETE1(_stat_last_inst          ,_param->_nb_thread);
    DELETE1(_stat_last_inst_type     ,_param->_nb_thread);
    DELETE1(_stat_last_inst_operation,_param->_nb_thread);
    DELETE1(_stat_inst_fusion        ,_param->_nb_thread);
        
    log_end(Commit_unit,FUNCTION);
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
