#!/bin/bash

declare localization="labs";
declare type="cosim";
declare type_list=("systemc" "vhdl" "cosim" "debug" "debug_systemc");
declare distcc=0;
declare file_version="Version";
declare error=0;

#-----[ environment_usage ]--------------------------------
function environment_usage ()
{
    echo "Usage     : ${0} [-l localization] [-t type] [-d]";
#    exit;
}

#-----[ environment_test_usage ]----------------------------
function environment_test_usage ()
{
#    if test ${#} -gt 1 -a ${#} -lt 0; then
#        environment_usage ${*};
#    fi;

    TEMP=`getopt -o l:t:hd -- "$@"`

    if test $? != 0; then
	echo "Error in argument parsing";
	error=1;
    fi;

    if test ${error} -eq 0; then
	
	eval set -- "$TEMP"
	
	while true ; do
	    case "$1" in
		-t) type=${2};              shift 2;;
		-l) localization=${2};      shift 2;;
		-h) environment_usage ${*}; shift;;
		-d) distcc=1;               shift;;
		--) shift ; break ;;
		*) echo "Internal error"; error=1;;
	    esac
	done
    fi;
}

#-----[ environment_version ]------------------------------
function environment_version ()
{
    local version=$(cat ${MORPHEO_TOPLEVEL}/${file_version});

    export MORPHEO_MAJOR_VERSION=$(echo ${version} | cut -d ' ' -f 1);
    export MORPHEO_MINOR_VERSION=$(echo ${version} | cut -d ' ' -f 2);
    export MORPHEO_REVISION=$(     echo ${version} | cut -d ' ' -f 3);
    export MORPHEO_CODENAME=$(     echo ${version} | cut -d ' ' -f 4);
    
    export MORPHEO_DATE_DAY=$(     echo ${version} | cut -d ' ' -f 5);
    export MORPHEO_DATE_MONTH=$(   echo ${version} | cut -d ' ' -f 6);
    export MORPHEO_DATE_YEAR=$(    echo ${version} | cut -d ' ' -f 7);

    echo "Morpheo ${MORPHEO_MAJOR_VERSION}.${MORPHEO_MINOR_VERSION}.${MORPHEO_REVISION} \"${MORPHEO_CODENAME}\" (${MORPHEO_DATE_DAY}/${MORPHEO_DATE_MONTH}/${MORPHEO_DATE_YEAR})";
}

#-----[ environment ]---------------------------------------
function environment ()
{
    environment_test_usage ${*};

    if test ${error} -eq 0; then
	local OS_FOUND=`uname -s`-`uname -m | sed -e 's/i[0-9]/iX/' -e 's/sun4./sun4X/'`

	case ${OS_FOUND} in
            "Linux-iX86")
    		export TARGET_ARCH=linux;
    		export EXE_SUFFIX=;
    		;;
            *) 
		echo "Unknown OS found"
	esac
	
	cd $(dirname ${BASH_SOURCE[0]});
	export MORPHEO_TOPLEVEL=${PWD};
	cd - &> /dev/null;
	
        # Export environment
	export MORPHEO_LOCALIZATION=${localization};
	export MORPHEO_TYPE=${type};
	export MORPHEO_DISTCC=${distcc};
	export MORPHEO_SCRIPT=${MORPHEO_TOPLEVEL}/IPs/systemC/processor/Morpheo/Script;
	export MORPHEO_HOME=${HOME}/.Morpheo;
	local  MORPHEO_XTTY=${MORPHEO_TOPLEVEL}/IPs/systemC/Environment/TTY/xtty;

	for i in ${type_list[*]}; do
	    if test "${i}" = "${MORPHEO_TYPE}"; then
		error=0;
		break;
	    fi;
	done;
	
	if test ${error} -ne 0; then
	    echo "Bad type : \"${MORPHEO_TYPE}\"";
	fi;
        
	case ${MORPHEO_LOCALIZATION} in
            "labs")
    		export MORPHEO_PREFIX=/users/chaos/kane/Morpheo;
    		export MORPHEO_TMP=${MORPHEO_PREFIX}/tmp;
    		;;
            "home" | "nettop")
    		export MORPHEO_PREFIX=${HOME}/tmp/Morpheo;
    		export MORPHEO_TMP=${MORPHEO_PREFIX}/tmp;
    		;;
            *)
    		echo "Bad localization : \"${MORPHEO_LOCALIZATION}\"";
		error=1;
    		;;
	esac
    fi;

    if test ${error} -eq 0; then
        environment_version;
        
        echo ""
        echo "OS found : ${OS_FOUND}"
        echo ""
        echo "Modification of environement's variable :"
        echo " - MORPHEO_LOCALIZATION is set to ${MORPHEO_LOCALIZATION}"
        echo " - MORPHEO_TYPE         is set to ${MORPHEO_TYPE}"
        echo " - MORPHEO_DISTCC       is set to ${MORPHEO_DISTCC}"
        echo " - MORPHEO_TOPLEVEL     is set to ${MORPHEO_TOPLEVEL}"
        echo " - MORPHEO_SCRIPT       is set to ${MORPHEO_SCRIPT}"
        echo " - MORPHEO_HOME         is set to ${MORPHEO_HOME}"
        echo " - MORPHEO_PREFIX       is set to ${MORPHEO_PREFIX}"
        echo " - MORPHEO_TMP          is set to ${MORPHEO_TMP}"
        
        #----------
        # Path : add xtty and script directory.
        #        test if already in path : no multiple addition
        #----------
        
        echo ${PATH} |grep -q ${MORPHEO_SCRIPT};
        if test $? -eq 1; then
	    export  PATH=${PATH}:${MORPHEO_SCRIPT}
	    echo " - PATH                 add       ${MORPHEO_SCRIPT}"
        fi;
        
        echo ${PATH} |grep -q ${MORPHEO_XTTY};
        
        if test $? -eq 1; then
	    export  PATH=${PATH}:${MORPHEO_XTTY}
	    echo " - PATH                 add       ${MORPHEO_XTTY}"
        fi;
        
        echo ""
    else
	environment_usage ${*};
    fi;
}

#-----[ Corps ]---------------------------------------------
environment ${*};

unset error;
unset file_version;
unset type_list;
unset distcc;
unset type;
unset localization;
