#include "../include/TTY.h"
#include <stdio.h>

namespace environment {
namespace tty {

  bool TTY::write (uint32_t num_tty, char data)
  {
    if (num_tty >= param->nb_tty)
      return false;

    if (param->with_xtty == true)
      {
	if (::write (xtty[num_tty].pipe_output, &data, 1) == -1)
	  std::cerr << "<TTY::write> write error.\n" << std::endl;
      }
    
    fputc (data, xtty[num_tty].log_file);
    fflush(xtty[num_tty].log_file);

    return true;
  }

};
};
