#include "../include/Data.h"
#include <stdlib.h>

namespace environment {
namespace data {

  Data::Data (std::string name, Parameters * param)
  {
    this->name  = name;
    this->param = param;

    std::list<SEGMENT_TABLE_ENTRY> seglist = param->segtab->getSegmentList(param->globalIndex,param->localIndex);
    nb_seg = seglist.size();

    if (nb_seg >= param->max_seg)
      {
	std::cerr << "The number of seg can't be higher that " << param->max_seg << std::endl;
	exit (1);
      }
    
    segment = new Segment * [param->max_seg];
    
    uint32_t i=0;
    for (std::list<SEGMENT_TABLE_ENTRY>::iterator iter = seglist.begin(); iter != seglist.end() ; ++iter)
      {
	SEGMENT_TABLE_ENTRY * entry = &(*iter);

	segment [i] = new Segment (entry);
	
	param->segtab->setAddrAlloc(entry->getBase(),(void *)(segment [i]->data_addr()));

	i ++;
      }
  }

  Data::~Data (void)
  {
    for (uint32_t i=0; i<nb_seg; i++)
      delete segment [i];
    delete [] segment;
  }

};
};
