/*
 * $Id: Signal_test_map.cpp 144 2010-09-28 11:19:10Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Signal.h"
#include "Common/include/Tabulation.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Signal::test_map"
  bool Signal::test_map (std::string name_interface,bool top_level, bool is_behavioural)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string signame = name_interface+"."+_name;
    std::string str     = "";
//  std::string tab     = morpheo::tab(depth);
    bool        _return = true;

//     log_printf(INFO,Behavioural,FUNCTION, "%s* Signal \"%s\"",tab.c_str(),_name.c_str());
//     log_printf(INFO,Behavioural,FUNCTION, "%s%d - %d - %d",tab.c_str(),
// 	       _is_map_as_toplevel_dest,
// 	       _is_map_as_component_src,
// 	       _is_map_as_component_dest);
//     log_printf(INFO,Behavioural,FUNCTION, "%stop_level %d, is_behavioural %d",tab.c_str(),
// 	       top_level,
// 	       is_behavioural);

    // behavioural | top_level
    //-------------+-----------
    // 0           | 0         - 
    // 0           | 1         - 
    // 1           | 0         - 
    // 1           | 1         - 

    if (not (is_behavioural and top_level))
      {//BURP : ajoue de la parenthèse ...
	if (top_level == true)
	  {
	    switch (_direction)
	      {
	      case morpheo::behavioural::IN       : 
		{
		  if (_is_map_as_toplevel_dest == false)
		    {
		      _return = false;
		      
		      str = "Signal \""+signame+"\" is not mapped with an outpout port top-level's interface or a input port component's interface.";
		    }
		  break;
		}
	      case morpheo::behavioural::OUT      : 
		{
		  if (_is_map_as_toplevel_dest == false)
		    {
		      _return = false;
		      str = "Signal \""+signame+"\" is not mapped with an input port top-level's interface or a output port component's interface.";
		    }
		  break;
		}
	      case morpheo::behavioural::INTERNAL : 
		{
		  if (_is_map_as_component_src  == false)
		    {
		      _return = false;
		      
		      str = "Internal signal \""+signame+"\" is not mapped with an outpout port top-level's interface or a input port component's interface.";
		    }
		  
		  if (_is_map_as_component_dest == false)
		    {
		      if (_return == false)
			str+="\n";
		      
		      _return = false;
		      
		      str += "Internal signal \""+signame+"\" is not mapped with an input port top-level's interface or a output port component's interface.";
		    }
		  
		  break;
		}
		//case morpheo::behavioural::INOUT    :
	      default    : break;
	      }
	  }
	else
	  {
	    // internal signal :
	    // Component --- I/O       (as_src)
	    // Component --- Component (as_src and as_dest)
	    
	    switch (_direction)
	      {
	      case morpheo::behavioural::IN       : 
		{
		  if (_is_map_as_component_src == false)
		    {
		      _return = false;
		      
		      str = "Signal \""+signame+"\" is not mapped with an input port top-level's interface or a output port component's interface.";
		    }
		  break;
		}
	      case morpheo::behavioural::OUT      : 
		{
		  if (_is_map_as_component_src == false)
		    {
		      _return = false;
		      
		      str = "Signal \""+signame+"\" is not mapped with an outpout port top-level's interface or a input port component's interface.";
		    }
		  break;
		}
	      case morpheo::behavioural::INTERNAL : 
		{
		  if (_is_map_as_component_src  == false)
		    {
		      _return = false;
		      
		      str = "Internal signal \""+signame+"\" is not mapped with an outpout port top-level's interface or a input port component's interface.";
		    }
		  
		  if (_is_map_as_component_dest == false)
		    {
		      if (_return == false)
			str+="\n";
		      
		      _return = false;
		      
		      str += "Internal signal \""+signame+"\" is not mapped with an input port top-level's interface or a output port component's interface.";
		    }
		  
		  break;
		}
		//case morpheo::behavioural::INOUT    :
	      default    : break;
	      }
	  }
      }

    if (_return == false)
      {
	msgError("%s\n",str.c_str());
      }
    else
      {
// 	log_printf(INFO,Interface,FUNCTION, "%s* Signal \"%s\" is OK.",tab.c_str(),signame.c_str());
      }

    log_printf(FUNC,Behavioural,FUNCTION,"End");
    
    return _return;
  };

// #undef  FUNCTION
// #define FUNCTION "Signal::test_equi"
//   bool Signal::test_equi (uint32_t depth)
//   {
//     log_printf(FUNC,Behavioural,FUNCTION,"Begin");

//     std::string str = "";
//     std::string tab = tab(depth);
//     bool _return = true;

    

//     if (_return == false)
//       {
// 	log_printf(INFO,Behavioural,FUNCTION, "%s* %s",tab.c_str(),str.c_str());
	
// #ifndef DEBUG
// 	std::cerr << str << std::endl;
// #endif
//       }
//     else
//       {
// // 	log_printf(INFO,Behavioural,FUNCTION, "%s* Signal \"%s\" is OK.",tab.c_str(),signame.c_str());
//       }
    
//     return _return;
//   };

}; // end namespace behavioural          
}; // end namespace morpheo              
