#ifdef SYSTEMC
/*
 * $Id: Register_Address_Translation_unit_function_depth_save_transition.cpp 144 2010-09-28 11:19:10Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::function_depth_save_transition"
  void Register_Address_Translation_unit::function_depth_save_transition (void)
  {
    log_begin(Register_Address_Translation_unit,FUNCTION);
    log_function(Register_Address_Translation_unit,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
	uint32_t gpr = 1;
	uint32_t spr = 0;

	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	    {
              rat_depth                 [i][j]    = 0;
              rat_gpr_speculative       [i][j][0] = 0;

	      for (uint32_t k=1; k<_param->_nb_general_register_logic; k++)
                rat_gpr_speculative        [i][j][k] = gpr++;
	      for (uint32_t k=0; k<_param->_nb_special_register_logic; k++)
                rat_spr_speculative        [i][j][k] = spr++; // not necessary
	    }
      }
    else
      {
	// Note : GPR[0] is never write (in decod's stage : write_rd = 0 when num_reg_rd_log == 0)

	// =====================================================
	// ====[ RETIRE_EVENT ]=================================
	// =====================================================
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            if (PORT_READ(in_RETIRE_EVENT_VAL [i][j]) and internal_RETIRE_EVENT_ACK [i][j])
              {
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * RETIRE_EVENT [%d][%d]",i,j);
                
                // Test if event have just occure
                if (PORT_READ(in_RETIRE_EVENT_STATE [i][j]) == EVENT_STATE_EVENT)
                  {
                    switch (PORT_READ(in_RETIRE_EVENT_TYPE [i][j]))
                      {
                      case EVENT_TYPE_BRANCH_MISS_SPECULATION :
                      case EVENT_TYPE_LOAD_MISS_SPECULATION   :
                        {
                          // Miss speculation (branch or load)
                          // Restore contexte and update depth

                          log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * MISS_SPECULATION : Restore RAT");

                          Tdepth_t depth = (_param->_have_port_depth)?PORT_READ(in_RETIRE_EVENT_DEPTH [i][j]):0;

                          log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * depth : %d",depth);
                          
                          // restore GPR
                          for (uint32_t num_gpr=0; num_gpr<_param->_nb_general_register_logic; num_gpr++)
                            rat_gpr_speculative [i][j][num_gpr] = rat_gpr_save [i][j][depth][num_gpr];
                          
                          // restore SPR
                          for (uint32_t num_spr=0; num_spr<_param->_nb_special_register_logic; num_spr++)
                            rat_spr_speculative [i][j][num_spr] = rat_spr_save [i][j][depth][num_spr];
                          
                          // update rat_depth
                          rat_depth[i][j] = depth;
                          
                          break;
                        }
                        // case EVENT_TYPE_EXCEPTION               :
                        // case EVENT_TYPE_SPR_ACCESS              :
                        // case EVENT_TYPE_MSYNC                   :
                        // case EVENT_TYPE_PSYNC                   :
                        // case EVENT_TYPE_CSYNC                   :
                      default :
                        {
                          // nothing
                          break;
                        }
                      }
                  
                  }
              }

	// =====================================================
	// ====[ INSERT ]=======================================
	// =====================================================
	// First : interface insert
        // this instruction is speculative !!!
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  // Test transaction
	  if (PORT_READ(in_INSERT_VAL [i]) and internal_INSERT_ACK  [i])
	    {
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * INSERT [%d]",i);

	      Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RENAME_FRONT_END_ID [i]):0;
	      Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RENAME_CONTEXT_ID   [i]):0;
              Tcontrol_t save         = internal_RENAME_SAVE [i];

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end          : %d",front_end_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context            : %d",context_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * save               : %d",save);

	      // Test if write and modifie RAT (RD and RE)

              Tcontrol_t write_rd     = PORT_READ(in_INSERT_WRITE_RD [i]);
              Tcontrol_t write_re     = PORT_READ(in_INSERT_WRITE_RE [i]);

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_rd           : %d",write_rd);
	      if (write_rd == 1)
                {
                  Tgeneral_address_t num_reg_rd_log = PORT_READ(in_INSERT_NUM_REG_RD_LOG [i]);
                  Tgeneral_address_t num_reg_rd_phy = PORT_READ(in_INSERT_NUM_REG_RD_PHY [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_log     : %d",num_reg_rd_log);
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_phy     : %d",num_reg_rd_phy);

                  rat_gpr_speculative [front_end_id][context_id][num_reg_rd_log] = num_reg_rd_phy;
                }

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_re           : %d",write_re);
	      if (write_re == 1)
                {
                  Tspecial_address_t num_reg_re_log = PORT_READ(in_INSERT_NUM_REG_RE_LOG [i]);
                  Tspecial_address_t num_reg_re_phy = PORT_READ(in_INSERT_NUM_REG_RE_PHY [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_log     : %d",num_reg_re_log);
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_phy     : %d",num_reg_re_phy);

                  rat_spr_speculative [front_end_id][context_id][num_reg_re_log] = num_reg_re_phy;
                }

              if (save)
                {
                  // Need save RAT

                  Tdepth_t depth = (_param->_have_port_depth       )?PORT_READ(in_RENAME_DEPTH        [i]):0;

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * depth old - new  : %d",depth);

// #ifdef DEBUG_TEST
//                   if (depth != ((depth_old+1)%_param->_nb_branch_speculated[front_end_id][context_id]))
//                     throw ERRORMORPHEO(FUNCTION,toString(_("Rename : Invalid depth (old : %d, new : %d).\n"),depth_old,depth));
// #endif

                  // save GPR
                  for (uint32_t num_gpr=0; num_gpr<_param->_nb_general_register_logic; num_gpr++)
                    rat_gpr_save [front_end_id][context_id][depth][num_gpr] = rat_gpr_speculative [front_end_id][context_id][num_gpr];

                  // save SPR
                  for (uint32_t num_spr=0; num_spr<_param->_nb_special_register_logic; num_spr++)
                    rat_spr_save [front_end_id][context_id][depth][num_spr] = rat_spr_speculative [front_end_id][context_id][num_spr];

                  // update rat_depth with new depth
                  rat_depth[front_end_id][context_id] = depth;
                }
	    }

	// =====================================================
	// ====[ RETIRE ]=======================================
	// =====================================================
	// Second : interface retire
	//  (because if an event on the same thread : the instruction is already renamed)
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  if (PORT_READ(in_RETIRE_VAL [i]) and internal_RETIRE_ACK [i])
	    {
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * RETIRE [%d]",i);

	      // if no event : no effect, because the RAT content the most recently register
	      // but if they have a event (exception or miss speculation), the rat must restore the oldest value
	      // To restore the oldest valid value, we use the rat_update_table. if the bit is unset, also they have none update on this register
	      // the retire interface became of the Re Order Buffer, also is in program sequence !

#ifdef DEBUG
              Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RETIRE_FRONT_END_ID [i]):0;
              Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RETIRE_CONTEXT_ID   [i]):0;
#endif
              Tcontrol_t write_rd     = PORT_READ(in_RETIRE_WRITE_RD [i]);
              Tcontrol_t write_re     = PORT_READ(in_RETIRE_WRITE_RE [i]);
              Tcontrol_t restore      = PORT_READ(in_RETIRE_RESTORE  [i]);

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end_id       : %d",front_end_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context_id         : %d",context_id  );
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * restore            : %d",restore     );

              // Test if write and have not a previous update
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_rd           : %d",write_rd);
              if (write_rd == 1)
                {
#ifdef DEBUG
                  Tgeneral_address_t num_reg_rd_log     = PORT_READ(in_RETIRE_NUM_REG_RD_LOG     [i]);
#endif

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_log     : %d",num_reg_rd_log    );

                  if (not restore)
                    {
#ifdef DEBUG
                  Tgeneral_address_t num_reg_rd_phy_new = PORT_READ(in_RETIRE_NUM_REG_RD_PHY_NEW [i]);
#endif
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_phy_new : %d",num_reg_rd_phy_new);

                  // rat_gpr_speculative [front_end_id][context_id][num_reg_rd_log] = num_reg_rd_phy_new;
                    }
                }

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_re           : %d",write_re);
              if (write_re == 1)
                {
#ifdef DEBUG
                  Tspecial_address_t num_reg_re_log     = PORT_READ(in_RETIRE_NUM_REG_RE_LOG     [i]);
#endif

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_log     : %d",num_reg_re_log    );

                  if (not restore)
                    {
#ifdef DEBUG
                  Tspecial_address_t num_reg_re_phy_new = PORT_READ(in_RETIRE_NUM_REG_RE_PHY_NEW [i]);
#endif

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_phy_new : %d",num_reg_re_phy_new);

                  // rat_spr_speculative [front_end_id][context_id][num_reg_re_log] = num_reg_re_phy_new;
                    }
                }

	    }
      }

#if (DEBUG >= DEBUG_TRACE) and (DEBUG_Register_Address_Translation_unit == true)
    {
      uint32_t limit = 4;
      
      log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * Dump RAT (Register_Address_Translation_unit)");
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
          {
            log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end[%d].context[%d] - rat_depth : %d",i,j,rat_depth[i][j]);
          
            for (uint32_t k=0; k<_param->_nb_general_register_logic; k+=limit)
              {
                std::string str = "";
                for (uint32_t x=0; x<limit; x++)
                  {
                    uint32_t index = k+x;
                    if (index >= _param->_nb_general_register_logic)
                      break;
                    else
                      str+=toString("GPR[%.4d] - %.5d | ",index,rat_gpr_speculative [i][j][index]);
                  }
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
              }

            for (uint32_t l=0; l<_param->_nb_branch_speculated[i][j]; ++l)
              for (uint32_t k=0; k<_param->_nb_general_register_logic; k+=limit)
                {
                  std::string str = "";
                  for (uint32_t x=0; x<limit; x++)
                    {
                      uint32_t index = k+x;
                      if (index >= _param->_nb_general_register_logic)
                        break;
                      else
                        str+=toString("GPR_%d[%.4d] - %.5d | ",l,index,rat_gpr_save [i][j][l][index]);
                    }
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
                }
            
            for (uint32_t k=0; k<_param->_nb_special_register_logic; k+=limit)
              {
                std::string str = "";
                
                for (uint32_t x=0; x<limit; x++)
                  {
                    uint32_t index = k+x;
                    if (index >= _param->_nb_special_register_logic)
                      break;
                    else
                      str+=toString("SPR[%.4d] - %.5d | ",index,rat_spr_speculative [i][j][index]);
                  }
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
              }

            for (uint32_t l=0; l<_param->_nb_branch_speculated[i][j]; ++l)
              for (uint32_t k=0; k<_param->_nb_special_register_logic; k+=limit)
                {
                  std::string str = "";
                  for (uint32_t x=0; x<limit; x++)
                    {
                      uint32_t index = k+x;
                      if (index >= _param->_nb_special_register_logic)
                        break;
                      else
                        str+=toString("SPR_%d[%.4d] - %.5d | ",l,index,rat_spr_save [i][j][l][index]);
                    }
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
                }

          }
    }
#endif

    log_end(Register_Address_Translation_unit,FUNCTION);
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
