/*
 * $Id: Environment.cpp 144 2010-09-28 11:19:10Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Environment.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/Debug.h"
#include "Common/include/Message.h"
#include <sys/stat.h>
#include <errno.h>

namespace morpheo {

static bool environment_initialized;
std::string MORPHEO_HOME;
std::string MORPHEO_PREFIX;
std::string MORPHEO_VERSION;
std::string MORPHEO_HEADER;
std::string MORPHEO_DATE;

#undef  FUNCTION
#define FUNCTION "environment"
void environment (void)
{
  if (not environment_initialized)
    {
      {
        char * PREFIX = getenv("MORPHEO_PREFIX");
        
        if (PREFIX == NULL)
          throw ERRORMORPHEO(FUNCTION,_("Error morpheo environment is not positioned.\n"));

        MORPHEO_PREFIX = PREFIX;
      }

      {
        char * HOME = getenv("MORPHEO_HOME");
        
        if (HOME == NULL)
          throw ERRORMORPHEO(FUNCTION,_("Error morpheo environment is not positioned.\n"));

        MORPHEO_HOME = HOME;
      }

      {
        char * MAJOR_VERSION = getenv("MORPHEO_MAJOR_VERSION");
        char * MINOR_VERSION = getenv("MORPHEO_MINOR_VERSION");
        char * REVISION      = getenv("MORPHEO_REVISION");
        char * CODENAME      = getenv("MORPHEO_CODENAME");
        char * DATE_DAY      = getenv("MORPHEO_DATE_DAY");
        char * DATE_MONTH    = getenv("MORPHEO_DATE_MONTH");
        char * DATE_YEAR     = getenv("MORPHEO_DATE_YEAR");

        if ((MAJOR_VERSION == NULL) or
	    (MINOR_VERSION == NULL) or
	    (REVISION      == NULL) or
	    (CODENAME      == NULL) or
	    (DATE_DAY      == NULL) or
	    (DATE_MONTH    == NULL) or
	    (DATE_YEAR     == NULL))
          throw ERRORMORPHEO(FUNCTION,_("Error morpheo environment is not positioned.\n"));

	MORPHEO_VERSION = toString(MAJOR_VERSION)+"."+toString(MINOR_VERSION)+"."+toString(REVISION);
	MORPHEO_HEADER  = MORPHEO_VERSION+" - "+toString(CODENAME);
	MORPHEO_DATE    = toString(DATE_YEAR)+"/"+toString(DATE_MONTH)+"/"+toString(DATE_DAY);
      }

      environment_initialized = true;
    }
}

static bool directory_initialized;
std::string MORPHEO_STATISTICS;
std::string MORPHEO_VHDL;
std::string MORPHEO_POSITION;
std::string MORPHEO_LOG;

#undef  FUNCTION
#define FUNCTION "exist_directory"
void exist_directory (std::string dir)
{
//   struct stat *buf;
//   int res = stat(dir.c_str(), buf);
//   if ((res != 0) or not S_ISDIR(buf->st_mode))
//     throw ERRORMORPHEO(FUNCTION,toString(_("Error in opening directory \"%s\".\n"),dir.c_str()));


  char * pwd = getenv("PWD");
  if (chdir(dir.c_str())!=0)
    throw ERRORMORPHEO(FUNCTION,toString(_("Error in opening directory \"%s\".\n"),dir.c_str()));

  assert(chdir(pwd)==0);
}

#undef  FUNCTION
#define FUNCTION "directory_init"
void directory_init (std::string morpheo_statistics,
                     std::string morpheo_vhdl      ,
                     std::string morpheo_position  ,
                     std::string morpheo_log       )
{
  if (not directory_initialized)
    {
      exist_directory(morpheo_statistics);
      exist_directory(morpheo_vhdl      );
      exist_directory(morpheo_position  );
      exist_directory(morpheo_log       );

      MORPHEO_STATISTICS = morpheo_statistics;
      MORPHEO_VHDL       = morpheo_vhdl      ;
      MORPHEO_POSITION   = morpheo_position  ;
      MORPHEO_LOG        = morpheo_log       ;

      directory_initialized = true;
    }
//   else
//     {
//       msg_printf(WARNING,_("Multi instance of Morpheo : directory, keep actual directory."));
//     }
}

#undef  FUNCTION
#define FUNCTION "directory"
void directory (void)
{
  // with default value
  directory_init();
};

}; //end namespace morpheo
