#include "../include/Segment.h"
#include "../../Common/include/Debug.h"
#include <string.h>
#include <stdlib.h>

namespace environment {
namespace data {
  
  bool Segment::init (const char * filename,const char ** sections)
  {
    void * ptab;
    int    size   = this->size;
//  int    size   = 0;
    int    offset = 0;

    loadexec(&ptab,&size,&offset,filename,sections);

    // std::cout << "  - name           : " << name         << std::endl;
    // std::cout << "    - size         : " << size         << std::endl;
    // std::cout << "    - size         : " << this->size   << std::endl;
    // std::cout << "    - offset       : " << offset       << std::endl;
    
    if (size > (int)this->size)
      {
	std::cerr << "<segment.init> : segment \"" << name << "\" is to small : size is " << this->size << " and requiert is " << size << std::endl;
	return false;
      }
    
    memcpy(data, ptab, size);

    free  (ptab);

//     {
//       _cout(DATA,"Segment Init\n");
//       _cout(DATA," * size : %d\n",size);
//       _cout(DATA," * size : %d\n",this->size);
//       _cout(DATA,"%s\n",print(0).c_str());
      
//       uint32_t addr = base;
//       uint32_t step1 = 4;
//       uint32_t step2 = step1*8;

//       for (int32_t i=0; i<size; ++i)
//         {
//           if ((i%step1) == 0)
//             _cout(DATA," ");
//           if ((i%step2) ==0)
//             {
//               _cout(DATA,"\n%.8x : ",addr);
//               addr += step2;
//             }
//           _cout(DATA,"%.2x",0xff&static_cast<uint32_t>(data[i]));
//         }
//       _cout(DATA,"\n");
//     }
    
    return true;
  }
  
};
};
