/*
 * $Id: Translation.cpp 144 2010-09-28 11:19:10Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Environment.h"
#include "Common/include/Translation.h"
#include "Common/include/ErrorMorpheo.h"

namespace morpheo {

#ifdef TRANSLATION
  static bool translation_initialized;
#endif

  void translation (void)
  {
#ifdef TRANSLATION
    if (not translation_initialized)
      {
        environment();
        
        std::string dirname = MORPHEO_PREFIX;
        dirname += "/locale";

        if (bindtextdomain(MORPHEO_PACKAGE,dirname.c_str()) == NULL)
          throw ERRORMORPHEO("Translation","Error in set directory containing message catalogs.\n");
        
        translation_initialized = true;
      }
#endif    
  }

}; // end namespace morpheo
