#ifdef SYSTEMC
/*
 * $Id: Sort_genMealy.cpp 144 2010-09-28 11:19:10Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Sort/include/Sort.h"
#include <algorithm>

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace sort {


#undef  FUNCTION
#define FUNCTION "Sort::genMealy"
  void Sort::genMealy (void)
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET))
      {
    sort_t array [_param->_nb_input];

    // Push input in a array
    for (uint32_t i=0; i<_param->_nb_input; i++)
      {
	array[i].index = i;
	array[i].val   = PORT_READ( in_INPUT_VAL  [i]);
	array[i].data  = PORT_READ( in_INPUT_DATA [i]);
      }

    // Sort array
    //if (_param->_ascending == true)
    std::stable_sort(array, array+_param->_nb_input);

    // Write output
    for (uint32_t i=0; i<_param->_nb_output; i++)
      {
	PORT_WRITE (out_OUTPUT_VAL   [i],array[i].val  );
	if (_param->_have_port_index_out)
        PORT_WRITE (out_OUTPUT_INDEX [i],array[i].index);
	if (_param->_have_port_data_out)
      	PORT_WRITE (out_OUTPUT_DATA  [i],array[i].data );
      }
      }

    log_printf(FUNC,Sort,FUNCTION,"End");
  };

}; // end namespace sort
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
