/*
 * $Id: Commit_unit_allocation.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Commit_unit.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"
#include "Common/include/Filename.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {

#undef  FUNCTION
#define FUNCTION "Commit_unit::allocation"
  void Commit_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Commit_unit,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Commit_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("insert", IN, SOUTH, _("Interface with rename_unit."),_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

      _ALLOC2_VALACK_IN      ( in_INSERT_VAL                     ,VAL,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_VALACK_OUT     (out_INSERT_ACK                     ,ACK,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_FRONT_END_ID            ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_CONTEXT_ID              ,"context_id"           ,Tcontext_t        ,_param->_size_context_id            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT     (out_INSERT_PACKET_ID               ,"packet_id"            ,Tpacket_t         ,_param->_size_rob_ptr               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
//    _ALLOC2_SIGNAL_IN      ( in_INSERT_RENAME_UNIT_ID          ,"rename_unit_id"       ,Tcontext_t        ,_param->_size_rename_unit_id        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_DEPTH                   ,"depth"                ,Tdepth_t          ,_param->_size_depth                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN_COND ( in_INSERT_SAVE_RAT                ,"save_rat"             ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_rat_scheme[it1] == RAT_DEPTH_SAVE);
#ifdef STATISTICS            
      _ALLOC2_SIGNAL_IN      ( in_INSERT_INSTRUCTION             ,"instruction"          ,uint32_t          ,32                                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#endif                       
      _ALLOC2_SIGNAL_IN      ( in_INSERT_TYPE                    ,"type"                 ,Ttype_t           ,_param->_size_type                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_OPERATION               ,"operation"            ,Toperation_t      ,_param->_size_operation             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NO_EXECUTE              ,"no_execute"           ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_LAST_EVENT              ,"last_event"           ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_IS_DELAY_SLOT           ,"is_delay_slot"        ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#ifdef DEBUG                 
      _ALLOC2_SIGNAL_IN      ( in_INSERT_ADDRESS                 ,"address"              ,Taddress_t        ,_param->_size_instruction_address   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#endif                       
      _ALLOC2_SIGNAL_IN      ( in_INSERT_ADDRESS_NEXT            ,"address_next"         ,Taddress_t        ,_param->_size_instruction_address   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_EXCEPTION               ,"exception"            ,Texception_t      ,_param->_size_exception             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_EXCEPTION_USE           ,"exception_use"        ,Texception_t      ,_param->_size_exception_use         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_STORE_QUEUE_PTR_WRITE   ,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_LOAD_QUEUE_PTR_WRITE    ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#ifdef DEBUG                 
      _ALLOC2_SIGNAL_IN      ( in_INSERT_READ_RA                 ,"read_ra"              ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RA_LOG          ,"num_reg_ra_log"       ,Tgeneral_address_t,_param->_size_general_register_logic,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RA_PHY          ,"num_reg_ra_phy"       ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#endif                       
      _ALLOC2_SIGNAL_IN      ( in_INSERT_READ_RB                 ,"read_rb"              ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#ifdef DEBUG                 
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RB_LOG          ,"num_reg_rb_log"       ,Tgeneral_address_t,_param->_size_general_register_logic,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RB_PHY          ,"num_reg_rb_phy"       ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_READ_RC                 ,"read_rc"              ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RC_LOG          ,"num_reg_rc_log"       ,Tspecial_address_t,_param->_size_special_register_logic,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RC_PHY          ,"num_reg_rc_phy"       ,Tspecial_address_t,_param->_size_special_register      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#endif                       
      _ALLOC2_SIGNAL_IN      ( in_INSERT_WRITE_RD                ,"write_rd"             ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RD_LOG          ,"num_reg_rd_log"       ,Tgeneral_address_t,_param->_size_general_register_logic,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RD_PHY_OLD      ,"num_reg_rd_phy_old"   ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RD_PHY_NEW      ,"num_reg_rd_phy_new"   ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_WRITE_RE                ,"write_re"             ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RE_LOG          ,"num_reg_re_log"       ,Tspecial_address_t,_param->_size_special_register_logic,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RE_PHY_OLD      ,"num_reg_re_phy_old"   ,Tspecial_address_t,_param->_size_special_register      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN      ( in_INSERT_NUM_REG_RE_PHY_NEW      ,"num_reg_re_phy_new"   ,Tspecial_address_t,_param->_size_special_register      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
    }

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("retire",OUT,SOUTH, _("Interface to update rename_unit."),_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      
      _ALLOC2_VALACK_OUT(out_RETIRE_VAL                     ,VAL,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_VALACK_IN ( in_RETIRE_ACK                     ,ACK,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_FRONT_END_ID            ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);  
      _ALLOC2_SIGNAL_OUT(out_RETIRE_CONTEXT_ID              ,"context_id"           ,Tcontext_t        ,_param->_size_context_id            ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);    
//    _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_ID          ,"rename_unit_id"       ,Tcontext_t        ,_param->_size_rename_unit_id        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//    _ALLOC2_SIGNAL_OUT_COND(out_RETIRE_DEPTH              ,"depth"                ,Tdepth_t          ,_param->_size_depth                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_rat_scheme[it1] == RAT_DEPTH_SAVE);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_USE_STORE_QUEUE         ,"use_store_queue"      ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_USE_LOAD_QUEUE          ,"use_load_queue"       ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_STORE_QUEUE_PTR_WRITE   ,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_LOAD_QUEUE_PTR_WRITE    ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//    _ALLOC2_SIGNAL_OUT(out_RETIRE_READ_RA                 ,"read_ra"              ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//    _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RA_PHY          ,"num_reg_ra_phy"       ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//    _ALLOC2_SIGNAL_OUT(out_RETIRE_READ_RB                 ,"read_rb"              ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//    _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RB_PHY          ,"num_reg_rb_phy"       ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//    _ALLOC2_SIGNAL_OUT(out_RETIRE_READ_RC                 ,"read_rc"              ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//    _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RC_PHY          ,"num_reg_rc_phy"       ,Tspecial_address_t,_param->_size_special_register      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_WRITE_RD                ,"write_rd"             ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RD_LOG          ,"num_reg_rd_log"       ,Tgeneral_address_t,_param->_size_general_register_logic,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RD_PHY_OLD      ,"num_reg_rd_phy_old"   ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RD_PHY_NEW      ,"num_reg_rd_phy_new"   ,Tgeneral_address_t,_param->_size_general_register      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_WRITE_RE                ,"write_re"             ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RE_LOG          ,"num_reg_re_log"       ,Tspecial_address_t,_param->_size_special_register_logic,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RE_PHY_OLD      ,"num_reg_re_phy_old"   ,Tspecial_address_t,_param->_size_special_register      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_NUM_REG_RE_PHY_NEW      ,"num_reg_re_phy_new"   ,Tspecial_address_t,_param->_size_special_register      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_RESTORE                 ,"RESTORE"              ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_RESTORE_RD_PHY_OLD      ,"RESTORE_RD_PHY_OLD"   ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_RESTORE_RE_PHY_OLD      ,"RESTORE_RE_PHY_OLD"   ,Tcontrol_t        ,1                                   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
    }

    // ~~~~~[ Interface : "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("retire_event",OUT,SOUTH, _("Interface to update rename_unit."),_param->_nb_front_end,_param->_nb_context[it1]);
    
      _ALLOC2_VALACK_OUT     (out_RETIRE_EVENT_VAL   ,VAL,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_VALACK_IN      ( in_RETIRE_EVENT_ACK   ,ACK,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT     (out_RETIRE_EVENT_STATE ,"state"      ,Tevent_state_t    ,_param->_size_event_state,_param->_nb_front_end,_param->_nb_context[it1]);
//    _ALLOC2_SIGNAL_OUT     (out_RETIRE_EVENT_FLUSH ,"flush"      ,Tcontrol_t        ,1                        ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT     (out_RETIRE_EVENT_STOP  ,"stop"       ,Tcontrol_t        ,1                        ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT_COND(out_RETIRE_EVENT_TYPE  ,"type"       ,Tevent_type_t     ,_param->_size_event_type ,_param->_nb_front_end,_param->_nb_context[it1],_param->_front_end_rat_scheme[it1] == RAT_DEPTH_SAVE);
      _ALLOC2_SIGNAL_OUT_COND(out_RETIRE_EVENT_DEPTH ,"depth"      ,Tdepth_t          ,_param->_size_depth      ,_param->_nb_front_end,_param->_nb_context[it1],_param->_front_end_rat_scheme[it1] == RAT_DEPTH_SAVE);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Interface : "commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("commit",IN,EAST,_("End of execute."),_param->_nb_inst_commit);

      ALLOC1_VALACK_IN ( in_COMMIT_VAL               ,VAL);
      ALLOC1_VALACK_OUT(out_COMMIT_ACK               ,ACK);
      ALLOC1_SIGNAL_IN ( in_COMMIT_WEN               ,"wen"        ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_IN ( in_COMMIT_PACKET_ID         ,"packet_id"  ,Tpacket_t         ,_param->_size_rob_ptr         );
//    ALLOC1_SIGNAL_IN ( in_COMMIT_OPERATION         ,"operation"  ,Toperation_t      ,_param->_size_operation       );
//    ALLOC1_SIGNAL_IN ( in_COMMIT_TYPE              ,"type"       ,Ttype_t           ,_param->_size_type            );
      ALLOC1_SIGNAL_IN ( in_COMMIT_CANCEL            ,"cancel"     ,Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_IN ( in_COMMIT_FLAGS             ,"flags"      ,Tspecial_data_t   ,_param->_size_special_data    );
      ALLOC1_SIGNAL_IN ( in_COMMIT_EXCEPTION         ,"exception"  ,Texception_t      ,_param->_size_exception       );
      ALLOC1_SIGNAL_IN ( in_COMMIT_NO_SEQUENCE       ,"no_sequence",Tcontrol_t        ,1                             );
      ALLOC1_SIGNAL_IN ( in_COMMIT_ADDRESS           ,"address"    ,Taddress_t        ,_param->_size_instruction_address);
//    ALLOC1_SIGNAL_OUT(out_COMMIT_NUM_REG_RD        ,"num_reg_rd" ,Tgeneral_address_t,_param->_size_general_register+_param->_size_rename_unit_id);
      ALLOC1_SIGNAL_OUT(out_COMMIT_NUM_REG_RD        ,"num_reg_rd" ,Tgeneral_address_t,_param->_size_general_register);

      ALLOC1_INTERFACE_END(_param->_nb_inst_commit);
    }

    // ~~~~~[ Interface : "reexecute" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("reexecute",OUT,EAST,_("Interface to reexecute an instruction (store)"),_param->_nb_inst_reexecute);

      ALLOC1_VALACK_OUT(out_REEXECUTE_VAL                  ,VAL);
      ALLOC1_VALACK_IN ( in_REEXECUTE_ACK                  ,ACK);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_PACKET_ID            ,"packet_id"            ,Tpacket_t         ,_param->_size_rob_ptr  );
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type);
      ALLOC1_SIGNAL_OUT(out_REEXECUTE_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr);

      ALLOC1_INTERFACE_END(_param->_nb_inst_reexecute);
    }

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("branch_complete",OUT,WEST,_("Interface to reexecute an instruction (store)"),_param->_nb_inst_branch_complete);

      ALLOC1_VALACK_OUT(out_BRANCH_COMPLETE_VAL            ,VAL);
      ALLOC1_VALACK_IN ( in_BRANCH_COMPLETE_ACK            ,ACK);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_CONTEXT_ID     ,"context_id"     ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_FRONT_END_ID   ,"front_end_id"   ,Tcontext_t         ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_DEPTH          ,"depth"          ,Tdepth_t           ,_param->_size_depth    );
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_ADDRESS        ,"address"        ,Taddress_t         ,_param->_size_instruction_address);
//    ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_FLAG           ,"flag"           ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_NO_SEQUENCE    ,"no_sequence"    ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_MISS_PREDICTION,"miss_prediction",Tcontrol_t         ,1);

      ALLOC1_INTERFACE_END(_param->_nb_inst_branch_complete);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("update", OUT, WEST,_("Interface with to Context State."));

      ALLOC0_VALACK_OUT(out_UPDATE_VAL                      ,VAL);
      ALLOC0_VALACK_IN ( in_UPDATE_ACK                      ,ACK);
      ALLOC0_SIGNAL_OUT(out_UPDATE_CONTEXT_ID               ,"context_id"      ,Tcontext_t         ,_param->_size_context_id);
      ALLOC0_SIGNAL_OUT(out_UPDATE_FRONT_END_ID             ,"front_end_id"    ,Tcontext_t         ,_param->_size_front_end_id);
      ALLOC0_SIGNAL_OUT(out_UPDATE_DEPTH                    ,"depth"           ,Tdepth_t           ,_param->_size_depth    );
      ALLOC0_SIGNAL_OUT(out_UPDATE_TYPE                     ,"type"            ,Tevent_type_t      ,_param->_size_event_type);
      ALLOC0_SIGNAL_OUT(out_UPDATE_IS_DELAY_SLOT            ,"is_delay_slot"   ,Tcontrol_t         ,1);
      ALLOC0_SIGNAL_OUT(out_UPDATE_ADDRESS                  ,"address"         ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC0_SIGNAL_OUT(out_UPDATE_ADDRESS_EPCR_VAL         ,"address_epcr_val",Tcontrol_t         ,1);
      ALLOC0_SIGNAL_OUT(out_UPDATE_ADDRESS_EPCR             ,"address_epcr"    ,Taddress_t         ,_param->_size_instruction_address);
      ALLOC0_SIGNAL_OUT(out_UPDATE_ADDRESS_EEAR_VAL         ,"address_eear_val",Tcontrol_t         ,1);
      ALLOC0_SIGNAL_OUT(out_UPDATE_ADDRESS_EEAR             ,"address_eear"    ,Tgeneral_data_t    ,_param->_size_general_data);

      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("event",IN,WEST,_("Interface with Context State (event)."),_param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_VALACK_IN ( in_EVENT_VAL             , VAL                                                           ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_VALACK_OUT(out_EVENT_ACK             , ACK                                                           ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_EVENT_ADDRESS         ,"ADDRESS"         ,Taddress_t,_param->_size_instruction_address,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_EVENT_ADDRESS_NEXT    ,"ADDRESS_NEXT"    ,Taddress_t,_param->_size_instruction_address,_param->_nb_front_end, _param->_nb_context[it1]); 
      _ALLOC2_SIGNAL_IN ( in_EVENT_ADDRESS_NEXT_VAL,"ADDRESS_NEXT_VAL",Tcontrol_t,1                                ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_EVENT_IS_DS_TAKE      ,"IS_DS_TAKE"      ,Tcontrol_t,1                                ,_param->_nb_front_end, _param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }  

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("nb_inst",OUT,WEST,_("Interface with Context State (synchronization)."),_param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_SIGNAL_OUT(out_NB_INST_COMMIT_ALL             ,"commit_all",Tcounter_t         ,_param->_size_nb_inst_commit,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_NB_INST_COMMIT_MEM             ,"commit_mem",Tcounter_t         ,_param->_size_nb_inst_commit,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_NB_INST_DECOD_ALL              ,"decod_all" ,Tcounter_t         ,_param->_size_nb_inst_decod ,_param->_nb_front_end, _param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }

//  // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  {
//    ALLOC2_INTERFACE_BEGIN("depth",IN,WEST,_("Interface with Prediction unit."),_param->_nb_front_end, _param->_nb_context[it1]);
//
//    _ALLOC2_SIGNAL_IN ( in_DEPTH_MIN                     ,"min"      ,Tdepth_t           ,_param->_size_depth,_param->_nb_front_end, _param->_nb_context[it1]);
//    _ALLOC2_SIGNAL_IN ( in_DEPTH_MAX                     ,"max"      ,Tdepth_t           ,_param->_size_depth,_param->_nb_front_end, _param->_nb_context[it1]);
//    _ALLOC2_SIGNAL_IN ( in_DEPTH_FULL                    ,"full"     ,Tcontrol_t         ,1                  ,_param->_nb_front_end, _param->_nb_context[it1]);
//
//    ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
//  }


    // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("spr_read",IN ,EAST,_("Interface with special register file (read)."),_param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_SIGNAL_IN ( in_SPR_READ_SR_OVE                ,"sr_ove"    ,Tcontrol_t         ,1,_param->_nb_front_end, _param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }

    // ~~~~~[ Interface : "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("spr_write",OUT,EAST,_("Interface with special register file (write)."),_param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_VALACK_OUT(out_SPR_WRITE_VAL                    ,VAL,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_VALACK_IN ( in_SPR_WRITE_ACK                    ,ACK,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_WRITE_SR_F_VAL               ,"sr_f_val"    ,Tcontrol_t         ,1                         ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_WRITE_SR_F                   ,"sr_f"        ,Tcontrol_t         ,1                         ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_WRITE_SR_CY_VAL              ,"sr_cy_val"   ,Tcontrol_t         ,1                         ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_WRITE_SR_CY                  ,"sr_cy"       ,Tcontrol_t         ,1                         ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_WRITE_SR_OV_VAL              ,"sr_ov_val"   ,Tcontrol_t         ,1                         ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_WRITE_SR_OV                  ,"sr_ov"       ,Tcontrol_t         ,1                         ,_param->_nb_front_end, _param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }

#ifdef DEBUG_TEST
    {
      ALLOC0_INTERFACE_BEGIN("info",OUT,EAST,_("Information."));
      ALLOC0_SIGNAL_OUT(out_INFO_ROB_EMPTY                   ,"rob_empty"   ,bool               ,1);
      ALLOC0_INTERFACE_END();
    }
#endif

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
    ALLOC1(internal_BANK_INSERT_VAL             ,Tcontrol_t,_param->_nb_bank);
    ALLOC1(internal_BANK_INSERT_NUM_RENAME_UNIT ,uint32_t  ,_param->_nb_bank);
    ALLOC1(internal_BANK_INSERT_NUM_INST        ,uint32_t  ,_param->_nb_bank);

    ALLOC2(internal_BANK_COMMIT_VAL             ,Tcontrol_t,_param->_nb_bank,_param->_nb_bank_access_commit);
    ALLOC2(internal_BANK_COMMIT_NUM_INST        ,uint32_t  ,_param->_nb_bank,_param->_nb_bank_access_commit);
    ALLOC2(internal_BANK_COMMIT_ENTRY           ,entry_t * ,_param->_nb_bank,_param->_nb_bank_access_commit);

    ALLOC1(internal_BANK_RETIRE_VAL               ,Tcontrol_t,_param->_nb_bank);
    ALLOC1(internal_BANK_RETIRE_NUM_RENAME_UNIT   ,uint32_t  ,_param->_nb_bank);
    ALLOC1(internal_BANK_RETIRE_NUM_INST          ,uint32_t  ,_param->_nb_bank);
//  ALLOC1(internal_BANK_RETIRE_RESTORE           ,Tcontrol_t,_param->_nb_bank);
    ALLOC1(internal_BANK_RETIRE_RESTORE_RD_PHY_OLD,Tcontrol_t,_param->_nb_bank);
    ALLOC1(internal_BANK_RETIRE_RESTORE_RE_PHY_OLD,Tcontrol_t,_param->_nb_bank);

    ALLOC1(internal_REEXECUTE_VAL               ,Tcontrol_t,_param->_nb_inst_reexecute);
    ALLOC1(internal_REEXECUTE_NUM_BANK          ,uint32_t  ,_param->_nb_inst_reexecute);

    ALLOC1(internal_BRANCH_COMPLETE_VAL         ,Tcontrol_t,_param->_nb_inst_branch_complete);
    ALLOC1(internal_BRANCH_COMPLETE_NUM_BANK    ,uint32_t  ,_param->_nb_inst_branch_complete);

    ALLOC2(internal_EVENT_ACK                   ,Tcontrol_t,_param->_nb_front_end,_param->_nb_context[it1]);
    ALLOC2(internal_RETIRE_EVENT_VAL            ,Tcontrol_t,_param->_nb_front_end,_param->_nb_context[it1]);

    ALLOC3(internal_rat_gpr_update_table        ,bool      ,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_general_register_logic);
    ALLOC3(internal_rat_spr_update_table        ,bool      ,_param->_nb_front_end,_param->_nb_context[it1],_param->_nb_special_register_logic);


    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    ALLOC2     (_nb_cycle_idle           ,double               ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC1     (_rob                     ,std::list<entry_t*>  ,_param->_nb_bank);
               
    ALLOC1     (reg_BANK_PTR             ,uint32_t             ,_param->_nb_bank);
                                                          
    ALLOC2     (reg_NB_INST_COMMIT_ALL   ,Tcounter_t           ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_NB_INST_COMMIT_MEM   ,Tcounter_t           ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC3_COND(reg_NB_INST_DEPTH        ,Tcounter_t           ,_param->_nb_front_end,_param->_nb_context [it1],_param->_nb_branch_speculated[it1][it2],_param->_front_end_rat_scheme[it1] == RAT_DEPTH_SAVE);
    ALLOC2     (reg_EVENT_STATE          ,Tcommit_event_state_t,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_TYPE           ,Tevent_type_t        ,_param->_nb_front_end,_param->_nb_context [it1]);
//  ALLOC2     (reg_EVENT_FLUSH          ,bool                 ,_param->_nb_front_end,_param->_nb_context [it1]);
//  ALLOC2     (reg_EVENT_STOP           ,bool                 ,_param->_nb_front_end,_param->_nb_context [it1]);
//  ALLOC2     (reg_EVENT_NUM_BANK       ,uint32_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
//  ALLOC2     (reg_EVENT_NUM_PTR        ,uint32_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
//  ALLOC2     (reg_EVENT_CAN_RESTART    ,bool                 ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_PACKET         ,uint32_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_DEPTH          ,Tdepth_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_NB_INST        ,uint32_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_LAST           ,bool                 ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_LAST_NUM_BANK  ,uint32_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_LAST_NUM_PTR   ,uint32_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
               
    ALLOC2     (reg_EVENT_NEXT_STOP      ,bool                 ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_EVENT_NEXT_PACKET    ,uint32_t             ,_param->_nb_front_end,_param->_nb_context [it1]);
                                                               
//  ALLOC2     (reg_PC_PREVIOUS          ,Taddress_t           ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_PC_CURRENT           ,Taddress_t           ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_PC_CURRENT_IS_DS     ,Taddress_t           ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_PC_CURRENT_IS_DS_TAKE,Taddress_t           ,_param->_nb_front_end,_param->_nb_context [it1]);
    ALLOC2     (reg_PC_NEXT              ,Taddress_t           ,_param->_nb_front_end,_param->_nb_context [it1]);
               
    ALLOC3     (rat_gpr_update_table     ,bool                 ,_param->_nb_front_end,_param->_nb_context [it1],_param->_nb_general_register_logic);
    ALLOC3     (rat_spr_update_table     ,bool                 ,_param->_nb_front_end,_param->_nb_context [it1],_param->_nb_special_register_logic);

    
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _priority_insert  = new generic::priority::Priority (_name+"_priority_insert",
							 _param->_priority      ,
							 _param->_load_balancing,
							 _param->_nb_rename_unit,
							 _param->_nb_inst_insert,
							 _param->_nb_rename_unit_select);

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

#if defined(DEBUG) and defined(DEBUG_Commit_unit) and (DEBUG_Commit_unit == true)
    if (log_file_generate)
      {
	directory_init ();
	
	instruction_log_file = new std::ofstream [_param->_nb_thread];
	for (uint32_t i=0; i<_param->_nb_thread; ++i)
	  if (_param->_have_thread [i])
	    {
	      
	      std::string filename = morpheo::filename(MORPHEO_LOG,
						       "Instruction_flow-thread_"+toString(i),
						       "",
						       "log",
						       _simulation_file_with_date,
						       _simulation_file_with_pid ,
						       true);
	      
	      instruction_log_file [i].open(filename.c_str() ,std::ios::out | std::ios::trunc);
	    }
      }
#endif

    log_end(Commit_unit,FUNCTION);
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
