/*
 * $Id: Parameters_msg_error.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {


#undef  FUNCTION
#define FUNCTION "OOO_Engine::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(OOO_Engine,FUNCTION);

    Parameters_test test ("OOO_Engine");

    bool _is_link [_nb_rename_unit];
    for (uint32_t i=0; i<_nb_rename_unit; i++)
      _is_link[i] = false;

    for (uint32_t i=0; i<_nb_front_end; i++)
      {
        uint32_t x = _link_rename_unit_with_front_end [i];

        if (x >= _nb_rename_unit)
          test.error(toString(_("Front_end [%d] is linked with invalid rename_unit.\n"),i));
        else
          {
            if (_is_link [x])
              test.error(toString(_("Front_end [%d] can't be connected with multiple rename_unit.\n"),i));
            else
              _is_link [x] = true;
          }
      }

    for (uint32_t i=0; i<_nb_rename_unit; i++)
      if (_is_link[i] == false)
        test.error(toString(_("Rename_unit [%d] is not linked with front_end.\n"),i));

    log_end(OOO_Engine,FUNCTION);

    return test;
  };

}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
