#ifdef SYSTEMC
/*
 * $Id: RegisterFile_Internal_Banked_genMealy_read.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Internal_Banked/include/RegisterFile_Internal_Banked.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_internal_banked    {

#undef  FUNCTION
#define FUNCTION "RegisterFile_Internal_Banked::genMealy_read"
  void RegisterFile_Internal_Banked::genMealy_read (void)
  {
    log_begin(RegisterFile_Internal_Banked,FUNCTION);
    log_function(RegisterFile_Internal_Banked,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_port_read; i++)
      {
	// Have a write?
 	if ( PORT_READ(in_READ_VAL [i]) == 1)
 	  {
	    Taddress_t address;
	    if (_param->_have_port_address)
	      address = PORT_READ(in_READ_ADDRESS[i]);
	    else
	      address = 0;
	    Tdata_t    data    = reg_DATA[address];

	    log_printf(TRACE,RegisterFile,FUNCTION,"  * [%d] -> %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));

	    // Write in registerFile
	    PORT_WRITE(out_READ_DATA[i],data);
 	  }
	else
	  {
	    //log_printf(TRACE,RegisterFile,FUNCTION,"Read [%d] : No   transaction",i);
	    PORT_WRITE(out_READ_DATA[i],0);
	  }
      }
      }

    log_end(RegisterFile_Internal_Banked,FUNCTION);
  };

}; // end namespace registerfile_internal_banked
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
