#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Load_store_unit_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Load_store_unit_h

/*
 * $Id: Load_store_unit.h 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 * Ce composant peut tre amlior en placant deux ptr de lecture au lieu d'un : un pour l'accs au cache et un pour le commit
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Queue_Control/include/Queue_Control.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Types.h"
#include "Behavioural/Generic/Queue_Control/include/Queue_Control.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include <iostream>
#include <fstream>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


  class Load_store_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

  private   : counter_t                      * _stat_use_store_queue;
  private   : counter_t                      * _stat_use_load_queue;
  private   : counter_t                      * _stat_use_speculative_access_queue;

  private   : counter_t                      * _stat_average_use_store_queue;
  private   : counter_t                      * _stat_average_use_load_queue;
  private   : counter_t                      * _stat_average_use_speculative_access_queue;

  private   : counter_t                      * _stat_percent_use_store_queue;
  private   : counter_t                      * _stat_percent_use_load_queue;
  private   : counter_t                      * _stat_percent_use_speculative_access_queue;

  private   : counter_t                      * _stat_nb_inst_load;
  private   : counter_t                      * _stat_nb_inst_load_commit_speculative;
  private   : counter_t                      * _stat_nb_inst_load_commit_miss;

//   private   : counter_t                      * _stat_nb_load_miss_speculation;
//   private   : counter_t                      * _stat_nb_head_ko;

//   private   : counter_t                      * _stat_nb_inst_load;
//   private   : counter_t                      * _stat_nb_inst_store;
//   private   : counter_t                      * _stat_nb_inst_lock;
//   private   : counter_t                      * _stat_nb_inst_prefetch;
//   private   : counter_t                      * _stat_nb_inst_invalid;
//   private   : counter_t                      * _stat_nb_inst_flush;
//   private   : counter_t                      * _stat_nb_inst_sync;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "memory_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_MEMORY_IN_VAL                  ;//[nb_inst_memory]
  public    : SC_OUT(Tcontrol_t        )   ** out_MEMORY_IN_ACK                  ;//[nb_inst_memory]
  public    : SC_IN (Tcontext_t        )   **  in_MEMORY_IN_CONTEXT_ID           ;//[nb_inst_memory]
  public    : SC_IN (Tcontext_t        )   **  in_MEMORY_IN_FRONT_END_ID         ;//[nb_inst_memory]
  public    : SC_IN (Tcontext_t        )   **  in_MEMORY_IN_OOO_ENGINE_ID        ;//[nb_inst_memory]
  public    : SC_IN (Tpacket_t         )   **  in_MEMORY_IN_PACKET_ID            ;//[nb_inst_memory]
  public    : SC_IN (Toperation_t      )   **  in_MEMORY_IN_OPERATION            ;//[nb_inst_memory]
  public    : SC_IN (Ttype_t           )   **  in_MEMORY_IN_TYPE                 ;//[nb_inst_memory]
  public    : SC_IN (Tcontrol_t        )   **  in_MEMORY_IN_CANCEL               ;//[nb_inst_memory]
  public    : SC_IN (Tlsq_ptr_t        )   **  in_MEMORY_IN_STORE_QUEUE_PTR_WRITE;//[nb_inst_memory]
  public    : SC_IN (Tlsq_ptr_t        )   **  in_MEMORY_IN_STORE_QUEUE_PTR_READ ;//[nb_inst_memory]
  public    : SC_IN (Tcontrol_t        )   **  in_MEMORY_IN_STORE_QUEUE_EMPTY    ;//[nb_inst_memory]
  public    : SC_IN (Tlsq_ptr_t        )   **  in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE ;//[nb_inst_memory]
  public    : SC_IN (Tcontrol_t        )   **  in_MEMORY_IN_HAS_IMMEDIAT         ;//[nb_inst_memory]
  public    : SC_IN (Tgeneral_data_t   )   **  in_MEMORY_IN_IMMEDIAT             ;//[nb_inst_memory] // memory address
  public    : SC_IN (Tgeneral_data_t   )   **  in_MEMORY_IN_DATA_RA              ;//[nb_inst_memory] // memory address
  public    : SC_IN (Tgeneral_data_t   )   **  in_MEMORY_IN_DATA_RB              ;//[nb_inst_memory] // data        (store)
  public    : SC_IN (Tspecial_data_t   )   **  in_MEMORY_IN_DATA_RC              ;//[nb_inst_memory]
  public    : SC_IN (Tcontrol_t        )   **  in_MEMORY_IN_WRITE_RD             ;//[nb_inst_memory] // = (operation==load)
  public    : SC_IN (Tgeneral_address_t)   **  in_MEMORY_IN_NUM_REG_RD           ;//[nb_inst_memory] // destination (load)
  public    : SC_IN (Tcontrol_t        )   **  in_MEMORY_IN_WRITE_RE             ;//[nb_inst_memory]
  public    : SC_IN (Tspecial_address_t)   **  in_MEMORY_IN_NUM_REG_RE           ;//[nb_inst_memory]

    // ~~~~~[ Interface "memory_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_MEMORY_OUT_VAL                 ;//[nb_inst_memory]
  public    : SC_IN (Tcontrol_t        )   **  in_MEMORY_OUT_ACK                 ;//[nb_inst_memory]
  public    : SC_OUT(Tcontext_t        )   ** out_MEMORY_OUT_CONTEXT_ID          ;//[nb_inst_memory]
  public    : SC_OUT(Tcontext_t        )   ** out_MEMORY_OUT_FRONT_END_ID        ;//[nb_inst_memory]
  public    : SC_OUT(Tcontext_t        )   ** out_MEMORY_OUT_OOO_ENGINE_ID       ;//[nb_inst_memory]
  public    : SC_OUT(Tpacket_t         )   ** out_MEMORY_OUT_PACKET_ID           ;//[nb_inst_memory]
//public    : SC_OUT(Toperation_t      )   ** out_MEMORY_OUT_OPERATION           ;//[nb_inst_memory]
//public    : SC_OUT(Ttype_t           )   ** out_MEMORY_OUT_TYPE                ;//[nb_inst_memory]
  public    : SC_OUT(Tcontrol_t        )   ** out_MEMORY_OUT_CANCEL              ;//[nb_inst_memory]
  public    : SC_OUT(Tcontrol_t        )   ** out_MEMORY_OUT_WRITE_RD            ;//[nb_inst_memory] // = (operation==load)
  public    : SC_OUT(Tgeneral_address_t)   ** out_MEMORY_OUT_NUM_REG_RD          ;//[nb_inst_memory] // destination (load)
  public    : SC_OUT(Tgeneral_data_t   )   ** out_MEMORY_OUT_DATA_RD             ;//[nb_inst_memory] // data        (load)
  public    : SC_OUT(Tcontrol_t        )   ** out_MEMORY_OUT_WRITE_RE            ;//[nb_inst_memory]
  public    : SC_OUT(Tspecial_address_t)   ** out_MEMORY_OUT_NUM_REG_RE          ;//[nb_inst_memory]
  public    : SC_OUT(Tspecial_data_t   )   ** out_MEMORY_OUT_DATA_RE             ;//[nb_inst_memory]
  public    : SC_OUT(Texception_t      )   ** out_MEMORY_OUT_EXCEPTION           ;//[nb_inst_memory]
  public    : SC_OUT(Tcontrol_t        )   ** out_MEMORY_OUT_NO_SEQUENCE         ;//[nb_inst_memory]
  public    : SC_OUT(Taddress_t        )   ** out_MEMORY_OUT_ADDRESS             ;//[nb_inst_memory]
    
    // ~~~~~[ Interface "dcache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_DCACHE_REQ_VAL                 ;//[nb_cache_port]
  public    : SC_IN (Tcontrol_t        )   **  in_DCACHE_REQ_ACK                 ;//[nb_cache_port]
  public    : SC_OUT(Tcontext_t        )   ** out_DCACHE_REQ_CONTEXT_ID          ;//[nb_cache_port]
  public    : SC_OUT(Tpacket_t         )   ** out_DCACHE_REQ_PACKET_ID           ;//[nb_cache_port]
  public    : SC_OUT(Tdcache_address_t )   ** out_DCACHE_REQ_ADDRESS             ;//[nb_cache_port]
  public    : SC_OUT(Tdcache_type_t    )   ** out_DCACHE_REQ_TYPE                ;//[nb_cache_port]
  public    : SC_OUT(Tdcache_data_t    )   ** out_DCACHE_REQ_WDATA               ;//[nb_cache_port]

    // ~~~~~[ Interface "dcache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_DCACHE_RSP_VAL                 ;//[nb_cache_port]
  public    : SC_OUT(Tcontrol_t        )   ** out_DCACHE_RSP_ACK                 ;//[nb_cache_port]
  public    : SC_IN (Tcontext_t        )   **  in_DCACHE_RSP_CONTEXT_ID          ;//[nb_cache_port]
  public    : SC_IN (Tpacket_t         )   **  in_DCACHE_RSP_PACKET_ID           ;//[nb_cache_port]
  public    : SC_IN (Tdcache_data_t    )   **  in_DCACHE_RSP_RDATA               ;//[nb_cache_port]
  public    : SC_IN (Tdcache_error_t   )   **  in_DCACHE_RSP_ERROR               ;//[nb_cache_port]

    // ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_BYPASS_MEMORY_VAL          ; //[nb_bypass_memory]
  public    : SC_OUT(Tcontext_t        )   ** out_BYPASS_MEMORY_OOO_ENGINE_ID; //[nb_bypass_memory]
  public    : SC_OUT(Tgeneral_address_t)   ** out_BYPASS_MEMORY_NUM_REG      ; //[nb_bypass_memory]
  public    : SC_OUT(Tgeneral_data_t   )   ** out_BYPASS_MEMORY_DATA         ; //[nb_bypass_memory]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : Tstore_queue_entry_t                                        * _store_queue                     ;//[size_store_queue]
  protected : Tload_queue_entry_t                                         * _load_queue                      ;//[size_load_queue]
  protected : Tspeculative_access_queue_entry_t                           * _speculative_access_queue        ;//[size_speculative_access_queue]
  protected : morpheo::behavioural::generic::queue_control::Queue_Control * _speculative_access_queue_control;

    // function pointer
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_transition     ) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMoore       ) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMealy_dcache) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMealy_insert) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMealy_retire) (void);

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // Registers
  public    : Tlsq_ptr_t                    * reg_STORE_QUEUE_NB_CHECK     ;//[size_store_queue]
//public    : Tcontrol_t                    * reg_STORE_QUEUE_INVALID      ;//[size_store_queue]
  public    : Tlsq_ptr_t                      reg_STORE_QUEUE_PTR_READ     ;
//public    : Tlsq_ptr_t                      reg_LOAD_QUEUE_PTR_READ      ;
  public    : Tlsq_ptr_t                      reg_LOAD_QUEUE_CHECK_PRIORITY;

    // signal
  public    : Tlsq_ptr_t                      internal_SPECULATIVE_ACCESS_QUEUE_PTR_READ ;
					     
  private   : Tcontrol_t                      internal_MEMORY_IN_ACK          ;
  private   : uint32_t                        internal_MEMORY_IN_PORT         ;

  private   : Tcontrol_t                      internal_MEMORY_OUT_VAL         ;
  private   : Tselect_queue_t                 internal_MEMORY_OUT_SELECT_QUEUE;
  private   : Tlsq_ptr_t                      internal_MEMORY_OUT_PTR         ;
					     
  private   : Tcontrol_t                      internal_DCACHE_RSP_ACK         ;
  private   : Tcontrol_t                      internal_DCACHE_REQ_VAL         ;
  private   : Tselect_queue_t                 internal_DCACHE_REQ_SELECT_QUEUE;

#if defined(DEBUG) and defined(DEBUG_Load_store_unit) and (DEBUG_Load_store_unit == true)
  private   : std::ofstream                 * memory_log_file;
#endif

#endif


    // -----[ methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Load_store_unit);
#endif
  public  :          Load_store_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage );
  public  :          ~Load_store_unit             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);

  public  : void     constant                  (void);
  public  : void     transition                (void);
  public  : void     genMoore                  (void);
  public  : void     genMealy_dcache           (void);
  public  : void     genMealy_insert           (void);
  public  : void     genMealy_retire           (void);
   
  public  : void     function_speculative_load_commit_transition      (void);
  public  : void     function_speculative_load_commit_genMoore        (void);
  public  : void     function_speculative_load_commit_genMealy_dcache (void);
  public  : void     function_speculative_load_commit_genMealy_insert (void);
  public  : void     function_speculative_load_commit_genMealy_retire (void);
#endif					       

#ifdef STATISTICS
  public  : void     statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void     statistics_deallocation   (void);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
